/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes ncessaires  l'dition d'un remboursement
 */

package org.opensi.facturation.reglements.clients;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;

import org.opensi.api.SessionOSI;
import org.opensi.facturation.DocumentUtils;
import org.opensi.util.tools.DateTime;

public class DataRemboursement {

	
	protected String dossierId;
	protected boolean logoAdr;
	protected String urlLogo = "";
	protected String dateCourante;
	
	protected String raisonSociale;
	protected String adresse1;
	protected String adresse2;
	protected String adresse3;
	protected String codePostal;
	protected String ville;
	protected String tel;
	protected String fax;
	protected String email;
	protected String web;
	protected String siren;
	protected String typeSociete;
	protected double capital;
	protected String tvaIntra;
	protected String rcs;
	
	protected String denominationDest;
	protected String adresse1Dest;
	protected String adresse2Dest;
	protected String adresse3Dest;
	protected String codePostalDest;
	protected String villeDest;
	protected String paysDest;
	
	protected String modeReglement;
	protected double montant;
	protected String commentaires;
	protected ArrayList<String> listeReglements = new ArrayList<String>(10);
	protected ArrayList<String> listeAvoirs = new ArrayList<String>(10);

	
	
	public DataRemboursement(SessionOSI sosi, int remboursementId, String denomination, String adresse1, String adresse2, String adresse3, String codePostal, String ville, String codePays) {

		try {
			Connection con = sosi.getConnection();
			Statement stt = con.createStatement();
			String base = sosi.getBaseDossier();
			this.dossierId = sosi.getDossierId();
			this.urlLogo = sosi.getLogosDirectory() + dossierId +".jpg";
			this.dateCourante = DateTime.formatTime(new DateTime().getTimeInMillis(), "dd/MM/yyyy");
			
			String reqLogo = "select Logo_Adr from "+ base +".PARAM_DOSSIER";
			ResultSet rset = stt.executeQuery(reqLogo);
			rset.next();
			this.logoAdr = rset.getInt("Logo_Adr")==1;
			rset.close();
			
			// coordonnes de l'entreprise
			String reqSociete = "select s.Ville_RCS, s.Num_TVA_Intra, ts.Libelle as Type_Societe, s.Montant_Capital, s.Num_SIRET, s.Denomination,";
			reqSociete += " s.Adresse_1, s.Adresse_2, s.Adresse_3, s.Code_Postal, s.Ville, s.Telephone, s.Fax, s.Email, s.Site_Web";
			reqSociete += " from "+ base +".SOCIETE s join "+ base +".TYPE_SOCIETE ts on s.Type_Societe=ts.Type_Societe_Id";
			rset = stt.executeQuery(reqSociete);
			rset.next();
			this.raisonSociale = rset.getString("Denomination");
			this.adresse1 = rset.getString("Adresse_1");
			this.adresse2 = rset.getString("Adresse_2");
			this.adresse3 = rset.getString("Adresse_3");
			this.codePostal = rset.getString("Code_Postal");
			this.ville = rset.getString("Ville");
			this.tel = rset.getString("Telephone");
			this.fax = rset.getString("Fax");
			this.email = rset.getString("Email");
			this.web = rset.getString("Site_Web");
			this.siren = DocumentUtils.formatSiren(rset.getString("Num_SIRET"));
			this.typeSociete = rset.getString("Type_Societe");
			this.capital = rset.getDouble("Montant_Capital");
			this.tvaIntra = rset.getString("Num_TVA_Intra");
			this.rcs = rset.getString("Ville_RCS");
			rset.close();
			
			this.denominationDest = denomination;
			this.adresse1Dest = adresse1;
			this.adresse2Dest = adresse2;
			this.adresse3Dest = adresse3;
			this.codePostalDest = codePostal;
			this.villeDest = ville;
			String reqPays = "select Nom_FR from PAYS where Code_Pays='"+ codePays +"'";
			rset = stt.executeQuery(reqPays);
			rset.next();
			this.paysDest = rset.getString("Nom_FR");
			rset.close();
			
			String reqRemboursement = "select rc.Commentaires, coalesce(mr.Libelle,'') as Mode_Reglement,";
			reqRemboursement += " (rc.Montant - rc.Montant_Restant) as Montant_Impute";
			reqRemboursement += " from "+ base +".REMBOURSEMENT_CLIENT rc";
			reqRemboursement += " left join "+ base +".MODE_REGLEMENT mr on rc.Mode_Reg_Id=mr.Mode_Reg_Id";
			reqRemboursement += " where rc.Remboursement_Id="+ remboursementId;
			rset = stt.executeQuery(reqRemboursement);
			rset.next();
			this.commentaires = rset.getString("Commentaires");
			this.modeReglement = rset.getString("Mode_Reglement");
			this.montant = rset.getDouble("Montant_Impute");
			rset.close();
			
			String reqListeReglements = "select Type, Date_Reglement, Num_Piece from (";
			reqListeReglements += " select 'R' as Type, rc.Num_Piece, rc.Date_Reg as Date_Reglement";
			reqListeReglements += " from "+ base +".REGLEMENT_CLIENT rc join "+ base +".IMPUTATION_REGLEMENT_CLIENT irc on irc.Reglement_Id=rc.Reglement_Id";
			reqListeReglements += " join "+ base +".IMPUTATION_REGLEMENT_REMBOURSEMENT_CLIENT irrc on irc.Imputation_Id=irrc.Imputation_Id";
			reqListeReglements += " where irrc.Remboursement_Id="+ remboursementId;
			reqListeReglements += " union";
			reqListeReglements += " select 'A' as Type, a.Num_Entier as Num_Piece, a.Date_Avoir as Date_Reglement";
			reqListeReglements += " from "+ base +".AVOIR a join "+ base +".IMPUTATION_AVOIR_CLIENT iac on iac.Avoir_Id=a.Avoir_Id";
			reqListeReglements += " join "+ base +".IMPUTATION_AVOIR_REMBOURSEMENT_CLIENT iarc on iac.Imputation_Id=iarc.Imputation_Id";
			reqListeReglements += " where iarc.Remboursement_Id="+ remboursementId;
			reqListeReglements += ") as t order by Type, Date_Reglement";
			rset = stt.executeQuery(reqListeReglements);
			while (rset.next()) {
				String libelle = "n\u00B0 "+ rset.getString("Num_Piece") + " du "+ DateTime.formatTime(rset.getLong("Date_Reglement"), "dd/MM/yyyy");
				if (rset.getString("Type").equals("R")) { this.listeReglements.add(libelle); }
				else { this.listeAvoirs.add(libelle); }
			}
			rset.close();
			
			stt.close();

		}
		catch(Exception e) {
			e.printStackTrace();
		}			
	}


} // fin DataRemboursement
