/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.facturation.reglements.clients;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.experlog.openeas.api.Session;



public class MajStatutCommandes {
	
	private Connection con;
	private String base;
	private Session s = null;
	
	PreparedStatement psCommandes;
	PreparedStatement psEcheances;
	PreparedStatement psReglementsAnticipes;
	PreparedStatement psMajCommande;

	
	public MajStatutCommandes (String s_) {
		try {
			this.s = Session.findClient(s_);
			this.con = s.getConnection(null);
			this.base = s.getCookie().get("BaseDossier");
			init(con,base);
		} catch(Exception e) {
			e.printStackTrace();
		}
	}
	public MajStatutCommandes (Connection con, String base) {
		try {
			this.con = con;
			this.base = base;
			init(con,base);
			
		} catch(Exception e) {
			e.printStackTrace();
		}
	}
	public void init (Connection con, String base) {
		try {

			String reqCommandes = "select cc.Commande_Id from "+ base +".COMMANDE_CLIENT cc join "+ base +".COMMANDE_CLIENT_FACTURE ccf on cc.Commande_Id=ccf.Commande_Id";
			reqCommandes += " join "+ base +".FACTURE_ECHEANCE_CLIENT fec on ccf.Facture_Id=fec.Facture_Id where fec.Echeance_Id=?";
			reqCommandes += " union select cc.Commande_Id from "+ base +".COMMANDE_CLIENT cc join "+ base +".ACOMPTE_CLIENT ac on cc.Commande_Id=ac.Commande_Id";
			reqCommandes += " join "+ base +".ACOMPTE_ECHEANCE_CLIENT aec on ac.Acompte_Id=aec.Acompte_Id and aec.Echeance_Id=?";
			psCommandes = con.prepareStatement(reqCommandes);
			
			String reqEcheances = "select ec.Etat from "+ base +".ECHEANCE_CLIENT ec join "+ base +".FACTURE_ECHEANCE_CLIENT fec on ec.Echeance_Id=fec.Echeance_Id";
			reqEcheances += " join "+ base +".COMMANDE_CLIENT_FACTURE ccf on fec.Facture_Id=ccf.Facture_Id and ccf.Commande_Id=?";
			reqEcheances += " union";
			reqEcheances += " select ec.Etat from "+ base +".ECHEANCE_CLIENT ec join "+ base +".ACOMPTE_ECHEANCE_CLIENT aec on ec.Echeance_Id=aec.Echeance_Id";
			reqEcheances += " join "+ base +".ACOMPTE_CLIENT ac on aec.Acompte_Id=ac.Acompte_Id and ac.Commande_Id=?";
			psEcheances = con.prepareStatement(reqEcheances);
			
			String reqReglementsAnticipes = "select if(cc.Total_TTC<=coalesce(sum(rc.Montant_Restant),0),'T',if(coalesce(sum(rc.Montant_Restant),0)>0,'P','N')) as Etat from "+ base +".COMMANDE_CLIENT cc";
			reqReglementsAnticipes += " join "+ base +".REGLEMENT_CLIENT rc on cc.Commande_Id=rc.Commande_Id and rc.Statut='C'";
			reqReglementsAnticipes += " left join "+ base +".ACOMPTE_CLIENT ac on cc.Commande_Id=ac.Commande_Id and ac.Statut='V'";
			reqReglementsAnticipes += " left join "+ base +".COMMANDE_CLIENT_FACTURE ccf on cc.Commande_Id=ccf.Commande_Id";
			reqReglementsAnticipes += " left join "+ base +".FACTURE f on ccf.Facture_Id=f.Facture_Id and f.Numero<>0";
			reqReglementsAnticipes += " where (ac.Acompte_Id is null or f.Facture_Id is null) and cc.Commande_Id=? group by cc.Commande_Id";
			psReglementsAnticipes = con.prepareStatement(reqReglementsAnticipes);
			
			String reqMajCommande = "update "+ base +".COMMANDE_CLIENT set Statut_Paiement=? where Commande_Id=?";
			psMajCommande = con.prepareStatement(reqMajCommande);
			
		} catch(Exception e) {
			e.printStackTrace();
		}
	}
	
	public void terminer() {
		try {
			psCommandes.close();
			psEcheances.close();
			psReglementsAnticipes.close();
			psMajCommande.close();
			
			if (s!=null) {
				s.closeConnection(this.con, null);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public void traiterEcheances (String listeEchId) {
		try {
			
			String listeEcheances[] = listeEchId.split(",");
			int nb = listeEcheances.length;

			for (int i=0; i<nb; i++) {
				int echeanceId = Integer.parseInt(listeEcheances[i]);
				psCommandes.setInt(1, echeanceId);
				psCommandes.setInt(2, echeanceId);
				ResultSet rset = psCommandes.executeQuery();
				while (rset.next()) {
					traiterCommande(rset.getInt("Commande_Id"));
				}
				rset.close();
			}
			
		} catch(Exception e) {
			e.printStackTrace();
		}
	}
	
	
	public void traiterCommande(int commandeId) throws SQLException {
		
		int statutPaiement = 0; // 0 -> non pay ; 1 -> pay totalement ; 2 -> pay partiellement
		String dernierEtat = "";
		
		psEcheances.setInt(1, commandeId);
		psEcheances.setInt(2, commandeId);
		ResultSet rset = psEcheances.executeQuery();
		while (statutPaiement!=2 && rset.next()) {
			if (dernierEtat.equals("")) {
				dernierEtat = rset.getString("Etat");
				if (dernierEtat.equals("T")) statutPaiement = 1;
				else if (dernierEtat.equals("P")) statutPaiement = 2;
			}
			else {
				if (!rset.getString("Etat").equals(dernierEtat)) statutPaiement = 2;
			}
		}
		rset.close();
		
		if (statutPaiement!=2) {
			psReglementsAnticipes.setInt(1, commandeId);
			rset = psReglementsAnticipes.executeQuery();
			if (rset.next()) {
				if (dernierEtat.equals("")) {
					dernierEtat = rset.getString("Etat");
					if (dernierEtat.equals("T")) statutPaiement = 1;
					else if (dernierEtat.equals("P")) statutPaiement = 2;
				}
				else {
					if (!rset.getString("Etat").equals(dernierEtat)) statutPaiement = 2;
				}
			}
			rset.close();
		}
		
		psMajCommande.setInt(1, statutPaiement);
		psMajCommande.setInt(2, commandeId);
		psMajCommande.executeUpdate();
		
	}

}
