/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration d'un pdf d'chances
 */

package org.opensi.facturation.reglements.clients;


import java.awt.Color;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;

import org.opensi.util.pdf.MultiPagesDocument;
import org.opensi.util.pdf.PdfWidths;
import org.opensi.util.pdf.TableBuilder;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;


public class PdfEcheances extends MultiPagesDocument {


private static final Font fontGen = new Font(Font.HELVETICA , 10, Font.NORMAL);
private static final Font fontLine = new Font(Font.HELVETICA , 8, Font.NORMAL);
private static final Font fontLineGras = new Font(Font.HELVETICA , 8, Font.BOLD);
private static final Font fontLinePetit = new Font(Font.HELVETICA , 7, Font.NORMAL);

private DecimalFormat numFormat = new DecimalFormat("0.00");
private SimpleDateFormat formatDate = new SimpleDateFormat("dd.MM.yy");
private SimpleDateFormat formatDateMois = new SimpleDateFormat("MM.yy");


private DataEcheances de;	   // les donnes dynamiques de la liste d'chances

private float[] widthsCols;
private int nbCols;



  public PdfEcheances(String tempdir, DataEcheances de) throws Exception {

		super(tempdir);
		
		this.de = de;
		
		DecimalFormatSymbols dfs = new DecimalFormatSymbols();
		dfs.setDecimalSeparator('.');
		dfs.setGroupingSeparator(' ');
		
		numFormat.setDecimalFormatSymbols(dfs);
		numFormat.setNegativeSuffix("");
		numFormat.setNegativePrefix("-");
		numFormat.setPositiveSuffix(" ");
		numFormat.setGroupingUsed(true);
		numFormat.setGroupingSize(3);
		
		PdfWidths pw = new PdfWidths();

		pw.addColonneVariableMin(1,10);
		pw.addColonneVariableMin(1,10);
		pw.addColonneVariableMin(1,20);
		pw.addColonneVariableMin(1,10);
		pw.addColonneVariableMin(1,10);
		pw.addColonneVariableMin(1,10);
		pw.addColonneVariableMin(1,10);
		if (!de.historique) {
			pw.addColonneVariableMin(1,10);
			pw.addColonneVariableMin(1,10);
		}
		
		nbCols = pw.getNbCols();
		widthsCols = pw.getWidthsCols();
	}


	
	/* implmentation des fonctions de MultiPagesDocument */
	
	public PdfPTable firstHeader() throws DocumentException {
		
		TableBuilder tb = new TableBuilder();
		
		tb.add(makeEntete());
		tb.add(makeSpace(5));
		tb.add(makeEntetesColonnes());		
		
		return tb.getTable();	
	}
	
	
	public PdfPTable middleHeader(int lastLine) throws DocumentException {
		
		TableBuilder tb = new TableBuilder();
		
		tb.add(firstHeader());
		
		return tb.getTable();
	}
	
	
	public PdfPTable lastFooter() throws DocumentException {
		
		TableBuilder tb = new TableBuilder();
		
		tb.add(makeSpace(5));
		
		return tb.getTable();
	}
	
	
	public PdfPTable middleFooter(int nbLinesPage, int lastLine) throws DocumentException {
			
		TableBuilder tb = new TableBuilder();
		
		tb.add(lastFooter());
		
		return tb.getTable();		
	}
	
	
	public PdfPTable bodyLine(int numLine) throws DocumentException {
		
		LigneEcheances le = de.lignes.get(numLine);
		
		switch (le.type) {			
			case 'L':	return makeLine(le);
			case 'D':	return makeLineDetail(le);
			case 'R':	return makeLineRegul(le);
			case 'T':	return makeLineSousTotal(le);
			case 'G':
			default: return makeTotalGeneral(le);
		}
	}
	
	
	public PdfPTable emptyLine(float emptyHeight) throws DocumentException {
		
		PdfPTable pptSpace = new PdfPTable(nbCols);
		pptSpace.setWidthPercentage(100);
		pptSpace.setWidths(widthsCols);
		
		PdfPCell cell = new PdfPCell(pptSpace.getDefaultCell());
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setPaddingBottom(0);
		cell.setPaddingTop(0);
		cell.setFixedHeight(emptyHeight);		
		cell.setPhrase(new Phrase(""));		
	
		for (int i=0; i<nbCols; i++) {
			pptSpace.addCell(cell);
		}
	
		return pptSpace;
	}
	
	
	public int nbLines() {
		return de.getNbLignes();
	}
	
	
	public int nbEx() {
	
		return 1;
	}
	
	
	public Image imageFond() {
	
		return null;
	}



	/* mthodes internes */
		

	private PdfPTable makeSpace(int space) {
	
		PdfPTable pptSpace = new PdfPTable(1);
		PdfPCell cell = new PdfPCell(pptSpace.getDefaultCell());
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setFixedHeight(space);
		cell.setPhrase(new Phrase(""));
	
		pptSpace.addCell(cell);
	
		return pptSpace;
	}
	

	private PdfPTable makeEntete() throws DocumentException {
	
		PdfPTable bandeau = new PdfPTable(1);

		bandeau.setWidthPercentage(100);

		PdfPTable entete = new PdfPTable(3);

		PdfPCell cellEntete = new PdfPCell(entete.getDefaultCell());

		cellEntete.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellEntete.setBorderWidth(0);
		cellEntete.setMinimumHeight(10);

		cellEntete.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellEntete.setBorderWidth(0);
		cellEntete.setMinimumHeight(10);

		cellEntete.setPhrase(new Phrase("Dossier : " + de.dossierId, fontGen));
		entete.addCell(cellEntete);

		cellEntete.setPhrase(new Phrase(de.raisonSociale, fontGen));
		cellEntete.setColspan(2);
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		entete.addCell(cellEntete);
		cellEntete.setColspan(1);

		cellEntete.setPhrase(new Phrase("Date : " + de.dateCourante, fontGen));
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		entete.addCell(cellEntete);

		cellEntete.setPhrase(new Phrase(de.adresse1, fontGen));
		cellEntete.setColspan(2);
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		entete.addCell(cellEntete);
		cellEntete.setColspan(1);

		cellEntete.setPhrase(new Phrase("", fontGen));
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		entete.addCell(cellEntete);

		cellEntete.setPhrase(new Phrase(de.adresse2, fontGen));
		cellEntete.setColspan(2);
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		entete.addCell(cellEntete);
		cellEntete.setColspan(1);
		
		cellEntete.setPhrase(new Phrase("Page : "+ currentPage, fontGen));
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		entete.addCell(cellEntete);

		if (!de.adresse3.equals("")) {
			cellEntete.setPhrase(new Phrase(de.adresse3, fontGen));
			cellEntete.setColspan(2);
			cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
			entete.addCell(cellEntete);
			cellEntete.setColspan(1);

			cellEntete.setPhrase(new Phrase("", fontGen));
			cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
			entete.addCell(cellEntete);
		}

		cellEntete.setPhrase(new Phrase(de.codePostal + " " + de.ville, fontGen));
		cellEntete.setColspan(2);
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		entete.addCell(cellEntete);

		cellEntete.setPhrase(new Phrase("Ech\u00E9ancier des r\u00E8glements", new Font(Font.HELVETICA, 16, Font.BOLD)));
		cellEntete.setColspan(3);
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		entete.addCell(cellEntete);

		if (de.historique) {
			cellEntete.setPhrase(new Phrase("Historique - Clients", new Font(Font.HELVETICA, 14, Font.BOLD)));
			cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
			entete.addCell(cellEntete);
		}
		else {
			cellEntete.setPhrase(new Phrase("En cours - Clients", new Font(Font.HELVETICA, 14, Font.BOLD)));
			cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
			entete.addCell(cellEntete);
		}

		if (de.detail) {
			cellEntete.setPhrase(new Phrase("D\u00E9taill\u00E9", new Font(Font.HELVETICA, 14, Font.BOLD)));
			cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
			entete.addCell(cellEntete);
		}

		cellEntete.setPhrase(new Phrase(""));
		cellEntete.setFixedHeight(10);
		entete.addCell(cellEntete);
		
		
		String periode = "";
		if (!de.debutExerciceStr.equals("")) {
			if (!de.finExerciceStr.equals("")) {
				periode = "P\u00E9riode du " + de.debutExerciceStr + " au " + de.finExerciceStr;
			} else {
				periode = "depuis le " + de.debutExerciceStr;
			}
		} else if (!de.finExerciceStr.equals("")) {
			periode = "jusqu'au " + de.finExerciceStr;
		}
		cellEntete.setPhrase(new Phrase(periode, fontGen));
		cellEntete.setMinimumHeight(0);
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		entete.addCell(cellEntete);

		String libelleClient = "";
		if (!de.clientId.equals("")) {
			libelleClient = "Pour le client N\u00B0 " + de.clientId +" - "+de.denominationClient;
		}
		cellEntete.setPhrase(new Phrase(libelleClient, fontGen));
		cellEntete.setMinimumHeight(0);
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		entete.addCell(cellEntete);

		String libelleModeReg = "";
		if (!de.modeReglement.equals("")) {
			libelleModeReg = "Mode de r\u00E8glement : " + de.modeReglement;
		}
		cellEntete.setPhrase(new Phrase(libelleModeReg, fontGen));
		cellEntete.setMinimumHeight(0);
		cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		entete.addCell(cellEntete);

		PdfPCell cellBandeau = new PdfPCell(entete);
		cellBandeau.setPadding(10);

		bandeau.addCell(cellBandeau);
		
		return bandeau;		
	}
	
	
	private PdfPTable makeFinPage() {
		
		PdfPTable pptFP = new PdfPTable(1);
		pptFP.setWidthPercentage(100);
		
		PdfPCell cell = new PdfPCell(pptFP.getDefaultCell());
		cell.setBorder(PdfPCell.TOP);
		cell.setPhrase(new Phrase(""));
		cell.setPaddingBottom(0);
		cell.setPaddingTop(0);
		cell.setFixedHeight(1);
				
		pptFP.addCell(cell);
	
		return pptFP;
	}


	private PdfPTable makeEntetesColonnes() throws DocumentException {
	
		PdfPTable pptCols = new PdfPTable(nbCols);
		pptCols.setWidthPercentage(100);
		pptCols.setWidths(widthsCols);
		
		PdfPCell cell = new PdfPCell(pptCols.getDefaultCell());		
		
		cell.setFixedHeight(6);
		cell.setBorder(PdfPCell.NO_BORDER);
		cell.setPhrase(new Phrase(""));
		cell.setColspan(nbCols);
		pptCols.addCell(cell);
		cell.setColspan(1);

		cell.setFixedHeight(20);
		cell.setBackgroundColor(Color.LIGHT_GRAY);
		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);

		cell.setBorder(PdfPCell.BOX - PdfPCell.RIGHT);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cell.setPhrase(new Phrase("ECHEANCE", fontLine));
		pptCols.addCell(cell);

		cell.setBorder(PdfPCell.BOX - PdfPCell.RIGHT);
		cell.setPhrase(new Phrase(""));
		pptCols.addCell(cell);

		cell.setBorder(PdfPCell.BOX - PdfPCell.LEFT);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cell.setPhrase(new Phrase("CLIENT", fontLine));
		pptCols.addCell(cell);

		cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cell.setBorder(PdfPCell.BOX);
		cell.setPhrase(new Phrase("DATE DOC.", fontLine));
		pptCols.addCell(cell);
		cell.setPhrase(new Phrase("N\u00B0 PIECE", fontLine));
		pptCols.addCell(cell);

		cell.setPhrase(new Phrase("MODE REG.", fontLine));
		pptCols.addCell(cell);

		if (de.historique) {
			cell.setPhrase(new Phrase("MONTANT", fontLine));
			pptCols.addCell(cell);
		}
		else {
			cell.setPhrase(new Phrase("MONTANT", fontLine));
			pptCols.addCell(cell);

			cell.setPhrase(new Phrase("REGLE", fontLine));
			pptCols.addCell(cell);

			cell.setPhrase(new Phrase("RESTANT DU", fontLine));
			pptCols.addCell(cell);
		}
		
		return pptCols;
	}
	
	
	private PdfPTable makeLine(LigneEcheances le) throws DocumentException {
	
		PdfPTable pptLine = new PdfPTable(nbCols);
		pptLine.setWidthPercentage(100);
		pptLine.setWidths(widthsCols);
		
		PdfPCell cell = new PdfPCell(pptLine.getDefaultCell());
		cell.setBorder(PdfPCell.RIGHT + PdfPCell.LEFT);

		cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cell.setPhrase(new Phrase(formatDate.format(le.dateEcheance), fontLine));
		pptLine.addCell(cell);
		cell.setBorder(PdfPCell.LEFT);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cell.setPhrase(new Phrase(le.clientId, fontLine));
		pptLine.addCell(cell);
		cell.setBorder(PdfPCell.RIGHT);
		cell.setPhrase(new Phrase(le.denomination, fontLine));
		pptLine.addCell(cell);
		cell.setBorder(PdfPCell.RIGHT + PdfPCell.LEFT);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cell.setPhrase(new Phrase(le.datePiece!=0?formatDate.format(le.datePiece):"", fontLine));
		pptLine.addCell(cell);
		cell.setPhrase(new Phrase(le.numPiece, fontLine));
		pptLine.addCell(cell);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cell.setPhrase(new Phrase(le.modeReglement, fontLine));
		pptLine.addCell(cell);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cell.setPhrase(new Phrase(numFormat.format(le.montant), fontLine));
		pptLine.addCell(cell);
		if (!de.historique) {
			cell.setPhrase(new Phrase(numFormat.format(le.montantRegle), fontLine));
			pptLine.addCell(cell);
			cell.setPhrase(new Phrase(numFormat.format(le.montantRestant), fontLine));
			pptLine.addCell(cell);
		}

		return pptLine;
	}
	
	
	private PdfPTable makeLineDetail(LigneEcheances le) throws DocumentException {
		
		PdfPTable pptLine = new PdfPTable(nbCols);
		pptLine.setWidthPercentage(100);
		pptLine.setWidths(widthsCols);
		
		PdfPCell cell = new PdfPCell(pptLine.getDefaultCell());
		cell.setBorder(PdfPCell.RIGHT + PdfPCell.LEFT);

		cell.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
		cell.setPhrase(new Phrase("", fontLinePetit));
		pptLine.addCell(cell);
		cell.setBorder(PdfPCell.LEFT);
		pptLine.addCell(cell);
		cell.setBorder(PdfPCell.RIGHT);
		pptLine.addCell(cell);
		cell.setBorder(PdfPCell.RIGHT + PdfPCell.LEFT);
		cell.setPhrase(new Phrase(le.datePiece!=0?formatDate.format(le.datePiece):"", fontLinePetit));
		pptLine.addCell(cell);
		cell.setPhrase(new Phrase(le.numPiece, fontLinePetit));
		pptLine.addCell(cell);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cell.setPhrase(new Phrase(le.modeReglement, fontLinePetit));
		pptLine.addCell(cell);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cell.setPhrase(new Phrase(numFormat.format(le.montant), fontLinePetit));
		pptLine.addCell(cell);
		if (!de.historique) {
			cell.setPhrase(new Phrase("", fontLinePetit));
			pptLine.addCell(cell);
			cell.setPhrase(new Phrase("", fontLinePetit));
			pptLine.addCell(cell);
		}

		return pptLine;
	}
	
	
	private PdfPTable makeLineRegul(LigneEcheances le) throws DocumentException {
		
		PdfPTable pptLine = new PdfPTable(nbCols);
		pptLine.setWidthPercentage(100);
		pptLine.setWidths(widthsCols);
		
		PdfPCell cell = new PdfPCell(pptLine.getDefaultCell());
		cell.setBorder(PdfPCell.RIGHT + PdfPCell.LEFT);

		cell.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cell.setPhrase(new Phrase("", fontLinePetit));
		pptLine.addCell(cell);
		cell.setBorder(PdfPCell.LEFT);
		pptLine.addCell(cell);
		cell.setBorder(PdfPCell.RIGHT);
		pptLine.addCell(cell);
		cell.setBorder(PdfPCell.RIGHT + PdfPCell.LEFT);
		pptLine.addCell(cell);
		pptLine.addCell(cell);
		cell.setPhrase(new Phrase("Regularis\u00E9", fontLinePetit));
		pptLine.addCell(cell);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cell.setPhrase(new Phrase(numFormat.format(le.montant), fontLinePetit));
		pptLine.addCell(cell);
		if (!de.historique) {
			cell.setPhrase(new Phrase("", fontLinePetit));
			pptLine.addCell(cell);
			pptLine.addCell(cell);
		}

		return pptLine;
	}
	
	
	private PdfPTable makeLineSousTotal(LigneEcheances le) throws DocumentException {
		PdfPTable pptLine = new PdfPTable(nbCols);
		pptLine.setWidthPercentage(100);
		pptLine.setWidths(widthsCols);
		
		PdfPCell cell = new PdfPCell(pptLine.getDefaultCell());
		cell.setBorder(PdfPCell.BOX);

		cell.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cell.setPhrase(new Phrase("", fontLineGras));
		pptLine.addCell(cell);
		
		cell.setBorder(PdfPCell.TOP+PdfPCell.BOTTOM);
		pptLine.addCell(cell);

		String libelleTotal = "";
		if (de.tri.equals("Date")) { libelleTotal = "Total "+ formatDateMois.format(le.dateEcheance); }
		else if (de.tri.equals("Client")) { libelleTotal = "Total "+ (!le.clientId.equals("")?le.clientId + " - ":"") + le.denomination; }
		if (de.tri.equals("Mode")) { libelleTotal = "Total "+ le.modeReglement; }
		cell.setPhrase(new Phrase(libelleTotal, fontLineGras));
		pptLine.addCell(cell);
		cell.setPhrase(new Phrase("", fontLineGras));
		cell.setBorder(PdfPCell.BOX);
		pptLine.addCell(cell);
		pptLine.addCell(cell);
		pptLine.addCell(cell);
		cell.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cell.setPhrase(new Phrase(numFormat.format(le.montant), fontLineGras));
		pptLine.addCell(cell);
		if (!de.historique) {
			cell.setPhrase(new Phrase(numFormat.format(le.montantRegle), fontLineGras));
			pptLine.addCell(cell);
			cell.setPhrase(new Phrase(numFormat.format(le.montantRestant), fontLineGras));
			pptLine.addCell(cell);
		}

		return pptLine;
	}
	
	
	private PdfPTable makeTotalGeneral(LigneEcheances le) throws DocumentException {
		
		PdfPTable pptTotaux = new PdfPTable(nbCols);
		pptTotaux.setWidthPercentage(100);
		pptTotaux.setWidths(widthsCols);

		PdfPCell cell = new PdfPCell(pptTotaux.getDefaultCell());

		cell.setFixedHeight(20);
		cell.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cell.setBackgroundColor(new Color(210,210,210));
		cell.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cell.setColspan(2);
		cell.setBorder(PdfPCell.BOX - PdfPCell.RIGHT);

		cell.setPhrase(new Phrase("", fontLine));
		pptTotaux.addCell(cell);

		cell.setColspan(4);
		cell.setBorder(PdfPCell.BOX - PdfPCell.LEFT);
		cell.setPhrase(new Phrase("Total p\u00E9riode", fontLine));
		pptTotaux.addCell(cell);

		cell.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cell.setColspan(1);
		cell.setBorder(PdfPCell.BOX);
		cell.setPaddingRight(5);
		cell.setPhrase(new Phrase(numFormat.format(le.montant), fontLine));
		pptTotaux.addCell(cell);

		if (!de.historique) {
			cell.setPhrase(new Phrase(numFormat.format(le.montantRegle), fontLine));
			pptTotaux.addCell(cell);

			cell.setPhrase(new Phrase(numFormat.format(le.montantRestant), fontLine));
			pptTotaux.addCell(cell);
		}
		
		return pptTotaux;
	}
	

} // fin PdfEcheances
