/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes ncessaires  l'dition d'une facture standard
 */

package org.opensi.util.calcul;


import java.util.HashMap;
import java.util.Iterator;

import org.opensi.util.tools.Arrondi;


public abstract class CalculDocument {


	// les lignes de la facture
	protected CalculVentilTVA cv;
	protected LigneDocument ld;
	protected CalculVentilTVACommission cvc;
	protected Iterator<Integer> li;

	protected Arrondi r2 = new Arrondi(2);
	protected Arrondi r6 = new Arrondi(6);
	protected boolean editionTTC = false;

	protected double montantHT;
	protected double montantHTN;
	protected double totalHT;
	protected double totalHTC;
	protected double totalHTTable;
	protected double totalTVA;
	protected double totalTVAC;
	protected double montantTTC;
	protected double montantTTCN;
	protected double totalTTC;
	protected double totalTTCC;
	protected double totalTTCTable;
	protected double mRemise;
	protected double pRemise;
	protected double mHTRemise;
	protected double mTTCRemise;
	protected double mTVARemise;
	protected double tTVARemise;
	protected double pRemiseFP;
	protected double mRemiseFP;
	protected double mHTRemiseFP;
	protected double mTTCRemiseFP;
	protected double mTVARemiseFP;
	protected double tTVARemiseFP;
	protected double pCommission;
	protected double mCommission;
	protected double mHTCommission;
	protected double mTTCCommission;
	protected double mTVACommission;
	protected double tTVACommission;
	protected int    cTVACommission;
	protected double mEscompte;
	protected double pEscompte;
	protected double mFraisPort;
	protected double mHTFraisPort;
	protected double mTVAFraisPort;
	protected double tTVAFraisPort;
	protected double mTTCFraisPort;
	protected double mFraisPortHR;
	protected double mHTFraisPortHR;
	protected double mTVAFraisPortHR;
	protected double mTTCFraisPortHR;
	protected double acompte;
	protected double netAPayer;
	protected double mRemiseBase;
	protected double mRemiseFPBase;
	protected double totalHTCommissionne;
	protected double mMarge;
	protected double pMarge;
	
	public CalculDocument(double acompte,double escompte, double remise, double fraisPort, double tauxTvaPort,int codeTvaPort, double mRemise, boolean editionTTC, double pRemise_FP, double mRemise_FP) {
			this.pEscompte = escompte;
			this.pRemise = remise;
			this.mRemise = mRemise;
			this.mRemiseBase = mRemise;
			this.mFraisPort = fraisPort;
			this.mFraisPortHR = fraisPort;
			this.tTVAFraisPort = tauxTvaPort;
			this.tTVARemiseFP = tauxTvaPort;
			this.editionTTC = editionTTC;
			this.pRemiseFP = pRemise_FP;
			this.mRemiseFP = mRemise_FP;
			this.mRemiseFPBase = mRemise_FP;
			this.acompte = acompte;
			this.tTVACommission = 19.6;
			this.cTVACommission = 4;
			this.totalHTTable = 0;
			this.totalTTCTable = 0;
	}
	

	public void calculTotaux() {}
	public abstract void addLigne(int ligneId, double quantite, double prixUnitaire, double ristourne, int codeTVA, double tauxTVA, double commission, double prixAchat);

 	public double getTotalHTTable() { return totalHTTable; }    
 	public double getTotalTTCTable() { return totalTTCTable; }      

 	public double getMontantHT() { return montantHT; }
 	public double getTotalHT() { return totalHT; }
 	public double getTotalHTCommissionne() { return totalHTCommissionne; }
 	public double getTotalTVA() { return totalTVA; }    
 	public double getMontantTTC() { return montantTTC; }
 	public double getTotalTTC() { return totalTTC; }      
 	public double getMRemise() { return mRemise; }       
 	public double getPRemise() { return pRemise; }       
 	public double getMHTRemise() { return mHTRemise ; }       
	public double getMTTCRemise() { return mTTCRemise; }
 	public double getMTVARemise() { return mTVARemise; }   
 	public double getTTVARemise() { return tTVARemise; }   
	public double getPRemise_FP() { return pRemiseFP; }       
 	public double getMRemise_FP() { return mRemiseFP; }       
 	public double getMHTRemise_FP() { return mHTRemiseFP; }       
 	public double getMTTCRemise_FP() { return mTTCRemiseFP; }       
 	public double getMTVARemise_FP() { return mTVARemiseFP; }   
 	public double getTTVARemise_FP() { return tTVARemiseFP; }   
	public double getPCommission() { return pCommission; }       
 	public double getMCommission() { return mCommission; }       
 	public double getMHTCommission() { return mHTCommission; }       
 	public double getMTTCCommission() { return mTTCCommission; }       
 	public double getMTVACommission() { return mTVACommission; }   
 	public double getTTVACommission() { return tTVACommission; }   
 	public double getMEscompte() { return mEscompte; }
 	public double getPEscompte() { return pEscompte; }
 	public double getMFraisPort() { return mFraisPort; }   
 	public double getMHTFraisPort() { return mHTFraisPort; }   
 	public double getMTVAFraisPort() { return mTVAFraisPort; }   
 	public double getTTVAFraisPort() { return tTVAFraisPort; }   
	public double getMTTCFraisPort() { return mTTCFraisPort; }  
 	public double getMFraisPortHR() { return mFraisPortHR; }   
 	public double getMHTFraisPortHR() { return mHTFraisPortHR; }   
 	public double getMTVAFraisPortHR() { return mTVAFraisPortHR; }   
	public double getMTTCFraisPortHR() { return mTTCFraisPortHR; }  
 	public double getAcompte() { return acompte; }
 	public double getMontantNet() { return netAPayer; }
 	public boolean getEditionTTC() {return editionTTC;}    
	public double getRemisePCalcul() {return 0;}
	public double getPRemise_FPCalcul() {return 0;}
	public double getMMargeHT() {return mMarge;}
	public double getPMargeHT() {return pMarge;}
	
	protected HashMap<Integer, CalculVentilTVA> lignesTVA = new HashMap<Integer, CalculVentilTVA>();
	protected HashMap<Integer, CalculVentilTVARemise> lignesTVARemise  = new HashMap<Integer, CalculVentilTVARemise>();
	protected HashMap<Integer, CalculVentilTVACommission> lignesTVACommission  = new HashMap<Integer, CalculVentilTVACommission>();
	protected HashMap<Integer, LigneDocument> lignes = new HashMap<Integer, LigneDocument>();

 	public HashMap<Integer, LigneDocument> getLignes() { return lignes; }
 	public HashMap<Integer, CalculVentilTVA> getLignesTVA() { return lignesTVA; }
	public HashMap<Integer, CalculVentilTVARemise> getLignesTVARemise() { return lignesTVARemise; }
 	public HashMap<Integer, CalculVentilTVACommission> getLignesTVACommission() { return lignesTVACommission; }

}
