/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes ncessaires  l'dition d'une facture standard
 */

package org.opensi.util.calcul;

import java.math.RoundingMode;



public class CalculDocumentV1 extends CalculDocument {

	
	public CalculDocumentV1(double acompte, double escompte, double remise, double fraisPort, double tauxTvaPort,int codeTvaPort, double mRemise, boolean editionTTC, double pRemise_FP, double mRemise_FP) {
		super(acompte, escompte, remise, fraisPort, tauxTvaPort, codeTvaPort, mRemise, editionTTC, pRemise_FP, mRemise_FP);
		if (fraisPort>0) {
			setLigneTVA(codeTvaPort,tauxTvaPort,fraisPort * (1-pRemise_FP/100),fraisPort,0,true);
		}
	}

	public void addLigne(int ligneId, double quantite, double prixUnitaire, double ristourne, int codeTVA, double tauxTVA, double commission, double prixAchat) {

		setLigne(ligneId, quantite, prixUnitaire, ristourne, codeTVA, tauxTVA, commission, prixAchat);
		setLigneTVA(codeTVA,tauxTVA,quantite* prixUnitaire * (1-ristourne/100),quantite* prixUnitaire,pRemise, false);
		setLigneRemise(codeTVA,tauxTVA,quantite* prixUnitaire,ristourne);
	}

	private void setLigne(int ligneId, double quantite, double prixUnitaire, double ristourne, int codeTVA, double tauxTVA, double commission, double prixAchat) {

		LigneDocumentV1 ld = (LigneDocumentV1) lignes.get(new Integer(ligneId));
		if (ld!=null && lignes.containsKey(new Integer(ligneId))) {
			ld.addLigne(quantite, prixUnitaire, ristourne, tauxTVA, commission, tTVACommission, prixAchat,  editionTTC);
			lignes.put(new Integer(ligneId),ld);  
		}
		else {
			LigneDocumentV1 ld2 = new LigneDocumentV1();
			ld2.addLigne(quantite, prixUnitaire, ristourne, tauxTVA, commission, tTVACommission, prixAchat, editionTTC);
			lignes.put(new Integer(ligneId),ld2);
		}
	}
	private void setLigneTVA(int codeTVA,double tauxTVA, double montantBase, double montantBaseHorsRemise,double pRemise, boolean port) {

		CalculVentilTVAV1 vt = (CalculVentilTVAV1)lignesTVA.get(new Integer(codeTVA));
		if (vt!=null && lignesTVA.containsKey(new Integer(codeTVA))) {
			vt.addLigne(tauxTVA, montantBase, editionTTC,montantBaseHorsRemise, pRemise, port);
			lignesTVA.put(new Integer(codeTVA),vt);  
		}
		else {
			CalculVentilTVAV1 vt2 = new CalculVentilTVAV1();
			vt2.addLigne(tauxTVA, montantBase, editionTTC,montantBaseHorsRemise, pRemise, port);
			lignesTVA.put(new Integer(codeTVA),vt2);
		}
	}

	private void setLigneRemise(int codeTVA,double tauxTVA, double montantBase, double ristourne) {

		CalculVentilTVARemiseV1 vt = (CalculVentilTVARemiseV1)lignesTVARemise.get(new Integer(codeTVA));
		if (vt!=null && lignesTVARemise.containsKey(new Integer(codeTVA))) {
			vt.addLigne(tauxTVA, montantBase,ristourne, pRemise, editionTTC);
			lignesTVARemise.put(new Integer(codeTVA),vt);  
		}
		else {
			CalculVentilTVARemiseV1 vt2 = new CalculVentilTVARemiseV1();
			vt2.addLigne(tauxTVA, montantBase,ristourne, pRemise, editionTTC);
			lignesTVARemise.put(new Integer(codeTVA),vt2);
		}
	}

	public void calculTotaux() {
		this.montantHT = 0;
		this.totalTVA = 0;
		double tPrixAchat = 0;
		double totalTVAHR = 0;
		li = getLignesTVA().keySet().iterator();
		while (li.hasNext()) {
			cv = getLignesTVA().get(li.next());
			this.montantHT += cv.getMontantHTHF();
			totalTVA += cv.getMontantTVAHF() * (1-pRemise/100);
			totalTVAHR += cv.getMontantTVAHF();
		}
		
		li = getLignes().keySet().iterator();
		while (li.hasNext()) {
			ld = getLignes().get(li.next());
			tPrixAchat += ld.prixAchat * ld.quantite;
		}
		
		mRemiseFP = mFraisPort * pRemiseFP/100;
		mRemise = montantHT * pRemise/100;
		
		mMarge = r2.round((montantHT - mRemise) - (tPrixAchat));
		pMarge = r2.round(((montantHT - mRemise)!=0)?((mMarge / ((montantHT - mRemise)) * 100)):100);
		
		totalHT = montantHT + (mFraisPort - mRemiseFP) - mRemise;

		if (editionTTC) {
			mRemise = (montantHT+totalTVAHR) * pRemise/100;
			
			totalTVA += (mFraisPort - mRemiseFP) * (tTVAFraisPort/100) / (tTVAFraisPort/100+1);

			mHTRemiseFP = mRemiseFP/(1+(tTVAFraisPort/100));
			mTTCRemiseFP = mRemiseFP;

			mHTFraisPort = mFraisPort/(1+(tTVAFraisPort/100));
			mTTCFraisPort = mFraisPort;

			mHTFraisPortHR = mFraisPortHR/(1+(tTVAFraisPort/100));
			mTTCFraisPortHR = mFraisPortHR;
		}
		else {
			totalTVA += (mFraisPort - mRemiseFP) * tTVAFraisPort/100;

			mHTRemiseFP = mRemiseFP;
			mTTCRemiseFP = mRemiseFP*(1+(tTVAFraisPort/100));

			mHTFraisPort = mFraisPort;
			mTTCFraisPort = mFraisPort *(1+(tTVAFraisPort/100));

			mHTFraisPortHR = mFraisPortHR;
			mTTCFraisPortHR = mFraisPortHR *(1+(tTVAFraisPort/100));
		}
		
		this.totalHTCommissionne= r2.round(totalHT - totalHTC);

		mTVARemiseFP = mTTCRemiseFP - mHTRemiseFP;
		mTVAFraisPortHR = mTTCFraisPortHR - mHTFraisPortHR;
		mTVAFraisPort = mTTCFraisPort - mHTFraisPort;
		montantTTC = totalHT + totalTVA;
		r2.setRoundingMode(RoundingMode.HALF_EVEN);
		mEscompte = r2.round(montantTTC * pEscompte/100);
		totalTTC = montantTTC - mEscompte;
		netAPayer = r2.round(montantTTC - mEscompte - acompte);
		totalHT = r2.round(totalHT);
		totalTVA = r2.round(totalTVA);
		
		totalHTTable = r2.round(totalHT);
		totalTTC = totalHT + totalTVA - mEscompte;
		totalTTC = r2.round(totalTTC);
		totalTTCTable = totalTTC;

	}

	public double getRemisePCalcul() {
		return (montantHT>0)?(r6.round((1-((montantHT - mRemise)/(montantHT)))*100)):0;
	}
	public double getPRemise_FPCalcul() {
		return (mFraisPort>0)?(r6.round((1-((mFraisPort - mRemiseFP)/(mFraisPort)))*100)):0;
	}

}
