/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/


package org.opensi.util.calcul;


public class CalculVentilTVAV2 extends CalculVentilTVA {

	
	public void add(double montantBase, boolean ttc, double montantBaseHRem, boolean frais) {
	
		if (!frais) {
			this.mQuantifieLigneTotal += montantBase;
			this.mQuantifieLigneTotalHF  += montantBase;
			this.mQuantifieLigneTotalHRHF += montantBaseHRem;
		}
		else {
			this.fraisN += montantBase;
		}
		if (ttc) {
			this.baseTTCb =r2.round(mQuantifieLigneTotal);
			this.mRemiseb = r2.round(baseTTCb*(pRemise/100));
			this.baseTTCN = r2.round(((baseTTCb - mRemiseb) + fraisN));
			this.montantTVA = r2.round(baseTTCN * ((tauxTVA/100)/(tauxTVA/100+1)));
			this.baseHTn = r2.round(baseTTCN - montantTVA);

			this.baseTTCbHRHF =r2.round(mQuantifieLigneTotalHRHF);
			this.mRemisebHRHF = 0;
			this.baseTTCNHRHF = r2.round((baseHTbHRHF - mRemisebHRHF));
			this.montantTVAHRHF = r2.round(baseTTCNHRHF * ((tauxTVA/100)/(tauxTVA/100+1)));
			this.baseHTnHRHF = r2.round(baseTTCNHRHF - montantTVAHRHF);
		
			this.baseTTCbHF =r2.round(mQuantifieLigneTotalHF);
			this.mRemisebHF = r2.round(baseTTCbHF*(pRemise/100));
			this.baseTTCNHF = r2.round((baseHTbHF - mRemisebHF));
			this.montantTVAHF = r2.round(baseTTCNHF * ((tauxTVA/100)/(tauxTVA/100+1)));
			this.baseHTnHF = r2.round(baseTTCNHF - montantTVAHF);
		}
		else {
			this.baseHTb = r2.round(mQuantifieLigneTotal);
			this.mRemiseb = r2.round(baseHTb*(pRemise/100));
			this.baseHTn = r2.round(((baseHTb - mRemiseb) + fraisN));
			this.montantTVA = r2.round(baseHTn * (tauxTVA/100));
			this.baseTTCN = r2.round(baseHTn + montantTVA);
			
			this.baseHTbHRHF = r2.round(mQuantifieLigneTotalHRHF);
			this.mRemisebHRHF = 0;
			this.baseHTnHRHF = r2.round((baseHTbHRHF - mRemisebHRHF));
			this.montantTVAHRHF = r2.round(baseHTnHRHF * (tauxTVA/100));
			this.baseTTCNHRHF = r2.round(baseHTnHRHF + montantTVAHRHF);

			this.baseHTbHF = r2.round(mQuantifieLigneTotalHF);
			this.mRemisebHF = r2.round(baseHTbHF*(pRemise/100));
			this.baseHTnHF = r2.round((baseHTbHF - mRemisebHF));
			this.montantTVAHF = r2.round(baseHTnHF * (tauxTVA/100));
			this.baseTTCNHF = r2.round(baseHTnHF + montantTVAHF);
		
		} 
	}	
	
	public double getMontantHT() { return baseHTn; }   
	public double getMontantHTB() { return baseHTb; }   
	public double getMontantHTN() { return baseHTn; }   
	public double getMontantRemise() { return mRemiseb; }   
 	public double getMontantTTC() { return baseTTCN; }    
 	public double getMontantTTCB() { return baseTTCb; }    
 	public double getMontantTTCN() { return baseTTCN; }    
 	public double getMontantTVA() { return montantTVA; }    
	public double getMontantHTHRemHF() { return baseHTnHRHF; }   
 	public double getMontantTTCHRemHF() { return baseTTCNHRHF; }    
 	public double getMontantTVAHRemHF() { return montantTVAHRHF; }    

 	public double getMontantHTHF() { return baseHTnHF; }
 	public double getMontantTTCHF() { return baseTTCNHF; }
 	public double getMontantTVAHF() { return montantTVAHF; }
		
} // fin VentilTVA
