/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes d'une ligne de facture standard
 */

package org.opensi.util.calcul;

public class LigneDocumentV1 extends LigneDocument {	

	public void calculTotalLigne()
	{ 
		this.mRistourne = prixUnitaire * (pRistourne/100);
		this.mCommission = prixUnitaire * (1-pRistourne/100) * (pCommission/100);
		this.montantLigne = quantite * ((prixUnitaire - mRistourne) - mCommission);
		this.mQuantifieLigne = r2.round(montantLigne);
		if (editionTTC) {
			mLigneHT = (montantLigne / (1 +(tauxTVA*100)));
			mLigneTTC = montantLigne;
			mMarge = r2.round(mLigneHT - (prixAchat*quantite));
			pMarge = r2.round((mLigneHT!=0)?mMarge / (mLigneHT*100):0);
		}
		else {
			mLigneHT = montantLigne;
			mLigneTTC = (montantLigne * (1 +(tauxTVA/100)));
			mMarge = r2.round(mLigneHT - (prixAchat*quantite));
			pMarge = r2.round((mLigneHT!=0)?mMarge / (mLigneHT*100):0);
			
		}
	}
}
