/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.util.listing;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;


public class ListingTabFile extends ListingFile {


	public ListingTabFile() {}


	public void write(String folder, String filename, boolean deleteOnExit) {
		try {

			File fichier = new File(folder, filename);
			FileWriter fw = new FileWriter(fichier);
			BufferedWriter bw = new BufferedWriter(fw);

			while (nextLine()) {
				while (nextCell()) {
					bw.write(getCellValue().replace(';', ' ') +";");
				}

				for (int k=getLineSize(); k<getMaxCol(); k++) {
					bw.write(";");
				}

				bw.newLine();
				bw.flush();
			}

			bw.close();

			if (deleteOnExit) {
				try {
					fichier.deleteOnExit();
				}
				catch(SecurityException se) {
					System.out.println("Impossible d'enregistrer le fichier  supprimer");
				}
			}
		}
		catch(Exception e) {
			e.printStackTrace();
		}
	}


} // fin ListingTabFile
