/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.util.openoffice;
/**
* Pour gnrer les styles d'Ooo
*/

public abstract class OooStyle
{

	private String nom;
	
	
	public OooStyle(String lenom)
	{
		nom=lenom;
	}
	
	/**
	 * Retourne le nom du style qui est l'identifiant du style
	 * @return identifiant du style
	 */
	public String getNomStyle()
	{
		return nom;
	}
	
	/**
	 * Retourne le nom du style qui est l'identifiant du style
	 * @return identifiant du style
	 */
	public abstract String getFamilleStyle();
	
	/**
	 * Retourne la chaine de caractre reprsentant la ou les proprits associes au style
	 * @return proprit du style
	 */
	public abstract String getPropriete();
	
	/**
	 * Cree la chaine de caractre  destination de openoffice qui definie ce style
	 * @return la chaine de caractre  crire formate en openoffice.
	 */
	public String toStringOoo()
	{
		String resultat="";
		resultat+="<style:style style:name=\""+getNomStyle()+"\" style:family=\""+getFamilleStyle()+"\">";
		resultat+="<style:properties "+getPropriete()+"/>";
		resultat+="</style:style>";
		
		return resultat;
	}
	

}
