/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Document PDF
 */

package org.opensi.util.pdf;


import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.PageSize;
import com.lowagie.text.pdf.PdfWriter;


public class GlobalDocument {


	private Document document;
	private File fichierPDF;
	private PdfWriter writer;

	public static final int ON_EXIT = 1;
	public static final int DELETE = 2;


 	public GlobalDocument(String cheminPDF, String nomPDF) {
		try {

			this.document = new Document(PageSize.A4, 20, 20, 20, 20);
			this.fichierPDF = new File(cheminPDF, nomPDF);
			this.writer = PdfWriter.getInstance(document, new FileOutputStream(fichierPDF));
			document.open();
		}
		catch(FileNotFoundException fnfe) {
			fnfe.printStackTrace();
		}
		catch(DocumentException de) {
			de.printStackTrace();
		}
	}


	public void addInternal(InternalDocument id) throws DocumentException {

		id.buildDocument(document, writer);
	}


	public void close() {

		if (document.isOpen()) document.close();
	}


	public void close(int delCode) {

		if (delCode==ON_EXIT) {
			try {
				fichierPDF.deleteOnExit();
			}
			catch(SecurityException se) {
				System.out.println("Impossible d'enregistrer le fichier PDF  supprimer");
			}
		}
		else if (delCode==DELETE) {
			fichierPDF.delete();
		}

		close();
	}

	public Document getDocument() {

		return this.document;
	}


} // fin GlobalDocument
