/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 *  Rcupration des commandes
 */

package org.opensi.webmanager.fonctions_periodiques;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.sql.Types;
import java.util.HashMap;

import org.opensi.facturation.GenDocNumber;
import org.opensi.facturation.StockManager;
import org.opensi.util.calcul.Calcul;
import org.opensi.util.tools.DateTime;
import org.opensi.webmanager.utils.AppelServices;
import org.opensi.webmanager.utils.ArticleCommandeStruct;
import org.opensi.webmanager.utils.ClientStruct;
import org.opensi.webmanager.utils.CommandeStruct;
import org.opensi.webmanager.utils.MultiRapports;
import org.opensi.webmanager.utils.PersonneStruct;
import org.opensi.webmanager.utils.RedactionRapport;
import org.opensi.webmanager.utils.ToolsMAJ;

/**
 * Procdure de rcupration des commandes.
 */
public class UploadCommandes {

	boolean appelServiceReussi;
	boolean appelToutServiceReussi;
	Object[] rapport;
	String dateDebut;
	String dateFin;
	Object[] listeCommandes;
	int nbRecupReussi;
	MultiRapports lesRapports;
	HashMap<Double, Integer> code_tva;
	int nbCommandes;
	private File aEcrire;
	private String type;
	private String reqRoot;
	private ResultSet resRoot;
	private int numAffaire;

	/**
	 * Initialise la rcupration des commandes.
	 */
	public UploadCommandes(String nomFichier, String nomtype) {
		appelServiceReussi = true;
		aEcrire = new File(nomFichier);// le fichier de log
		this.type=nomtype;
		lesRapports = new MultiRapports();
	}
	public UploadCommandes() {
		aEcrire = new File("Lancer_Maintenant.log");// le fichier de log
		this.type="";
		appelServiceReussi = true;
		lesRapports = new MultiRapports();
	}

	/**
	 * Lance la rcupration des commandes.
	 * 
	 * La connexion  la base de donne n'est ni ouverte ni ferme.
	 * 
	 * @param serveur
	 *          adresse du web service
	 * @param dossierRoot
	 *          chemin absolu vers le serveur de OpenSi (opensi-serveur)
	 * @param dossierId
	 *          identifiant du dossier
	 * @param con
	 *          Connexion  la base de donne
	 * @param nomBase
	 *          Nom de la base de donne FACT_qquechose
	 * @param site_id
	 *          identifiant du site
	 * @return vrai si la mise  jour s'est bien passe, faux sinon.
	 */
	public boolean lancerUpload(String serveur, String dossierRoot, String dossierId, Connection con, String nomBase, String site_id) {
		// //ToolsMAJ.ecrireLog(aEcrire,type,"[UploadCommandes] Debut ");

		nbRecupReussi = 0;
		nbCommandes = 0;
		appelToutServiceReussi = true;
		java.util.Date date = new java.util.Date();
		Timestamp stamp = new Timestamp(date.getTime());
		dateDebut = "" + stamp;

		boolean continuer = true;

		// Pour la gestion des codes de TVA
		code_tva = new HashMap<Double, Integer>();
		try {
			String req = "SELECT Code_TVA, Taux_TVA FROM " + nomBase + ".TAUX_TVA";
			
			Statement state = con.createStatement();
			ResultSet resTva = state.executeQuery(req);

			while (resTva.next()) {
				code_tva.put(new Double(resTva.getDouble("Taux_Tva")), new Integer(resTva.getInt("Code_TVA")));
			}
		}
		catch (Exception e) {
			ToolsMAJ.ecrireLog(aEcrire,type,"[UploadCommandes] ERREUR1:" + e);
		}

		while (continuer) {
			appelServiceReussi = true;

			continuer = appelService(serveur);
			appelToutServiceReussi = appelToutServiceReussi && appelServiceReussi;
			if (appelServiceReussi) {

				ToolsMAJ.ecrireLog(aEcrire,type,"enregistrement");
				enregistrer(con, nomBase, site_id, dossierId);
				nbRecupReussi++;
			}

		}

		date = new java.util.Date();
		stamp = new Timestamp(date.getTime());
		dateFin = "" + stamp;

		try {
			String requete = "UPDATE " + nomBase + ".MAJ_AUTO SET Derniere_Maj=" + date.getTime() + " WHERE Site_Id=" + site_id
			+ " AND Type_Maj='COM'";
			Statement state = con.createStatement();
			state.executeUpdate(requete);
		}
		catch (Exception e) {
			ToolsMAJ.ecrireLog(aEcrire,type,"[UploadCommande]ERREUR2" + e);
		}

		ecrireRapport(dossierRoot, dossierId, site_id);

		// ToolsMAJ.ecrireLog(aEcrire,type,"[UploadCommandes] Fin ");

		return appelToutServiceReussi;

	}

	private boolean appelService(String serveur) {

		Object resultat = null;
		boolean resultFct = false;

		try {
			resultat = AppelServices.uploadCommandes(serveur);

			Object[] rep = (Object[]) resultat; // valeur
			Object[] rapport = (Object[]) rep[0];// rapport

			lesRapports.addRapport(rapport);

			Object[] listeComPlusBool = (Object[]) rep[1];

			// Je sais que c'est une liste de commandes
			listeCommandes = (Object[]) listeComPlusBool[0];

			// Boolen indiquant si il faut continuer ou non
			Boolean fautContinuer = (Boolean) listeComPlusBool[1];
			if (fautContinuer == null) {
				resultFct = false;
				appelServiceReussi = false;
			}
			else {
				resultFct = ((Boolean) listeComPlusBool[1]).booleanValue() && listeCommandes.length>0;
			}
		}
		catch (Exception e) {
			ToolsMAJ.ecrireLog(aEcrire,type,"[UploadCommandes] ERREUR3:" + e);
			appelServiceReussi = false;
		}

		return resultFct;

	}

	private void ecrireRapport(String dossierRoot, String dossierId, String site_id) {

		try {
			boolean noErreurRapport = true;
			RedactionRapport ecriveur = new RedactionRapport(ToolsMAJ.TYPE_UPLOAD_COMMANDES, 10, dossierRoot, dossierId, site_id);

			ecriveur.ajouterLigne(dateDebut + ":La rcupration des commandes a t lance", true);

			if (nbRecupReussi < 1) {
				ecriveur.ajouterLigne("\nLe site distant n'as pas pu etre atteind. Aucunes commande recupre.", false);
			}
			else {
				// ToolsMAJ.ecrireLog(aEcrire,type,"[UploadCommande] Nb de commandes:"+nbCommandes);

				// if(nbCommandes==0)
				// {
				// ecriveur.ajouterLigne(dateFin+":Aucune nouvelle
				// commande.",true);
				// }
				// else
				// {

				String lesDetails = "";

				int cptErreur = 0;
				int cptOk = 0;

				while (lesRapports.next()) {
					if (lesRapports.aReussi()) {
						lesDetails += "\n<br>" + lesRapports.getMessageUtilisateur();
						cptOk++;
					}
					else {
						lesDetails += "\n<br><span class=\"echec\">" + lesRapports.getMessageUtilisateur() + "</span>";
						cptErreur++;
					}

					noErreurRapport = noErreurRapport && (lesRapports.aReussi());
				}

				if (cptErreur >= 0) {
					ecriveur.ajouterLigne(dateFin + ":Toutes les commandes ont t rcuprs", true);
				}
				else {
					ecriveur.ajouterLigne(dateFin + ":" + cptErreur + " commandes n'ont pas t rcupres.", false);
					ecriveur.ajouterLigne(dateFin + ":" + cptOk + " commandes ont t rcupres.", true);
				}

				if (!lesDetails.equals("")) {
					ecriveur.ajouterLigne(" ****************** DETAILS **************", true);
					ecriveur.ajouterLigne(lesDetails, true);
				}
				// }

			}

			ecriveur.fermerFichier();

		}
		catch (java.io.IOException e) {
			ToolsMAJ.ecrireLog(aEcrire,type,"[UploadCommandes(ecrireRapport)] ERREUR4:" + e);
		}

	}

	/* *********************************************************************** */
	/* * Enregistrement dans la base * */
	/* *********************************************************************** */

	private void enregistrer(Connection con, String base, String site_id, String dossierId) {
		try {

			Statement state = con.createStatement();

			nbCommandes += listeCommandes.length;
			for (int j = 0; j < listeCommandes.length; j++) {

				// ToolsMAJ.ecrireLog(aEcrire,type,"[UploadCommandes] Une nouvelle commande");
				CommandeStruct com = new CommandeStruct((Object[]) listeCommandes[j]);

				ClientStruct client = new ClientStruct(com.getStruct(com.CLIENT));
				//String clientId = client.getString(client.CLIENTID,10); REMPLACE PAR RECHERCHE DANS CLIENT_WEB -> FICHE_CLIENT
				PersonneStruct personneClient = new PersonneStruct(client.getStruct(client.PERSONNE));
				ClientStruct client_Liv = new ClientStruct(com.getStruct(com.CLIENT_LIV));
				PersonneStruct personneLiv = new PersonneStruct(client_Liv.getStruct(client_Liv.PERSONNE));
				String com_id = com.getString(com.ID,20);
				double com_totalTTC = com.getDouble(com.TOTAL_TTC);
				double com_tauxRemise = com.getDouble(com.TAUX_REMISE);
				double com_remise = com.getDouble(com.REMISE);
				double com_fraisPort = com.getDouble(com.FRAIS_PORT);
				double com_tauxTVAFraisPort = com.getDouble(com.TAUX_TVA_PORT);
				String com_modePaiement = com.getString(com.MODE_PAIEMENT,20);
				int com_statut_Paiement = com.getInteger(com.STATUT_PAIE);
				String com_date_string = com.getString(com.DATE,16);
				long com_date = DateTime.parseDate(com_date_string, "dd/MM/yyyy/HH/mm");
				int com_validation = com.getInteger(com.VALIDATION);
				String com_email_manager=com.getString(com.EMAIL_MANAGER,64);
				String com_modeExpedition=com.getString(com.MODE_EXPEDITION,30);
				String com_commentaires=com.getString(com.COMMENTAIRES);
				String com_commentaires_2=com.getString(com.COMMENTAIRES_2);
				int com_editionTTC = com.getInteger(com.EDITION_TTC);
				String com_codePorte=com.getString(com.CODE_PORTE,30);
				String com_numTransaction=com.getString(com.NUM_TRANSACTION,20);
				String com_origine=com.getString(com.ORIGINE,30);
				String com_infosCommande=com.getString(com.INFOS_COMMANDE,100);
				int com_assujetti = com.getInteger(com.ASSUJETTI);
				int com_envoi_multiple = com.getInteger(com.ENVOI_MULTIPLE);
				int com_bloque = com.getInteger(com.BLOQUE);


				double com_tauxIndicatif = com.getDouble(com.TAUX_INDICATIF);

				String liv_civ=personneLiv.getString(personneLiv.CIV,1);

				String liv_nom=personneLiv.getString(personneLiv.NOM,30);
				String liv_prenom=personneLiv.getString(personneLiv.PRENOM,30);
				String liv_entreprise=personneLiv.getString(personneLiv.ENTREPRISE,50);
				String liv_adresse=personneLiv.getString(personneLiv.ADRESSE,80);
				String liv_compadresse=personneLiv.getString(personneLiv.COMPADRESSE,50);
				String liv_adresse3=personneLiv.getString(personneLiv.ADRESSE3,50);
				String liv_cp=personneLiv.getString(personneLiv.CP,10);
				String liv_ville=personneLiv.getString(personneLiv.VILLE,50);
				String liv_code_pays=personneLiv.getString(personneLiv.CODE_PAYS,3);
				liv_code_pays=(liv_code_pays.equals(""))?"FR":liv_code_pays;
				
				String liv_tel=client_Liv.getString(client_Liv.TEL,20);
				String liv_fax=client_Liv.getString(client_Liv.FAX,20);
				String liv_email=client_Liv.getString(client_Liv.EMAIL,64);



				String client_id=client.getString(client.ID,60);
				String client_civ=personneClient.getString(personneClient.CIV,1);
				String client_nom=personneClient.getString(personneClient.NOM,30);
				String client_prenom=personneClient.getString(personneClient.PRENOM,30);
				String client_entreprise=personneClient.getString(personneClient.ENTREPRISE,50);
				String client_adresse=personneClient.getString(personneClient.ADRESSE,80);
				String client_compadresse=personneClient.getString(personneClient.COMPADRESSE,50);
				String client_adresse3=personneClient.getString(personneClient.ADRESSE3,50);
				String client_cp=personneClient.getString(personneClient.CP,10);
				String client_ville=personneClient.getString(personneClient.VILLE,50);
				String client_code_pays=personneClient.getString(personneClient.CODE_PAYS,3);
				String client_tel=client.getString(client.TEL,20);
				String client_fax=client.getString(client.FAX,20);
				String client_email=client.getString(client.EMAIL,64);
				String client_pass=client.getString(client.PASS,20);

				int numClient = 0;
				int numCommande = 0;

				Integer codeTVAPort = code_tva.get(new Double(com_tauxTVAFraisPort));
				
				String fact_civ_string="";
				String reqCiv = "SELECT * FROM CIVILITE WHERE Civ_Id="+ client_civ;
				ResultSet resCiv = state.executeQuery(reqCiv);
				if (resCiv.next()) {
					fact_civ_string=resCiv.getString("Civ_Courte");
				}

				String clientDenomination = client_entreprise.equals("")?fact_civ_string +((fact_civ_string.equals(""))?"":" ")+client_nom+" "+client_prenom:client_entreprise;

				String liv_civ_string="";
				reqCiv = "SELECT * FROM CIVILITE WHERE Civ_Id="+ liv_civ;
				resCiv = state.executeQuery(reqCiv);
				if (resCiv.next()) {
					liv_civ_string=resCiv.getString("Civ_Courte");
				}
				String livDenomination = liv_entreprise.equals("")?liv_civ_string +((liv_civ_string.equals(""))?"":" ")+liv_nom+" "+liv_prenom:liv_entreprise;

				int logRoot = 0;

				reqRoot = "select Utilisateur_Id from UTILISATEUR where Login='root'";
				resRoot = state.executeQuery(reqRoot);
				if (resRoot.next()) {
					logRoot=resRoot.getInt("Utilisateur_Id");
				}

				int modRegId = 0;

				String reqModRegId = "select Mode_Reg_Id from " + base + ".MODE_REGLEMENT where Libelle=?";
				PreparedStatement psselModeRegId = con.prepareStatement(reqModRegId);
				psselModeRegId.setString(1, com_modePaiement);
				ResultSet resModRegId = psselModeRegId.executeQuery();
				if (resModRegId.next()) {
					modRegId=resModRegId.getInt("Mode_Reg_Id");
				}

				/* **************** */
				/* * FICHE CLIENT * */
				/* **************** */
				// ToolsMAJ.ecrireLog(aEcrire,type,"[UploadCommandes] Cration de la fiche client");

				DateTime dt = new DateTime();
				long now = dt.getTimeInMillis();

				String insertup = "insert into " + base + ".CLIENT_WEB ";
				insertup +=	"(Client_Site_Id,Site_Id,Civ,Nom,Prenom,Entreprise,Adresse_1, Adresse_2,Adresse_3, Code_Postal,Ville,Code_Pays,Tel,Fax,Email,Password) ";
				insertup +=	"values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,lcase(?),?) ";
				insertup +=	"on duplicate key update Civ=?,Nom=?,Prenom=?,Entreprise=?,Adresse_1=?, Adresse_2=?,Adresse_3=?, Code_Postal=?,Ville=?,Code_Pays=?,Tel=?,Fax=?,Email=lcase(?),Password=?;";
				PreparedStatement psinsertup = con.prepareStatement(insertup);

				psinsertup.setString(1, client_id);
				psinsertup.setString(2, site_id);
				if (client_entreprise.equals("")) {
					psinsertup.setString(3, "0");
					psinsertup.setString(4, "");
					psinsertup.setString(5, "");
					psinsertup.setString(6, clientDenomination);
				}
				else {
					psinsertup.setString(3, client_civ);
					psinsertup.setString(4, client_nom);
					psinsertup.setString(5, client_prenom);
					psinsertup.setString(6, clientDenomination);
				}

				psinsertup.setString(7, client_adresse);
				psinsertup.setString(8, client_compadresse);
				psinsertup.setString(9, client_adresse3);
				psinsertup.setString(10, client_cp);
				psinsertup.setString(11, client_ville);
				psinsertup.setString(12, client_code_pays);
				psinsertup.setString(13, client_tel);
				psinsertup.setString(14, client_fax);
				psinsertup.setString(15, client_email);
				psinsertup.setString(16, client_pass);

				if (client_entreprise.equals("")) {
					psinsertup.setString(17, "0");
					psinsertup.setString(18, "");
					psinsertup.setString(19, "");
					psinsertup.setString(20, clientDenomination);
				}
				else {
					psinsertup.setString(17, client_civ);
					psinsertup.setString(18, client_nom);
					psinsertup.setString(19, client_prenom);
					psinsertup.setString(20, clientDenomination);
				}
				psinsertup.setString(21, client_adresse);
				psinsertup.setString(22, client_compadresse);
				psinsertup.setString(23, client_adresse3);
				psinsertup.setString(24, client_cp);
				psinsertup.setString(25, client_ville);
				psinsertup.setString(26, client_code_pays);
				psinsertup.setString(27, client_tel);
				psinsertup.setString(28, client_fax);
				psinsertup.setString(29, client_email);	
				psinsertup.setString(30, client_pass);
				psinsertup.executeUpdate();


				ResultSet rsnum = psinsertup.getGeneratedKeys();

				String reqClientWebId = "select Client_Web_Id from " + base + ".CLIENT_WEB where Client_Site_Id=? and Site_Id=?";
				PreparedStatement psReqClientWebId = con.prepareStatement(reqClientWebId);
				psReqClientWebId.setString(1, client_id);
        psReqClientWebId.setString(2, site_id);
				ResultSet resClientWebId = psReqClientWebId.executeQuery();
				if (resClientWebId.next()) {
					numClient=resClientWebId.getInt("Client_Web_Id");
				}


				/* **************** */
				/* * COMMANDE * */
				/* **************** */
				int banqueRemise=0;

				reqRoot = "select Utilisateur_Id from UTILISATEUR where Login='root'";
				resRoot = state.executeQuery(reqRoot);
				if (resRoot.next()) {
					logRoot=resRoot.getInt("Utilisateur_Id");
				}
				
				String reqSite = "SELECT * FROM " + base + ".SITE_WEB WHERE Site_Id="+ site_id;
				ResultSet resSite = state.executeQuery(reqSite);
				if (resSite.next()) {
					banqueRemise=resSite.getInt("Banque_Remise_CB");
				}

				String clientId = null;
				String utilR = null;
				String affaireDenomination = clientDenomination;
				String affaireTel = client_tel;
				String affaireFax = client_fax;
				String affaireEmail = client_email;
				int fraisPortPrem = 0;
				String modeEnvoiFacture = "C";
				String periodeFacturation = "I";
				String modeFacturation = "E";
				String typeFacturation = "CC";
				int commandeCodeTarif = 1;
				String commandeSecteurActivite = null;
				int activationCP = 0;
				int factSepFP = 0;

				
				String reqParamDossier = "SELECT * FROM " + base + ".PARAM_DOSSIER";
				ResultSet resParamDossier = state.executeQuery(reqParamDossier);
				if (resParamDossier.next()) {
					fraisPortPrem=resParamDossier.getInt("Frais_Port_Prem");
					modeEnvoiFacture=resParamDossier.getString("Def_Mode_Envoi_Facture");
					periodeFacturation=resParamDossier.getString("Def_Periode_Facturation");
					modeFacturation=resParamDossier.getString("Def_Mode_Facturation");
					typeFacturation=resParamDossier.getString("Def_Type_Fact");
					activationCP=resParamDossier.getInt("Act_Activation_CP");
				}
				
				
				String reqClientWeb = "SELECT * FROM " + base + ".CLIENT_WEB cw join " + base + ".FICHE_CLIENT fc on cw.Client_Id=fc.Client_Id where Client_Web_Id="+ numClient;
				ResultSet resClientWeb = state.executeQuery(reqClientWeb);
				if (resClientWeb.next()) {
					clientId = resClientWeb.getString("Client_Id");
					utilR = resClientWeb.getString("Util_R");
					affaireDenomination = resClientWeb.getString("Denomination");
					affaireTel = resClientWeb.getString("Tel_1");
					affaireFax = resClientWeb.getString("Fax_1");
					affaireEmail = resClientWeb.getString("Email_1");
					commandeCodeTarif = resClientWeb.getInt("Code_Tarif");
					commandeSecteurActivite = resClientWeb.getString("Secteur_Activite");
					com_assujetti = resClientWeb.getInt("Assujetti_TVA");
					modeEnvoiFacture = resClientWeb.getString("Mode_Envoi_Facture");
					periodeFacturation = resClientWeb.getString("Periode_Facturation");
					modeFacturation = resClientWeb.getString("Mode_Facturation");
					typeFacturation = resClientWeb.getString("Type_Fact");
					activationCP = resClientWeb.getInt("Activation_CP");
					modRegId = resClientWeb.getInt("Mode_Reg_Id");
				}

				GenDocNumber gdn = new GenDocNumber(now,con,base,dossierId);
				String numEntier = gdn.getNumeroAffaire();
				int numero = gdn.getNumeroPeriode();

				String ajoutAffaire = "INSERT INTO " + base + ".AFFAIRE " +
				        " ( Numero, Num_Entier, Client_Id, Denomination, Telephone, Fax, Email, Intitule, Util_R, Commentaires, Util_C, Util_M, Date_C, Date_M," +
						" Etat, Date_Cloture, Type_Fact, Frais_Port_Prem, Mode_Envoi_Facture, Periode_Facturation, Mode_Facturation, Activation_CP, Fact_Sep_FP " +
				        " ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?" +
				        " ,?,?,?,?,?,?,?,?)";
				PreparedStatement psAjoutAffaire = con.prepareStatement(ajoutAffaire);

				psAjoutAffaire.setInt(1, numero);
				psAjoutAffaire.setString(2, numEntier);
				psAjoutAffaire.setString(3, clientId);
				psAjoutAffaire.setString(4, affaireDenomination);
				psAjoutAffaire.setString(5, affaireTel);
				psAjoutAffaire.setString(6, affaireFax);
				psAjoutAffaire.setString(7, affaireEmail);
				psAjoutAffaire.setString(8, "");
				psAjoutAffaire.setObject(9, (utilR!=null)?Integer.getInteger(utilR):null);
				psAjoutAffaire.setString(10, "");
				psAjoutAffaire.setInt(11, logRoot);
				psAjoutAffaire.setInt(12, logRoot);
				psAjoutAffaire.setLong(13, now);
				psAjoutAffaire.setLong(14, now);

				if (com_statut_Paiement==1) {
					psAjoutAffaire.setString(15, "T");
				}
				else if (com_validation==0) {
					psAjoutAffaire.setString(15, "Z");
				}
				else if (com_validation==1) {
					psAjoutAffaire.setString(15, "N");
				}
				else if (com_validation==2) {
					psAjoutAffaire.setString(15, "T");
				}
				else {
					psAjoutAffaire.setString(15, "N");
				}
				psAjoutAffaire.setLong(16, 0);
				psAjoutAffaire.setString(17, typeFacturation);
				psAjoutAffaire.setInt(18, fraisPortPrem);
				psAjoutAffaire.setString(19, modeEnvoiFacture);
				psAjoutAffaire.setString(20, periodeFacturation);
				psAjoutAffaire.setString(21, modeFacturation);
				psAjoutAffaire.setInt(22, activationCP);
				psAjoutAffaire.setInt(23, factSepFP);
				psAjoutAffaire.executeUpdate();

				rsnum = psAjoutAffaire.getGeneratedKeys();

				if (rsnum.next()) {
					numAffaire = rsnum.getInt(1);
				}

				
				gdn = new GenDocNumber(now,con,base,dossierId);
				numEntier = gdn.getNumeroCC();

				int modeExpe= 0;
				String reqModeExpe = "select Mode_Liv_Id from " + base + ".MODE_LIVRAISON where Nom=?";
				PreparedStatement psReqModeExpe = con.prepareStatement(reqModeExpe);
				psReqModeExpe.setString(1, com_modeExpedition);
				ResultSet resModeExpe = psReqModeExpe.executeQuery();
				if (resModeExpe.next()) {
					modeExpe=resModeExpe.getInt("Mode_Liv_Id");
				}

				
				
				// ToolsMAJ.ecrireLog(aEcrire,type,"[UploadCommandes] Cration de la fiche commande");
				String ajoutCom = "INSERT INTO " + base + ".COMMANDE_CLIENT (" +
								  " Affaire_Id, Client_Id, Util_R, Date_C, Date_M, Util_C, Util_M, Etat, Statut_Logistique, Date_Commande, Date_Validation, Date_Annulation," +
								  " Ref_Commande, Numero, Edition_TTC, Regime_TVA, Assujetti_TVA, Num_TVA_Intra, Bloque, Code_Tarif, Delai, Soldee, Facturee, Mode_Expedition," +
								  " Secteur_Activite, Taux_Indicatif, Statut_paiement, Mode_Reg_Id, Commentaires_Fin, Commentaires_Int, Commentaires_Hid, Mentions, " +
								  " Remise, Montant_Remise, PRemise_FP, MRemise_FP, Escompte, Frais_Port, Code_TVA_Port, Taux_TVA_Port, " +
				                  " Denomination, Adresse_1, Adresse_2, Adresse_3, Code_Postal, Ville, Code_Pays, Civ_Inter, Nom_Inter, Prenom_Inter, Tel_Inter, Fax_Inter, Email_Inter, " +
				                  " Denomination_Liv, Adresse_1_Liv, Adresse_2_Liv, Adresse_3_Liv, Code_Postal_Liv, Ville_Liv, Code_Pays_Liv, Civ_Inter_Liv, Nom_Inter_Liv, Prenom_Inter_Liv, Tel_Inter_Liv, Fax_Inter_Liv, Email_Inter_Liv, " +
				                  " Denomination_Envoi, Adresse_1_Envoi, Adresse_2_Envoi, Adresse_3_Envoi, Code_Postal_Envoi, Ville_Envoi, Code_Pays_Envoi, Civ_Inter_Envoi, Nom_Inter_Envoi, Prenom_Inter_Envoi, Tel_Inter_Envoi, Fax_Inter_Envoi, Email_Inter_Envoi" +
				                  " ) VALUES ( " +
				                  " ?,?,?,?,?,?,?,?,?,?,?,?," +
				                  " ?,?,?,?,?,?,?,?,?,?,?,?," +
				                  " ?,?,?,?,?,?,?,?," +
				                  " ?,?,?,?,?,?,?,?," +
				                  " ?,?,?,?,?,?,?,?,?,?,?,?,?," +
				                  " ?,?,?,?,?,?,?,?,?,?,?,?,?," +
				                  " ?,?,?,?,?,?,?,?,?,?,?,?,?" +
				                  " )";
				PreparedStatement psajoutCom = con.prepareStatement(ajoutCom);

				int posParam = 1;
				
				psajoutCom.setInt(posParam++, numAffaire);
				psajoutCom.setString(posParam++, clientId);
				psajoutCom.setString(posParam++, utilR);
				psajoutCom.setLong(posParam++, now);
				psajoutCom.setLong(posParam++, now);
				psajoutCom.setInt(posParam++, logRoot);
				psajoutCom.setInt(posParam++, logRoot);
				psajoutCom.setString(posParam++, (com_validation==2 || com_statut_Paiement==1)?"T":"N");
				psajoutCom.setString(posParam++, (com_validation==2 || com_statut_Paiement==1)?"T":"N");
				psajoutCom.setLong(posParam++, com_date);
				psajoutCom.setLong(posParam++, (com_validation==2 || com_statut_Paiement==1)?now:0);
				psajoutCom.setLong(posParam++, 0);//12
				
				psajoutCom.setString(posParam++, com_id);
				psajoutCom.setString(posParam++, numEntier);
				psajoutCom.setInt(posParam++, com_editionTTC);
				psajoutCom.setString(posParam++, "G");
				psajoutCom.setInt(posParam++, com_assujetti);
				psajoutCom.setString(posParam++, "");
				psajoutCom.setInt(posParam++, com_bloque);
				psajoutCom.setInt(posParam++, commandeCodeTarif);
				psajoutCom.setInt(posParam++, 0);
				psajoutCom.setInt(posParam++, 0);
				psajoutCom.setInt(posParam++, 0);
				
				
				psajoutCom.setObject(posParam++, (modeExpe!=0)?modeExpe:null); //24

				psajoutCom.setString(posParam++, commandeSecteurActivite);
				psajoutCom.setDouble(posParam++, com_tauxIndicatif);
				psajoutCom.setInt(posParam++, com_statut_Paiement);
				if (modRegId>0) {
					psajoutCom.setInt(posParam++, modRegId);
				}
				else {
					psajoutCom.setNull(posParam++, java.sql.Types.INTEGER);
				}
				psajoutCom.setString(posParam++, com_commentaires);
				psajoutCom.setString(posParam++, com_commentaires_2);
				psajoutCom.setString(posParam++, "");
				psajoutCom.setString(posParam++, "");
				
				psajoutCom.setDouble(posParam++, com_tauxRemise);
				psajoutCom.setDouble(posParam++, com_remise);
				psajoutCom.setDouble(posParam++, 0);
				psajoutCom.setDouble(posParam++, 0);
				psajoutCom.setDouble(posParam++, 0);
				psajoutCom.setDouble(posParam++, com_fraisPort);
				psajoutCom.setInt(posParam++, codeTVAPort);
				psajoutCom.setDouble(posParam++, com_tauxTVAFraisPort);
			
				psajoutCom.setString(posParam++, clientDenomination);
				psajoutCom.setString(posParam++, client_adresse);
				psajoutCom.setString(posParam++, client_compadresse);
				psajoutCom.setString(posParam++, client_adresse3);
				psajoutCom.setString(posParam++, client_cp);
				psajoutCom.setString(posParam++, client_ville);
				psajoutCom.setString(posParam++, client_code_pays);
				
				if (client_entreprise.equals("")) {
					psajoutCom.setString(posParam++, "0");
					psajoutCom.setString(posParam++, "");
					psajoutCom.setString(posParam++, "");
				}
				else {
					psajoutCom.setString(posParam++, client_civ);
					psajoutCom.setString(posParam++, client_nom);
					psajoutCom.setString(posParam++, client_prenom);
				}
				psajoutCom.setString(posParam++, client_tel);
				psajoutCom.setString(posParam++, client_fax);
				psajoutCom.setString(posParam++, client_email);

				
				psajoutCom.setString(posParam++, livDenomination);
				psajoutCom.setString(posParam++, liv_adresse);
				psajoutCom.setString(posParam++, liv_compadresse);
				psajoutCom.setString(posParam++, liv_adresse3);
				psajoutCom.setString(posParam++, liv_cp);
				psajoutCom.setString(posParam++, liv_ville);
				psajoutCom.setString(posParam++, liv_code_pays);
				if (liv_entreprise.equals("")) {
					psajoutCom.setString(posParam++, "0");
					psajoutCom.setString(posParam++, "");
					psajoutCom.setString(posParam++, "");
				}
				else {
					psajoutCom.setString(posParam++, liv_civ);
					psajoutCom.setString(posParam++, liv_nom);
					psajoutCom.setString(posParam++, liv_prenom);
				}
				psajoutCom.setString(posParam++, liv_tel);
				psajoutCom.setString(posParam++, liv_fax);
				psajoutCom.setString(posParam++, liv_email);
				
				
				psajoutCom.setString(posParam++, clientDenomination);
				psajoutCom.setString(posParam++, client_adresse);
				psajoutCom.setString(posParam++, client_compadresse);
				psajoutCom.setString(posParam++, client_adresse3);
				psajoutCom.setString(posParam++, client_cp);
				psajoutCom.setString(posParam++, client_ville);
				psajoutCom.setString(posParam++, client_code_pays);
				
				if (client_entreprise.equals("")) {
					psajoutCom.setString(posParam++, "0");
					psajoutCom.setString(posParam++, "");
					psajoutCom.setString(posParam++, "");
				}
				else {
					psajoutCom.setString(posParam++, client_civ);
					psajoutCom.setString(posParam++, client_nom);
					psajoutCom.setString(posParam++, client_prenom);
				}
				psajoutCom.setString(posParam++, client_tel);
				psajoutCom.setString(posParam++, client_fax);
				psajoutCom.setString(posParam++, client_email);
				
				psajoutCom.executeUpdate();

				rsnum = psajoutCom.getGeneratedKeys();

				if (rsnum.next()) {
					numCommande = rsnum.getInt(1);
				}
				
				
				if (com_statut_Paiement==1) {
					String ajoutReglement = "INSERT INTO " + base + ".REGLEMENT_CLIENT (" +
					  " Date_Reg, Mode_Reg_Id, Client_Id, Denomination, Banque_Remise, Num_Piece, Banque_Client, Montant, Montant_Restant, Etat, Compta_Enc," +
					  " Commentaires, Statut, Commande_Id" +
	                " ) VALUES ( " +
	                " ?,?,?,?,?,?,?,?,?,?,?," +
	                " ?,?,?)";
					PreparedStatement psajoutReglement = con.prepareStatement(ajoutReglement);

					psajoutReglement.setLong(1,com_date);
					if (modRegId>0) {
						psajoutReglement.setInt(2, modRegId);
					}
					else {
						psajoutReglement.setNull(2, java.sql.Types.INTEGER);
					}
					psajoutReglement.setString(3,clientId);
					psajoutReglement.setString(4,clientDenomination);
					if (banqueRemise>0) {
						psajoutReglement.setInt(5, banqueRemise);
					}
					else {
						psajoutReglement.setNull(5, java.sql.Types.INTEGER);
					}
					psajoutReglement.setString(6,"");
					psajoutReglement.setString(7,"");
					psajoutReglement.setDouble(8, com_totalTTC);
					psajoutReglement.setDouble(9, com_totalTTC);
					psajoutReglement.setString(10, "N");
					psajoutReglement.setInt(11, 0);
					psajoutReglement.setString(12, "");
					psajoutReglement.setString(13, "C");
					psajoutReglement.setInt(14, numCommande);
					psajoutReglement.executeUpdate();
				}
				
				Calcul calc2 = new Calcul (con,numCommande,"Commande", dossierId);
				calc2.majTotaux();
				
				String ajoutComWeb = "INSERT INTO " + base + ".COMMANDE_CLIENT_WEB (" +
				  " Commande_Id, Site_Web_Id, Ref_Com_Web, Num_Transaction, Origine, Client_Web_Id, Statut_Modifie, Mail_Manager, Code_Porte, Infos_Commande, Envoi_Multiple" +
                " ) VALUES ( " +
                " ?,?,?,?,?,?,?,?,?,?,?" +
                " )";
				PreparedStatement psajoutComWeb = con.prepareStatement(ajoutComWeb);

				psajoutComWeb.setInt(1, numCommande);
				psajoutComWeb.setString(2, site_id);
				psajoutComWeb.setString(3, com_id);
				psajoutComWeb.setString(4, com_numTransaction);
				psajoutComWeb.setString(5, com_origine);
				psajoutComWeb.setInt(6, (numClient!=0)?numClient:null);
				psajoutComWeb.setInt(7, 1);
				psajoutComWeb.setString(8, com_email_manager);
				psajoutComWeb.setString(9, com_codePorte);
				psajoutComWeb.setString(10, com_infosCommande);
				psajoutComWeb.setInt(11, com_envoi_multiple);
				
				psajoutComWeb.executeUpdate();

				/* ************************** */
				/* * DETAIL DE COMMANDE * */
				/* ************************** */

				String articleExiste = "SELECT Article_Id, Article_Web_Id from " + base + ".FICHE_ARTICLE_WEB faw" +
						               " where Site_Id=? AND Article_Id_Site=?";
				PreparedStatement psarticleExiste = con.prepareStatement(articleExiste);
				psarticleExiste.setString(1, site_id);
				
				String addDetail = "INSERT INTO " + base + ".LIGNE_COMMANDE_CLIENT (Commande_Id, Rank, Type_Ligne, Reference, Designation, Quantite, Prix_Unitaire, Ristourne," +
						           " Taux_TVA,Code_TVA, Commentaire_Avant, Commentaire_Apres, Article_Web_Id)";
				addDetail += " VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?) ";
				PreparedStatement psaddDetail = con.prepareStatement(addDetail);
				psaddDetail.setInt(1, numCommande);
				
				Object[] liste = com.getStruct(com.LISTE_ARTICLES);
				StockManager stockm = new StockManager(con,base);
				for (int i = 0; i < liste.length; i++) {

					ToolsMAJ.ecrireLog(aEcrire,type,"[UploadCommandes]Un prod");

					ArticleCommandeStruct article = new ArticleCommandeStruct((Object[]) liste[i]);

					// Recherche du code TVA
					Integer codeTVA = code_tva.get(new Double(article.getDouble(article.TVA)));
					if (codeTVA == null) {
						codeTVA = new Integer(4);
					}

					psarticleExiste.setString(2, article.getString(article.REFERENCE,40));
					ResultSet resArticleExiste = psarticleExiste.executeQuery();
					if (resArticleExiste.next()) {// L'article existe	
						
						psaddDetail.setInt(2, (i+1));
						psaddDetail.setString(3, "S");
						psaddDetail.setString(4, resArticleExiste.getString("Article_Id"));
						psaddDetail.setString(5, article.getString(article.DESIGNATION,100));
						psaddDetail.setDouble(6, article.getDouble(article.QUANTITE));
						psaddDetail.setDouble(7, article.getDouble(article.PRIX_U));
						psaddDetail.setDouble(8, 0);
						psaddDetail.setDouble(9, article.getDouble(article.TVA));
						psaddDetail.setInt(10, codeTVA);
						psaddDetail.setString(11, article.getString(article.COMMENTAIRE));
						psaddDetail.setString(12, "");
						psaddDetail.setInt(13, resArticleExiste.getInt("Article_Web_Id"));
						psaddDetail.addBatch();

						if ((com_statut_Paiement==1 && com_validation!=3) || com_validation==2) {
							stockm.incComClients(resArticleExiste.getString("Article_Id"), article.getDouble(article.QUANTITE),numEntier,"Commande Web");
						}
					}
					else {
						psaddDetail.setInt(2, (i+1));
						psaddDetail.setString(3, "I");
						psaddDetail.setString(4, article.getString(article.REFERENCE,100));
						psaddDetail.setString(5, article.getString(article.DESIGNATION,100));
						psaddDetail.setDouble(6, article.getDouble(article.QUANTITE));
						psaddDetail.setDouble(7, article.getDouble(article.PRIX_U));
						psaddDetail.setDouble(8, 0);
						psaddDetail.setDouble(9, article.getDouble(article.TVA));
						psaddDetail.setInt(10, codeTVA);
						psaddDetail.setString(11, article.getString(article.COMMENTAIRE));
						psaddDetail.setString(12, "");
						psaddDetail.setNull(13, Types.INTEGER);
						psaddDetail.addBatch();
					}
				}
				psaddDetail.executeBatch();
				Calcul calc = new Calcul (con,numCommande,"Commande", dossierId);
				
				PreparedStatement psUpCommandeClient = con.prepareStatement("update "  + base+ ".COMMANDE_CLIENT set Remise=? where Commande_Id=?");
				psUpCommandeClient.setDouble(1, calc.getRemisePCalcul());
				psUpCommandeClient.setInt(2, numCommande);
				psUpCommandeClient.executeUpdate();

				PreparedStatement psUpPrixArticles = con.prepareStatement("update "  + base+ ".LIGNE_COMMANDE_CLIENT set Prix_Achat=? where Ligne_Id=?");

				PreparedStatement psSelPrixArticles = con.prepareStatement("select lcc.Ligne_Id, coalesce(if(fa.Prix_Achat_Der=0,fa.Prix_Achat,fa.Prix_Achat_Der),0) as Prix_Achat from "  + base+ ".LIGNE_COMMANDE_CLIENT lcc " +
						" left join "  + base+ ".FICHE_ARTICLE fa on lcc.Reference=fa.Article_Id and lcc.Type_Ligne='S' where lcc.Commande_Id=?");
				psSelPrixArticles.setDouble(1, numCommande);
				ResultSet rsetSelPrixArticles = psSelPrixArticles.executeQuery();
				while (rsetSelPrixArticles.next()) {
					psUpPrixArticles.setDouble(1,rsetSelPrixArticles.getDouble("Prix_Achat"));
					psUpPrixArticles.setInt(2,rsetSelPrixArticles.getInt("Ligne_Id"));
					psUpPrixArticles.executeUpdate();
				}

				calc2 = new Calcul (con,numCommande,"Commande", dossierId);
				calc2.majTotaux();
				
			}

		}
		catch (Exception e) {
			ToolsMAJ.ecrireLog(aEcrire,type,"[UploadCommandes] ERREUR5:" + e);
			e.printStackTrace();

		}
	}
}
