/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 *  mise  jour des prix 
 */

package org.opensi.webmanager.modifications;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.webmanager.fonctions_periodiques.MAJPrix;

public class ActionMAJPrix extends Action {

	/**
	 * 
	 * @return
	 */
	public boolean serverSide() {
		return true;
	}

	/**
	 * 
	 * @param s
	 * @param r
	 * @param info
	 * @throws java.lang.Exception
	 * @return
	 */
	public boolean service(Session s, ServletRequest r, Object info) throws Exception {
		System.out.println("[ActionMAJPrix] Action! ");

		String base = r.getParameter("base");
		String site_id = r.getParameter("site_id");
		String dossierRoot = s.getAppConfiguration().get("opensi.absdir");
		String dossierId = r.getParameter("dossierId");
		System.out.println("[ActionMAJPrix] Apres les get parameters! ");
		String nbParEnvoi_str = s.getAppConfiguration().get("weblink.maxitem");
		String timeout_str = s.getAppConfiguration().get("weblink.timeout");
		int nbParEnvoi = Integer.parseInt(nbParEnvoi_str);
		int timeout = Integer.parseInt(timeout_str);
		String rapport_str = s.getAppConfiguration().get("weblink.nbrapports");
		int nbRapports = Integer.parseInt(rapport_str);

		System.out.println("[ActionMAJPrix] Apres les configs! ");

		Connection con = s.getConnection(null);
		String requeteParamServeur = "SELECT URL_Service";
		requeteParamServeur += " FROM " + base + ".SITE_WEB WHERE Site_Id='" + site_id + "'";

		PreparedStatement ps = con.prepareStatement(requeteParamServeur);
		ResultSet resultSetUrl = ps.executeQuery();

		String url_serveur = "";
		boolean reussi = false;
		if (resultSetUrl.next()) {
			System.out.println("[ActionMAJPrix]y a une url! ");

			url_serveur = resultSetUrl.getString("URL_Service");

			MAJPrix maj = new MAJPrix(nbParEnvoi, timeout, nbRapports);
			reussi = maj.lancerMAJ(url_serveur, dossierRoot, dossierId, con, base, site_id);

		}
		else {
			System.out.println("[ActionMAJPrix]il n'y a pas une url! ");
		}

		s.closeConnection(con, null);

		r.addParameter("reussite", (reussi)?"OUI":"NON");

		System.out.println("[ActionUploadCommandes] Fin. ");

		return true;
	}

}
