/*
 * Decompiled with CFR 0.152.
 */
package org.experlog.actions;

import java.io.File;
import java.io.PrintWriter;
import java.net.Socket;
import org.experlog.base.ESAction;
import org.experlog.base.ESCookie;
import org.experlog.base.ESServletRequest;
import org.experlog.gencode.DynHtml;
import org.experlog.gencode.ESDynHtml;
import org.experlog.util.AppConfiguration;
import org.experlog.util.Client;
import org.experlog.util.ESMailer;

public class SendMail
implements ESAction {
    public boolean serverSide() {
        return true;
    }

    public boolean processRequest(Client session, ESServletRequest req, DynHtml page, Object info) throws Exception {
        String template = req.getParameter("Template");
        if (template == null) {
            req.addParameter("MissingField", "Template");
            req.addParameter("ErrCode", "MISSINGFIELD");
            return false;
        }
        if (!AppConfiguration.isSecurePath(template)) {
            return false;
        }
        String from = req.getParameter("From");
        if (from == null || from.trim().length() < 5) {
            from = session.getAppConfiguration().get("email.From");
        }
        if (from == null || from.trim().length() < 5) {
            req.addParameter("MissingField", "From");
            req.addParameter("ErrCode", "MISSINGFIELD");
            return false;
        }
        String to = req.getParameter("To");
        if (to == null || to.trim().length() < 5) {
            to = session.getAppConfiguration().get("email.ManagerEmail");
        }
        if (to == null || to.trim().length() < 5) {
            req.addParameter("MissingField", "To");
            req.addParameter("ErrCode", "MISSINGFIELD");
            return false;
        }
        ESDynHtml expander = new ESDynHtml(session, null);
        expander.setServletRequest(req);
        String root = session.getAppConfiguration().getRootDir();
        String fnm = root.endsWith(File.separator) ? new String(root + template) : new String(root + File.separator + template);
        expander.setInputFile(new File(fnm));
        expander.addDataObject("Cookie", (ESCookie)session.getCookie());
        expander.addDataObject("ShopConfig", session.getAppConfiguration());
        expander.addDataObject("AppConfig", session.getAppConfiguration());
        String subject = req.getParameter("Subject");
        if (subject == null) {
            subject = new String("(No Subject)");
        }
        ESMailer mailer = new ESMailer(session.getAppConfiguration().get("email.MailHost"));
        String mailPort = session.getAppConfiguration().get("email.MailPort");
        if (mailPort != null) {
            try {
                mailer.setPort(Integer.parseInt(mailPort));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ("true".equalsIgnoreCase(session.getAppConfiguration().get("email.Legacy"))) {
            mailer.setLegacy(true);
        }
        mailer.setContentType(req.getParameter("Content_type"));
        Socket s = null;
        try {
            s = mailer.open();
            PrintWriter p = mailer.beginMessage(s, from, to, subject);
            expander.expand(p);
            mailer.endMessage(p);
            mailer.close(s);
        }
        catch (Exception ee) {
            System.err.println("SendMail:processRequest Exception " + ee);
            try {
                if (s != null) {
                    mailer.close(s);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            req.addParameter("ErrCode", "MAILERROR");
            req.addParameter("Info", ee.getMessage());
            return false;
        }
        return true;
    }
}

