/*
 * Decompiled with CFR 0.152.
 */
package org.experlog.actions;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.experlog.base.ESAction;
import org.experlog.base.ESCookie;
import org.experlog.base.ESServletRequest;
import org.experlog.gencode.DynHtml;
import org.experlog.gencode.ESDynHtml;
import org.experlog.util.AppConfiguration;
import org.experlog.util.Client;

public class SendMailMP
implements ESAction {
    public boolean serverSide() {
        return true;
    }

    public boolean processRequest(Client session, ESServletRequest req, DynHtml page, Object info) throws Exception {
        String header;
        String replyto;
        InternetAddress addressto;
        String stto;
        StringTokenizer stok;
        boolean norecipient;
        String bcc;
        String cc;
        String template = req.getParameter("Template");
        if (template == null && req.getParameter("Attachment") == null) {
            req.addParameter("MissingField", "Template");
            req.addParameter("ErrCode", "MISSINGFIELD");
            return false;
        }
        if (template != null && !AppConfiguration.isSecurePath(template)) {
            return false;
        }
        String from = req.getParameter("From");
        if (from == null || from.trim().length() < 5) {
            from = session.getAppConfiguration().get("email.From");
        }
        if (from == null || from.trim().length() < 5) {
            req.addParameter("MissingField", "From");
            req.addParameter("ErrCode", "MISSINGFIELD");
            return false;
        }
        String to = req.getParameter("To");
        if (to != null && to.trim().length() < 5) {
            to = null;
        }
        if ((cc = req.getParameter("Cc")) != null && cc.trim().length() < 5) {
            cc = null;
        }
        if ((bcc = req.getParameter("Bcc")) != null && bcc.trim().length() < 5) {
            bcc = null;
        }
        boolean bl = norecipient = to == null && cc == null && bcc == null;
        if (norecipient && ((to = session.getAppConfiguration().get("email.ManagerEmail")) == null || to.trim().length() < 5)) {
            req.addParameter("MissingField", "To");
            req.addParameter("ErrCode", "MISSINGFIELD");
            return false;
        }
        String subject = req.getParameter("Subject");
        if (subject == null) {
            subject = new String("(No Subject)");
        }
        Properties prop = new Properties();
        String mailHost = session.getAppConfiguration().get("email.MailHost");
        if (mailHost != null) {
            prop.put("mail.smtp.host", mailHost);
        }
        try {
            String mailPort = session.getAppConfiguration().get("email.MailPort");
            if (mailPort != null && Integer.parseInt(mailPort) != 25) {
                prop.put("mail.smtp.port", mailPort);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        String user = session.getAppConfiguration().get("email.User");
        String passwd = "";
        if (user != null) {
            prop.put("mail.smtp.auth", "true");
            passwd = session.getAppConfiguration().get("email.Password");
            if (passwd == null) {
                passwd = "";
            }
        }
        Session msession = Session.getDefaultInstance((Properties)prop, null);
        MimeMessage message = new MimeMessage(msession);
        String contentType = req.getParameter("Content_type");
        if (contentType == null) {
            contentType = "text/plain";
        }
        message.setSubject(subject);
        InternetAddress address = new InternetAddress(from);
        message.setFrom((Address)address);
        if (to != null) {
            stok = new StringTokenizer(to, ",");
            while (stok.hasMoreTokens()) {
                stto = stok.nextToken().trim();
                addressto = new InternetAddress(stto);
                message.addRecipient(Message.RecipientType.TO, (Address)addressto);
            }
        }
        if (cc != null) {
            stok = new StringTokenizer(cc, ",");
            while (stok.hasMoreTokens()) {
                stto = stok.nextToken().trim();
                addressto = new InternetAddress(stto);
                message.addRecipient(Message.RecipientType.CC, (Address)addressto);
            }
        }
        if (bcc != null) {
            stok = new StringTokenizer(bcc, ",");
            while (stok.hasMoreTokens()) {
                stto = stok.nextToken().trim();
                addressto = new InternetAddress(stto);
                message.addRecipient(Message.RecipientType.BCC, (Address)addressto);
            }
        }
        if ((replyto = req.getParameter("ReplyTo")) != null && replyto.length() >= 5) {
            StringTokenizer stok2 = new StringTokenizer(replyto, ",");
            InternetAddress[] addrs = new InternetAddress[stok2.countTokens()];
            int i = 0;
            while (stok2.hasMoreTokens()) {
                addrs[i++] = new InternetAddress(stok2.nextToken().trim());
            }
            message.setReplyTo((Address[])addrs);
        }
        if ((header = req.getParameter("ReturnReceiptTo")) != null) {
            message.addHeader("Return-Receipt-To", header);
        }
        if ((header = req.getParameter("ConfirmReadingTo")) != null) {
            message.addHeader("X-Confirm-Reading-To", header);
        }
        MimeMultipart multipart = new MimeMultipart();
        if (template != null) {
            ESDynHtml expander = new ESDynHtml(session, null);
            expander.setServletRequest(req);
            String root = session.getAppConfiguration().getRootDir();
            String fnm = root.endsWith(File.separator) ? new String(root + template) : new String(root + File.separator + template);
            expander.setInputFile(new File(fnm));
            expander.addDataObject("Cookie", (ESCookie)session.getCookie());
            expander.addDataObject("ShopConfig", session.getAppConfiguration());
            expander.addDataObject("AppConfig", session.getAppConfiguration());
            StringWriter sw = new StringWriter();
            PrintWriter p = new PrintWriter(sw);
            expander.expand(p);
            p.flush();
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setContent((Object)sw.getBuffer().toString(), contentType);
            multipart.addBodyPart((BodyPart)messageBodyPart);
        }
        String filename = req.getParameter("Attachment");
        String toRemove = new String();
        if (filename != null) {
            StringTokenizer st = new StringTokenizer(filename, ",;");
            while (st.hasMoreTokens()) {
                String afile = st.nextToken();
                if (afile == null) continue;
                String uploaddir = session.getAppConfiguration().getUploadDir();
                if (uploaddir == null) {
                    req.addParameter("MissingProperty", "app.UploadDir");
                    req.addParameter("ErrCode", "MISSINGPROPERTY");
                    return false;
                }
                if (!AppConfiguration.isSecurePathStrong(afile, uploaddir)) {
                    return false;
                }
                String nm = afile.startsWith(uploaddir) ? afile : (uploaddir.endsWith(File.separator) ? new String(uploaddir + afile) : new String(uploaddir + File.separator + afile));
                toRemove = toRemove + nm + ";";
                this.addAttachment(new File(nm), (Multipart)multipart);
            }
        }
        message.setContent((Multipart)multipart);
        message.saveChanges();
        if (user != null) {
            Transport transport = msession.getTransport("smtp");
            transport.connect(mailHost, user, passwd);
            transport.sendMessage((Message)message, message.getAllRecipients());
            transport.close();
        } else {
            Transport.send((Message)message);
        }
        String remove = req.getParameter("Remove");
        if (remove != null && remove.compareTo("1") == 0 && toRemove.length() > 0) {
            StringTokenizer st = new StringTokenizer(toRemove, ";");
            while (st.hasMoreTokens()) {
                this.deleteFileOrDir(new File(st.nextToken()));
            }
        }
        return true;
    }

    private void addAttachment(File f, Multipart multipart) throws MessagingException {
        String[] str = null;
        String base = null;
        if (f.isDirectory()) {
            base = f.getPath();
            str = f.list();
        } else {
            base = f.getParent();
            if (f.exists()) {
                str = new String[]{f.getName()};
            }
        }
        if (str == null) {
            return;
        }
        for (int i = 0; i < str.length; ++i) {
            String nm = base + File.separator + str[i];
            File test = new File(nm);
            if (test.isDirectory()) {
                this.addAttachment(test, multipart);
                continue;
            }
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            FileDataSource source = new FileDataSource(nm);
            messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
            messageBodyPart.setFileName(str[i]);
            multipart.addBodyPart((BodyPart)messageBodyPart);
        }
    }

    private void deleteFileOrDir(File f) throws IOException {
        if (f.isDirectory()) {
            File[] lst = f.listFiles();
            for (int i = 0; i < lst.length; ++i) {
                if (lst[i].isDirectory()) {
                    this.deleteFileOrDir(lst[i]);
                    continue;
                }
                lst[i].delete();
            }
        }
        if (f.exists()) {
            f.delete();
        }
    }
}

