/*
 * Decompiled with CFR 0.152.
 */
package org.experlog.actions;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.experlog.base.ESAction;
import org.experlog.base.ESServletRequest;
import org.experlog.gencode.DynHtml;
import org.experlog.util.Client;

public class XslTransform
implements ESAction {
    static Hashtable tCache_ = new Hashtable();
    static long delayedBy_ = 0L;

    public boolean serverSide() {
        return true;
    }

    public boolean processRequest(Client session, ESServletRequest req, DynHtml expander, Object info) throws Exception {
        long crt = System.currentTimeMillis();
        if (crt < delayedBy_) {
            req.addParameter("XsltDelayedBy", Long.toString(delayedBy_));
            return true;
        }
        req.addParameter("XsltDelayedBy", "0");
        long timeout = req.getLongParam("XsltTimeout", -1L);
        long delay = -1L;
        if (timeout > 0L) {
            delay = req.getLongParam("XsltDelay", 3L * timeout);
        }
        String xslt = req.getParameter("Xslt");
        String xml = req.getParameter("Xml");
        String cac = req.getParameter("XsltCache");
        boolean cache = cac != null && !"false".equalsIgnoreCase(cac);
        try {
            Transformer transformer = null;
            if (cache) {
                transformer = (Transformer)tCache_.get(xslt);
            }
            if (transformer == null) {
                TransformerFactory tFactory = TransformerFactory.newInstance();
                transformer = tFactory.newTransformer(new StreamSource(xslt));
                if (cache) {
                    tCache_.put(xslt, transformer);
                }
            }
            transformer.clearParameters();
            Enumeration pn = req.getParameterNames();
            while (pn.hasMoreElements()) {
                String nm = (String)pn.nextElement();
                if (!nm.startsWith("X-") || nm.length() <= 2) continue;
                transformer.setParameter(nm.substring(2), req.getParameter(nm));
            }
            transformer.transform(new StreamSource(xml), new StreamResult(req.getServletResponse().getWriter()));
            if (timeout > 0L && System.currentTimeMillis() - crt > timeout * 1000L) {
                delayedBy_ = System.currentTimeMillis() + delay * 1000L;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return false;
        }
    }
}

