/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.actions.commandeclient;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Iterator;

import org.opensi.api.ActionError;
import org.opensi.api.ActionOSI;
import org.opensi.api.LeevElement;
import org.opensi.api.Parameters;
import org.opensi.api.SessionOSI;
import org.opensi.bo.commandeclient.BOCommandeClient;
import org.opensi.data.dossier.CommandeClient;
import org.opensi.data.dossier.HistoriqueCommandeClient;
import org.opensi.data.dossier.LigneCommandeClient;
import org.opensi.dbm.dossier.DBM_CommandeClient;
import org.opensi.dbm.dossier.DBM_HistoriqueCommandeClient;
import org.opensi.dbm.dossier.DBM_LigneCommandeClient;
import org.opensi.facturation.StockManager;
import org.opensi.util.tools.DateTime;



public class UpdateLigneCommande implements ActionOSI {
	
	
	BOCommandeClient boComCli = null;
	
	public void processAction(SessionOSI sosi, Parameters param, LeevElement result, ActionError error) throws Exception {
	
		Connection con = sosi.getConnection();
		String baseDossier = sosi.getBaseDossier();
		int user = sosi.getUtilisateurId();

		boComCli = new BOCommandeClient(con,baseDossier);
		DBM_CommandeClient dbmComCli = new DBM_CommandeClient(con,baseDossier);
		DBM_LigneCommandeClient dbmLigneComCli = new DBM_LigneCommandeClient(con,baseDossier);
		
		int ligneId = param.getIntParameter("Ligne_Id");
		long datePeremption=0;
		int nbPieces=0;
		int codeTVA=0;
		String reference = "";
		String designation = "";
		double quantite = 0;
		double prix = 0;
		double ristourne = 0;
		double commission = 0;
		String libelle = "";
		String codeStats = "";
		String unite = "";
		String numLot = "";
		
		double prixAchat = 0;
		boolean prixAchatModifie = (param.getParameter("Prix_Achat")!=null);
		if (prixAchatModifie) { prixAchat = param.getDoubleParameter("Prix_Achat"); }
		else {
			datePeremption = param.getParameter("Date_Peremption").equals("")?0:param.getDateParameter("Date_Peremption");
			nbPieces = param.getParameter("Nb_Pieces").equals("")?0:param.getIntParameter("Nb_Pieces");
			codeTVA = param.getIntParameter("Code_TVA");
			reference = param.getParameter("Reference");
			designation = param.getParameter("Designation");
			quantite = param.getDoubleParameter("Quantite");
			prix = param.getDoubleParameter("Prix");
			ristourne = param.getDoubleParameter("Ristourne");
			commission = param.getDoubleParameter("Commission");
			libelle = param.getParameter("Libelle");
			codeStats = param.getParameter("Code_Stats");
			unite = param.getParameter("Unite");
			numLot = param.getParameter("Num_Lot");
		}
		
		LigneCommandeClient ligneCommandeClient = dbmLigneComCli.load(ligneId);
		int commandeId = boComCli.getLigneCommandeId(ligneId);
		CommandeClient commandeClient = dbmComCli.load(commandeId);
		
		boolean majStatuts = false;
		if (!prixAchatModifie) {
			double tauxTVA = 0;
			PreparedStatement psSelTauxTVA = con.prepareStatement("select Taux_TVA from "+ baseDossier +".TAUX_TVA where Code_TVA=?");
			psSelTauxTVA.setInt(1, codeTVA);
			ResultSet rset = psSelTauxTVA.executeQuery();
			while (rset.next()) {
				tauxTVA =rset.getDouble("Taux_TVA");
			}
			rset.close();
			
			ligneCommandeClient.setReference(reference);
			ligneCommandeClient.setDesignation(designation);
			ligneCommandeClient.setQuantite(quantite);
			ligneCommandeClient.setPrix(prix);
			ligneCommandeClient.setRistourne(ristourne);
			ligneCommandeClient.setCommission(commission);
			ligneCommandeClient.setTauxTVA(tauxTVA);
			ligneCommandeClient.setCodeTVA(codeTVA);
			ligneCommandeClient.setLibelle(libelle);
			ligneCommandeClient.setCodeStats(codeStats);
			ligneCommandeClient.setUnite(unite);
			ligneCommandeClient.setNbPieces(nbPieces);
			ligneCommandeClient.setNumLot(numLot);
			ligneCommandeClient.setDatePeremption(datePeremption);
		} else {
			ligneCommandeClient.setPrixAchat(prixAchat);
		}
		
		LigneCommandeClient ligneCommandeClientBase = dbmLigneComCli.load(ligneId);
		
		if (boComCli.isCloturee(commandeClient)) {
			error.addError(1002, "Impossible de modifier la commande car celle-ci est cl\u00F4tur\u00E9e !");
		}
		else if (!prixAchatModifie && boComCli.hasDocumentEnCours(commandeClient.getCommandeId())) {
			error.addError(1003, "Impossible de modifier la commande car celle-ci est li\u00E9e \u00E0 des documents en cours !");
		}
		else if (prixAchatModifie && boComCli.hasFactureEnCours(commandeClient.getCommandeId())) {
			result.addEntity("Alerte", "Attention : pensez \u00E0 r\u00E9percuter la modification du prix d'achat aux factures li\u00E9es \u00E0 la commande !");
		}
		else if (commandeClient.getEtat().equals("T")) {
			HashMap<String, String> diff = ligneCommandeClient.diff(ligneCommandeClientBase);
			if (diff.containsKey("Quantite") && boComCli.getLigneQuantiteLivree(ligneCommandeClient.getLigneId())>ligneCommandeClient.getQuantite()) {
				error.addError(1021, "Impossible d'avoir une quantit\u00E9 inf\u00E9rieure \u00E0 la quantit\u00E9 livr\u00E9e !");
			}
			if (diff.containsKey("Prix") || diff.containsKey("Ristourne") || diff.containsKey("CodeTVA") || diff.containsKey("TauxTVA")) {
				if (boComCli.getLigneQuantiteFacturee(ligneCommandeClient.getLigneId())>0) {
					error.addError(1022, "Impossible de modifier le prix d'une ligne de commande d\u00E9j\u00E0 factur\u00E9e !");
				}
			}
		}	
		if (error.isEmpty()) {
			if (commandeClient.getEtat().equals("T")) {
				DBM_HistoriqueCommandeClient dbmHistComCli = new DBM_HistoriqueCommandeClient(con, baseDossier);
				HistoriqueCommandeClient histComCli = new HistoriqueCommandeClient(0,new DateTime().getTimeInMillis(),"",commandeClient.getCommandeId(),user, ligneCommandeClient.getLigneId());
				
				LigneCommandeClient ligneCommandeClientEnCours = commandeClient.getLignesCommandeClient().get(ligneCommandeClient.getLigneId());
				HashMap<String, String> diff = ligneCommandeClient.diff(ligneCommandeClientEnCours);
				Iterator<String> i = diff.keySet().iterator();
				
				while (i.hasNext()) {
					String difference = i.next();
					histComCli.setLibelle("Modification sur l'article "+ligneCommandeClient.getReference()+" : "+diff.get(difference));
					dbmHistComCli.save(histComCli);
				}
				
				if (diff.containsKey("Quantite")) {
					if (ligneCommandeClientEnCours.getTypeLigne().equals("S") && !commandeClient.getBloque()) {
						double diffStock = ligneCommandeClientEnCours.getQuantite()-ligneCommandeClient.getQuantite();
						StockManager stock = new StockManager (con,baseDossier);
						if (diffStock>0) {
							stock.incComClients(ligneCommandeClient.getReference(), diffStock,commandeClient.getNumero(),"Modification Commande");
						}
						else {
							stock.decComClients(ligneCommandeClient.getReference(), diffStock,commandeClient.getNumero(),"Modification Commande");
						}
						
					}
					majStatuts = true;
					if (ligneCommandeClient.getQuantite()<boComCli.getLigneQuantiteFacturee(ligneId)) {
						result.addEntity("Message", "Attention : la diminution de la quantit\u00E9 devra faire l'objet d'un avoir !");
					}
				}
				if (diff.containsKey("Prix") || diff.containsKey("Ristourne") || diff.containsKey("CodeTVA") || diff.containsKey("TauxTVA")) {
					majStatuts = true;
					boComCli.majTotauxBLs(commandeClient.getCommandeId());
				}
			}
			CommandeClient commandeClientBase = dbmComCli.load(commandeId);
			dbmLigneComCli.update(ligneCommandeClient);
			boComCli.majTotaux(commandeId);
			if (majStatuts) {boComCli.majStatuts(commandeId, user);}
			dbmComCli.majModifCommande(commandeId, user);

			if (commandeClient.getEtat().equals("T")) {
				DBM_HistoriqueCommandeClient dbmHistComCli = new DBM_HistoriqueCommandeClient(con, baseDossier);
				HistoriqueCommandeClient histComCli = new HistoriqueCommandeClient(0,new DateTime().getTimeInMillis(),"",commandeClient.getCommandeId(),user, 0);
				commandeClient = dbmComCli.load(commandeId);
				HashMap<String, String> diff = commandeClient.diff(commandeClientBase, con, baseDossier);
				Iterator<String> i = diff.keySet().iterator();
				while (i.hasNext()) {
					String difference = i.next();
					if (difference.equals("TotalHT") || difference.equals("TotalTTC")) {
						histComCli.setLibelle(diff.get(difference));
						dbmHistComCli.save(histComCli);
					}
				}
			}
		}
	}
} // fin CreateDossier

