/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.actions.ecritures;


import java.sql.*;

import org.opensi.api.*;

import org.opensi.data.exercice.Operation;
import org.opensi.data.exercice.Ecriture;
import org.opensi.bo.BO_Ecritures;
import org.opensi.bo.BO_Exercices;
import org.opensi.bo.BO_Comptes;
import org.opensi.bo.BO_Journaux;


public class GenEcrEquiLettrage implements ActionOSI {
	
	
	public void processAction(SessionOSI sosi, Parameters param, LeevElement result, ActionError error) throws Exception {
	
		Connection con = sosi.getConnection();
		String baseDossier = sosi.getBaseDossier();
		String baseExo = sosi.getBaseExo();
		
		long date = param.getDateParameter("Date");
		String libelle = param.getParameter("Libelle");
		String contrepartie = param.getParameter("Contrepartie");
		String numeroCompte = param.getParameter("Numero_Compte");
		double solde = param.getDoubleParameter("Solde");
		String codeJournal = param.getParameter("Code_Journal");
		
		BO_Comptes boComptes = new BO_Comptes(con, baseDossier, baseExo);
		BO_Exercices boExercices = new BO_Exercices(con, baseDossier, baseExo);
		BO_Journaux boJournaux = new BO_Journaux(con, baseDossier);
		
		if (!boComptes.isAssignableCompte(numeroCompte)) {
			error.addError(1, "Impossible de g\u00E9n\u00E9rer l'\u00E9criture : le num\u00E9ro de compte est invalide !");
		}
		else if (!boComptes.isAssignableCompte(contrepartie)) {
			error.addError(1, "Impossible de g\u00E9n\u00E9rer l'\u00E9criture : le compte de contrepartie est invalide !");
		}
		else if (!boJournaux.isAssignableJournal(codeJournal)) {
			error.addError(1, "Impossible de g\u00E9n\u00E9rer l'\u00E9criture : le code journal est invalide !");
		}
		else if (!boExercices.checkDateInExo(date)) {
			error.addError(1, "Impossible de g\u00E9n\u00E9rer l'\u00E9criture : la date est en-dehors de l'exercice !");
		}
		else {
		
			Ecriture ecriture = new Ecriture();
			ecriture.setCodeJournal(codeJournal);
			ecriture.setDateEcriture(date);

			double credit = 0;
			double debit = 0;

			if (solde>0) {
				credit = solde;
			}
			else {
				debit = -solde;
			}	

			Operation op = new Operation();

			op.setDateOp(date);
			op.setLibelle(libelle);
			op.setContrepartie(contrepartie);
			op.setNumeroCompte(numeroCompte);
			op.setMontantD(debit);
			op.setMontantC(credit);

			ecriture.addOperation(op);

			op = new Operation();

			op.setDateOp(date);
			op.setLibelle(libelle);
			op.setContrepartie(numeroCompte);
			op.setNumeroCompte(contrepartie);
			op.setMontantD(credit);
			op.setMontantC(debit);

			ecriture.addOperation(op);

			BO_Ecritures boEcritures = new BO_Ecritures(con, baseDossier, baseExo);
			boEcritures.saveEcriture(ecriture);

			result.addEntity("Op_Id", ecriture.getOp(0).getOpId());
		}
	}
		

} // fin GenEcrEquiLettrage

