/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.actions.journaux;


import java.sql.*;

import org.opensi.api.*;

import org.opensi.bo.BO_Journaux;
import org.opensi.bo.BO_Comptes;

import org.opensi.data.dossier.Journal;
import org.opensi.dbm.dossier.DBM_Journal;


public class SaveJournal implements ActionOSI {
	
	
	public void processAction(SessionOSI sosi, Parameters param, LeevElement result, ActionError error) throws Exception {
	
		Connection con = sosi.getConnection();
		String baseDossier = sosi.getBaseDossier();
		String baseExo = sosi.getBaseExo();
		
		String codeJournal = param.getParameter("Code_Journal");
		String contrepartie = param.getNullParameter("Contrepartie");
		String typeJournal = param.getParameter("Type_Journal");
		String intitule = param.getParameter("Intitule");
										
		DBM_Journal dbmJournal = new DBM_Journal(con, baseDossier);
		BO_Journaux boJournaux = new BO_Journaux(con, baseDossier);
		BO_Comptes boComptes = new BO_Comptes(con, baseDossier, baseExo);
		
		if (intitule.isEmpty()) {
			error.addError(1, "Impossible d'enregistrer le journal : l'intitul\u00E9 est manquant !");
		}
		else if (!boJournaux.checkStxCodeJournal(codeJournal)) {
			error.addError(1, "Impossible d'enregistrer le journal : le code journal est manquant ou invalide !");
		}
		else if (!boJournaux.isTypeJournal(typeJournal)) {
			error.addError(1, "Impossible d'enregistrer le journal : le type journal est manquant ou invalide !");
		}
		else if (typeJournal.equals("TR") && (contrepartie==null || !boComptes.isAssignableCompte(contrepartie))) {
			error.addError(1, "Impossible d'enregistrer le journal : la contrepartie est manquante ou invalide !");
		}
		else {		
			Journal journal = dbmJournal.load(codeJournal);

			if (journal==null) journal = new Journal();

			journal.setCodeJournal(codeJournal);
			journal.setIntitule(intitule);
			journal.setTypeJournal(typeJournal);
			journal.setContrepartie(contrepartie);

			boJournaux.saveJournal(journal);
		}
	}		

} // fin SaveJournal

