package org.opensi.bo;

import java.sql.Connection;
import java.sql.SQLException;

import org.opensi.data.dossier.SecteurActivite;
import org.opensi.dbm.dossier.DBM_SecteurActivite;

public class BO_SecteurActivite {

	private Connection con;
	private String baseDossier;

	public BO_SecteurActivite(Connection con, String baseDossier) {

		this.con = con;
		this.baseDossier = baseDossier;
	}

	public void saveSecteur(SecteurActivite secteur) throws SQLException {

		DBM_SecteurActivite dbmCommandeClient = new DBM_SecteurActivite(con,baseDossier);
		dbmCommandeClient.insert(secteur);
	}

	public SecteurActivite load(int secteurId) throws SQLException {

		return new DBM_SecteurActivite(con, baseDossier).load(secteurId);

	}
	
	public SecteurActivite loadViaCodeSecteur(String sectActivite) throws SQLException
	{
		DBM_SecteurActivite dbm = new DBM_SecteurActivite(con,baseDossier);
		return dbm.loadViaCode_Secteur(sectActivite);
	}
	
public boolean exist(int codeSecteur) throws SQLException
{
	return new DBM_SecteurActivite(con,baseDossier).exist(codeSecteur);
}

}
