/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/
  
/**
 *  Sauvegarde dans la BD des modifs
 */

package org.opensi.compta.actions.tableauDeBord;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;



public class sauveTabBord extends Action {

	String chemin;
	
	String listeParam;
	String[] touteLaListe;
	int nbLignes;
	
	
  public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception {
		
		chemin = s.getAppConfiguration().get("opensi.absdir") ;
		Connection con = s.getConnection(null);

		String base = s.getCookie().get("BaseDossier");
		listeParam=r.getParameter("liste");
		String lib=r.getParameter("lib");
		int moisDebut=Integer.parseInt(r.getParameter("moisDebut"));
		int anneeDebut=Integer.parseInt(r.getParameter("anneeDebut"));

		if (!listeParam.equals("")) {
			touteLaListe = listeParam.split(",",0);
			nbLignes=touteLaListe.length;	
		}


		//suppression de l'existant
		String requeteDel="delete from "+ base +".SAUVE_TB where Libelle='"+lib+"'";

		Statement stt1 = con.createStatement();
		stt1.execute(requeteDel);

		if (!listeParam.equals(""))	{
			//Les insertions
			String requetInsert ="insert into "+ base +".SAUVE_TB values ('"+lib+"',?,?,?)";
			PreparedStatement stt2 = con.prepareStatement(requetInsert);

			int moisCourant=moisDebut;
			int anneeCourante=anneeDebut;

			for (int g=0; g<nbLignes;g++)	{
				stt2.setInt(1,moisCourant);
				stt2.setInt(2,anneeCourante);
				stt2.setLong(3,Long.parseLong(touteLaListe[g]));

				stt2.executeUpdate();

				moisCourant++;
				if (moisCourant>12) {
					moisCourant=1;
					anneeCourante++;
				}
			}
		}
		
		return true;	
	}
	
	
} // fin sauveTabBord

		
			
			










