/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 *   Import d'critures comptables
 */

package org.opensi.compta.actions.transferts;

import java.sql.Connection;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;






public class ImportPlan extends Action {


	private String vendorParserClass = "org.apache.xerces.parsers.SAXParser";

  public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception {
		
		try {
			Connection con = s.getConnection(null);
			String fichier = r.getParameter("Fichier");
			String planURI = s.getAppConfiguration().get("opensi.absdir") +"/plans_xml/"+fichier;//+ fichier;
			
			XMLReader planReader = XMLReaderFactory.createXMLReader(vendorParserClass);
			PlanHandler planHandler = new PlanHandler(con);
			
			planReader.setContentHandler(planHandler);
			planReader.setErrorHandler(planHandler);
			
			InputSource source = new InputSource(planURI);
			planReader.parse(source);
			s.closeConnection(con,null);
		}
		catch(SAXException saxe) {
			saxe.printStackTrace();
		}

		return true;
			
	}
} // fin ImportPlan




