/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.data.dossier;

import java.util.HashMap;

import java.sql.Connection;

import org.opensi.bo.BO_ModeLivraison;
import org.opensi.bo.BO_ModeReglement;
import org.opensi.bo.BO_SecteurActivite;
import org.opensi.bo.BO_Utilisateurs;

public class CommandeClient {
	
	private int commandeId;
	private String clientId;
	private int utilC;
	private int utilM;
	private int utilR;
	private long dateC;
	private long dateM;
	private String etat;
	private String statutLogistique;
	private long dateCommande;
	private long dateValidation;
	private long dateAnnulation;
	private String refCommande;	
	private String numero;
	private boolean editionTTC;
	private String regimeTVA;
	private boolean assujettiTVA;
	private String numTVAIntra;
	private boolean bloque;
	private int codeTarif;
	private long delai;
	private boolean soldee;
	private boolean facturee;
	private int modeExpedition;
	private int secteurActivite;
	private double tauxIndicatif;
	private int statutPaiement;
	private int modeReglement;
	private String commentairesFin;
	private String commentairesInt;
	private String commentairesHid;
	private String mentions;
	private double remise;
	private double montantRemise;
	private double pRemiseFP;
	private double mRemiseFP;
	private double escompte;
	private double fraisPort;
	private int codeTVAPort;
	private double tauxTVAPort;
	private double acompte;
	private double totalHT;
	private double totalTTC;
	private int versCalc;
	private Adresse adresseFact;
	private Contact contactFact;
	private Adresse adresseLiv;
	private Contact contactLiv;
	private Adresse adresseEnvoi;
	private Contact contactEnvoi;
	private CommandeClientWeb commandeClientWeb;

	private HashMap<Integer, LigneCommandeClient> lignesCommandeClient;

	public CommandeClient(int commandeId) {
		this.commandeId = commandeId;
		lignesCommandeClient = new HashMap<Integer, LigneCommandeClient>();
	}
	
	public CommandeClient(int commandeId,
							String clientId,
							int utilC,
							int utilM,
							int utilR,
							long dateC,
							long dateM,
							String etat,
							String statutLogistique,
							long dateCommande,
							long dateValidation,
							long dateAnnulation,
							String refCommande,
							String numero,
							boolean editionTTC,
							String regimeTVA,
							boolean assujettiTVA,
							String numTVAIntra,
							boolean bloque,
							int codeTarif,
							long delai,
							boolean soldee,
							boolean facturee,
							int modeExpedition,
							int secteurActivite,
							double tauxIndicatif,
							int statutPaiement,
							int modeReglement,
							String commentairesFin,
							String commentairesInt,
							String commentairesHid,
							String mentions,
							double remise,
							double montantRemise,
							double pRemiseFP,
							double mRemiseFP,
							double escompte,
							double fraisPort,
							int codeTVAPort,
							double tauxTVAPort,
							double acompte,
							double totalHT,
							double totalTTC,
							int versCalc,
							Adresse adresseFact,
							Contact contactFact,
							Adresse adresseLiv,
							Contact contactLiv,
							Adresse adresseEnvoi,
							Contact contactEnvoi,
							CommandeClientWeb commandeClientWeb
							) {
		
		this.commandeId = commandeId;
		this.clientId = clientId;
		this.utilC = utilC;
		this.utilM = utilM;
		this.utilR = utilR;
		this.dateC = dateC;
		this.dateM = dateM;
		this.etat = etat;
		this.statutLogistique = statutLogistique;
		this.dateCommande = dateCommande;
		this.dateValidation = dateValidation;
		this.dateAnnulation = dateAnnulation;
		this.refCommande = refCommande;
		this.numero = numero;
		this.editionTTC = editionTTC;
		this.regimeTVA = regimeTVA;
		this.assujettiTVA = assujettiTVA;
		this.numTVAIntra = numTVAIntra;
		this.bloque = bloque;
		this.codeTarif = codeTarif;
		this.delai = delai;
		this.soldee = soldee;
		this.facturee = facturee;
		this.modeExpedition = modeExpedition;
		this.secteurActivite = secteurActivite;
		this.tauxIndicatif = tauxIndicatif;
		this.statutPaiement = statutPaiement;
		this.modeReglement = modeReglement;
		this.commentairesFin = commentairesFin;
		this.commentairesInt = commentairesInt;
		this.commentairesHid = commentairesHid;
		this.mentions = mentions;
		this.remise = remise;
		this.montantRemise = montantRemise;
		this.pRemiseFP = pRemiseFP;
		this.mRemiseFP = mRemiseFP;
		this.escompte = escompte;
		this.fraisPort = fraisPort;
		this.codeTVAPort = codeTVAPort;
		this.tauxTVAPort = tauxTVAPort;
		this.acompte = acompte;
		this.totalHT = totalHT;
		this.totalTTC = totalTTC;
		this.versCalc = versCalc;
		this.adresseFact = adresseFact;
		this.contactFact = contactFact;
		this.adresseLiv = adresseLiv;
		this.contactLiv = contactLiv;
		this.adresseEnvoi = adresseEnvoi;
		this.contactEnvoi = contactEnvoi;
		this.commandeClientWeb = commandeClientWeb;
		lignesCommandeClient = new HashMap<Integer, LigneCommandeClient>();
	}
	
	public boolean isValid() {
		return true;
	}
	
	public HashMap<String, String> diff(CommandeClient commandeClient, Connection con, String baseDossier) {
		try {
		HashMap<String, String> diff = new HashMap<String, String>();

		BO_Utilisateurs boUtil = new BO_Utilisateurs(con);
		BO_ModeReglement boModeReg = new BO_ModeReglement(con, baseDossier);
		BO_ModeLivraison boModeLivraison = new BO_ModeLivraison(con, baseDossier);
		BO_SecteurActivite boSecteurActivite = new BO_SecteurActivite(con, baseDossier);

		if (this.equals(commandeClient)) {
			return diff;
		}
		/*if (getCommandeId()!=commandeClient.getCommandeId()) {
			String valeur = {Integer.toString(getCommandeId()),Integer.toString(commandeClient.getCommandeId())};
			diff.put("CommandeId",valeur); 
		}*/
		/*if ((getClientId()==null && getClientId()!=commandeClient.getClientId()) || (!getClientId().equals(commandeClient.getClientId()))) {
			String valeur = "N\u00B0 de client modifi de "+commandeClient.getClientId()+"  "+getClientId();
			diff.put("ClientId",valeur); 
		}
		*/	
		if (getUtilR()!=commandeClient.getUtilR()) {
			int ancUtilR = commandeClient.getUtilR();
			int nouvUtilR = getUtilR();
			String ancResp;
			String nouvResp;
			if (ancUtilR==0) { ancResp = "[Aucun]"; }
			else {
				String[] anc = boUtil.getNomPrenom(ancUtilR);
				ancResp = anc[0]+" "+anc[1];
			}
			if (nouvUtilR==0) { nouvResp = "[Aucun]"; }
			else {
				String[] nouv = boUtil.getNomPrenom(nouvUtilR);
				nouvResp = nouv[0]+" "+nouv[1];
			}
			
			String valeur = "Responsable modifi de "+ancResp+"  "+ nouvResp;
			diff.put("UtilR",valeur); 
		}
		/*if (getUtilM()!=commandeClient.getUtilM()) {
			String valeur = "Responsable modifi de "+commandeClient.getUtilR().getNomResponsable()+"  "+getUtilR().getNomResponsable();
			diff.put("UtilM",valeur); 
		}	*/
		/*if (getDateM()!=commandeClient.getDateM()) {
			String valeur = {Long.toString(getDateM()),Long.toString(commandeClient.getDateM())};
			diff.put("DateM",valeur); 
		}*/	
		if (!getRefCommande().equals(commandeClient.getRefCommande())) {
			String valeur = "Rference commande modifi de "+commandeClient.getRefCommande()+"  "+getRefCommande();
			diff.put("RefCommande",valeur); 
		}	
		if (getEditionTTC()!=commandeClient.getEditionTTC()) {
			String valeur = "Edition TTC modifi de "+(commandeClient.getEditionTTC()?"oui":"non")+"  "+(getEditionTTC()?"oui":"non");
			diff.put("EditionTTC",valeur); 
		}	
		if (!getRegimeTVA().equals(commandeClient.getRegimeTVA())) {
			String valeur = "Rgime de TVA modifi de "+getRegimeTVAFrancais(commandeClient.getRegimeTVA())+"  "+getRegimeTVAFrancais(getRegimeTVA());
			diff.put("RegimeTVA",valeur); 
		}	
		if (getAssujettiTVA()!=commandeClient.getAssujettiTVA()) {
			String valeur = "Assujetti TVA modifi de "+(commandeClient.getAssujettiTVA()?"oui":"non")+"  "+(getAssujettiTVA()?"oui":"non");
			diff.put("AssujettiTVA",valeur); 
		}
		if (!getNumTVAIntra().equals(commandeClient.getNumTVAIntra())) {
			String valeur = "Numro de TVA Intra modifi de "+commandeClient.getNumTVAIntra()+"  "+getNumTVAIntra();
			diff.put("NumTVAIntra",valeur); 
		}	
		if (getCodeTarif()!=commandeClient.getCodeTarif()) {
			String valeur = "Code tarif modifi de "+commandeClient.getNumTVAIntra()+"  "+getNumTVAIntra();
			diff.put("CodeTarif",valeur); 
		}	
		if (getDelai()!=commandeClient.getDelai()) {
			String valeur = "Delai modifi de "+commandeClient.getDelai()+"  "+getDelai();
			diff.put("Delai",valeur); 
		}	
		if (getModeReglement()!=commandeClient.getModeReglement()) {
			String valeur = "Mode de rglement modifi de "+boModeReg.load(commandeClient.getModeReglement()).getString("Libelle")+"  "+boModeReg.load(getModeReglement()).getString("Libelle");
			diff.put("ModeReglement",valeur); 
		}	
		if (getModeExpedition()!=commandeClient.getModeExpedition()) {
			int ancModeExp = commandeClient.getModeExpedition();
			int nouvModeExp = getModeExpedition();
			String valeur = "Mode d'expdition modifi de "+(ancModeExp==0?"[Aucun]":boModeLivraison.load(ancModeExp).getString("Nom"))+"  "+(nouvModeExp==0?"[Aucun]":boModeLivraison.load(nouvModeExp).getString("Nom"));
			diff.put("ModeExpedition",valeur); 
		}
		if (getSecteurActivite()!=commandeClient.getSecteurActivite()) {
			int ancSecteur = commandeClient.getSecteurActivite();
			int nouvSecteur = getSecteurActivite();
			String valeur = "Secteur d'activit modifi de "+(ancSecteur==0?"[Aucun]":boSecteurActivite.load(ancSecteur).getString("Libelle"))+"  "+(nouvSecteur==0?"[Aucun]":boSecteurActivite.load(nouvSecteur).getString("Libelle"));
			diff.put("SecteurActivite",valeur); 
		}	
		if (!getCommentairesFin().equals(commandeClient.getCommentairesFin())) {
			String valeur = "Commentaire fin de commande modifi de "+commandeClient.getCommentairesFin()+"  "+getCommentairesFin();
			diff.put("CommentairesFin",valeur); 
		}	
		if (!getCommentairesInt().equals(commandeClient.getCommentairesInt())) {
			String valeur = "Commentaire non imprimable modifi de "+commandeClient.getCommentairesInt()+"  "+getCommentairesInt();
			diff.put("CommentairesInt",valeur); 
		}	
		if (!getMentions().equals(commandeClient.getMentions())) {
			String valeur = "Mentions modifi de "+commandeClient.getMentions()+"  "+getMentions();
			diff.put("Mentions",valeur); 
		}	
		if (getMontantRemise()!=commandeClient.getMontantRemise()) {
			String valeur = "Montant de remise modifi de "+commandeClient.getMontantRemise()+"  "+getMontantRemise();
			diff.put("MontantRemise",valeur); 
		}
		if (getRemise()!=commandeClient.getRemise() && getMontantRemise()==0) {
			String valeur = "Pourcentage de remise modifi de "+commandeClient.getRemise()+"  "+getRemise();
			diff.put("Remise",valeur); 
		}
		if (getEscompte()!=commandeClient.getEscompte()) {
			String valeur = "Escompte modifi de "+commandeClient.getEscompte()+"  "+getEscompte();
			diff.put("Escompte",valeur); 
		}
		if (getFraisPort()!=commandeClient.getFraisPort()) {
			String valeur = "Frais de port modifi de "+commandeClient.getFraisPort()+"  "+getFraisPort();
			diff.put("FraisPort",valeur); 
		}
		if (getPRemiseFP()!=commandeClient.getPRemiseFP()) {
			String valeur = "Pourcentage de remise sur les frais de port modifi de "+commandeClient.getPRemiseFP()+"  "+getPRemiseFP();
			diff.put("PRemiseFP",valeur); 
		}
		if (getMRemiseFP()!=commandeClient.getMRemiseFP()) {
			String valeur = "Montant de remise sur les frais de port modifi de "+commandeClient.getMRemiseFP()+"  "+getMRemiseFP();
			diff.put("MRemiseFP",valeur); 
		}
		if (getTauxTVAPort()!=commandeClient.getTauxTVAPort()) {
			String valeur = "Taux de TVA sur les frais de port modifi de "+commandeClient.getTauxTVAPort()+"  "+getTauxTVAPort();
			diff.put("TauxTVAPort",valeur); 
		}
		if (getBloque()!=commandeClient.getBloque()) {
			String valeur = "Commande modifi de"+(commandeClient.getBloque()?"":" non")+" bloque  "+(getBloque()?"":" non")+" bloque";
			diff.put("Bloque",valeur); 
		}
		if (getTotalHT()!=commandeClient.getTotalHT()) {
			String valeur = "Total HT modifi de "+commandeClient.getTotalHT()+"  "+getTotalHT();
			diff.put("TotalHT",valeur); 
		}
		if (getTotalTTC()!=commandeClient.getTotalTTC()) {
			String valeur = "Total TTC modifi de "+commandeClient.getTotalTTC()+"  "+getTotalTTC();
			diff.put("TotalTTC",valeur); 
		}

		diff.putAll(getAdresseFact().diff(commandeClient.getAdresseFact(),"Adresse Facturation : ",con));
		diff.putAll(getContactFact().diff(commandeClient.getContactFact(),"Contact Facturation : ",con));
		diff.putAll(getAdresseLiv().diff(commandeClient.getAdresseLiv(),"Adresse Livraison : ",con));
		diff.putAll(getContactLiv().diff(commandeClient.getContactLiv(),"Contact Livraison : ",con));
		diff.putAll(getAdresseEnvoi().diff(commandeClient.getAdresseEnvoi(),"Adresse Envoi : ",con));
		diff.putAll(getContactEnvoi().diff(commandeClient.getContactEnvoi(),"Contact Envoi : ",con));
		
		return diff;
		}
		catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}

	public void addLigne(int ligneId, LigneCommandeClient ligneCommandeClient) { this.lignesCommandeClient.put(ligneId, ligneCommandeClient); }
	
	public int getCommandeId() { return commandeId; }
	public String getClientId() { return clientId; }
	public int getUtilC() { return utilC; }
	public int getUtilM() { return utilM; }
	public int getUtilR() { return utilR; }
	public long getDateC() { return dateC; }
	public long getDateM() { return dateM; }
	public String getEtat() { return etat; }
	public String getStatutLogistique() { return statutLogistique; }
	public long getDateCommande() { return dateCommande; }
	public long getDateValidation() { return dateValidation; }
	public long getDateAnnulation() { return dateAnnulation; }
	public String getRefCommande() { return refCommande; }
	public String getNumero() { return numero; }
	public boolean getEditionTTC() { return editionTTC; }
	public String getRegimeTVA() { return regimeTVA; }
	public boolean getAssujettiTVA() { return assujettiTVA; }
	public String getNumTVAIntra() { return numTVAIntra; }
	public boolean getBloque() { return bloque; }
	public int getCodeTarif() { return codeTarif; }
	public long getDelai() { return delai; }
	public boolean getSoldee() { return soldee; }
	public boolean getFacturee() { return facturee; }
	public int getModeExpedition() { return modeExpedition; }
	public int getSecteurActivite() { return secteurActivite; }
	public double getTauxIndicatif() { return tauxIndicatif; }
	public int getStatutPaiement() { return statutPaiement; }
	public int getModeReglement() { return modeReglement; }
	public String getCommentairesFin() { return commentairesFin; }
	public String getCommentairesInt() { return commentairesInt; }
	public String getCommentairesHid() { return commentairesHid; }
	public String getMentions() { return mentions; }
	public double getRemise() { return remise; }
	public double getMontantRemise() { return montantRemise; }
	public double getPRemiseFP() { return pRemiseFP; }
	public double getMRemiseFP() { return mRemiseFP; }
	public double getEscompte() { return escompte; }
	public double getFraisPort() { return fraisPort; }
	public int getCodeTVAPort() { return codeTVAPort; }
	public double getTauxTVAPort() { return tauxTVAPort; }
	public double getAcompte() { return acompte; }
	public double getTotalHT() { return totalHT; }
	public double getTotalTTC() { return totalTTC; }
	public int getVersCalc() { return versCalc; }
	public Adresse getAdresseFact() { return adresseFact; }
	public Contact getContactFact() { return contactFact; }
	public Adresse getAdresseLiv() { return adresseLiv; }
	public Contact getContactLiv() { return contactLiv; }
	public Adresse getAdresseEnvoi() { return adresseEnvoi; }
	public Contact getContactEnvoi() { return contactEnvoi; }
	public CommandeClientWeb getCommandeClientWeb() { return commandeClientWeb; }
	public HashMap<Integer, LigneCommandeClient> getLignesCommandeClient() { return lignesCommandeClient; }
	
	
	public void setCommandeId(int commandeId) {this.commandeId = commandeId;}
	public void setClientId(String clientId) {this.clientId = clientId;}
	public void setUtilC(int utilC) {this.utilC = utilC;}
	public void setUtilM(int utilM) {this.utilM = utilM;}
	public void setUtilR(int utilR) {this.utilR = utilR;}
	public void setDateC(long dateC) {this.dateC = dateC;}
	public void setDateM(long dateM) {this.dateM = dateM;}
	public void setEtat(String etat) {this.etat = etat;}
	public void setStatutLogistique(String statutLogistique) {this.statutLogistique = statutLogistique;}
	public void setDateCommande(long dateCommande) {this.dateCommande = dateCommande;}
	public void setDateValidation(long dateValidation) {this.dateValidation = dateValidation;}
	public void setDateAnnulation(long dateAnnulation) {this.dateAnnulation = dateAnnulation;}
	public void setRefCommande(String refCommande) {this.refCommande = refCommande;}
	public void setNumero(String numero) {this.numero = numero;}
	public void setEditionTTC(boolean editionTTC) {this.editionTTC = editionTTC;}
	public void setRegimeTVA(String regimeTVA) {this.regimeTVA = regimeTVA;}
	public void setAssujettiTVA(boolean assujettiTVA) {this.assujettiTVA = assujettiTVA;}
	public void setNumTVAIntra(String numTVAIntra) {this.numTVAIntra = numTVAIntra;}
	public void setBloque(boolean bloque) {this.bloque = bloque;}
	public void setCodeTarif(int codeTarif) {this.codeTarif = codeTarif;}
	public void setDelai(long delai) {this.delai = delai;}
	public void setSoldee(boolean soldee) {this.soldee = soldee;}
	public void setFacturee(boolean facturee) {this.facturee = facturee;}
	public void setModeExpedition(int modeExpedition) {this.modeExpedition = modeExpedition;}
	public void setSecteurActivite(int secteurActivite) {this.secteurActivite = secteurActivite;}
	public void setTauxIndicatif(double tauxIndicatif) {this.tauxIndicatif = tauxIndicatif;}
	public void setStatutPaiement(int statutPaiement) {this.statutPaiement = statutPaiement;}
	public void setModeReglement(int modeReglement) {this.modeReglement = modeReglement;}
	public void setCommentairesFin(String commentairesFin) {this.commentairesFin = commentairesFin;}
	public void setCommentairesInt(String commentairesInt) {this.commentairesInt = commentairesInt;}
	public void setCommentairesHid(String commentairesHid) {this.commentairesHid = commentairesHid;}
	public void setMentions(String mentions) {this.mentions = mentions;}
	public void setRemise(double remise) {this.remise = remise;}
	public void setMontantRemise(double montantRemise) {this.montantRemise = montantRemise;}
	public void setPRemiseFP(double remiseFP) {pRemiseFP = remiseFP;}
	public void setMRemiseFP(double remiseFP) {mRemiseFP = remiseFP;}
	public void setEscompte(double escompte) {this.escompte = escompte;}
	public void setFraisPort(double fraisPort) {this.fraisPort = fraisPort;}
	public void setCodeTVAPort(int codeTVAPort) {this.codeTVAPort = codeTVAPort;}
	public void setTauxTVAPort(double tauxTVAPort) {this.tauxTVAPort = tauxTVAPort;}
	public void setAcompte(double acompte) {this.acompte = acompte;}
	public void setTotalHT(double totalHT) {this.totalHT = totalHT;}
	public void setTotalTTC(double totalTTC) {this.totalTTC = totalTTC;}
	public void setVersCalc(int versCalc) {this.versCalc = versCalc;}
	public void setAdresseFact(Adresse adresseFact) {this.adresseFact = adresseFact;}
	public void setContactFact(Contact contactFact) {this.contactFact = contactFact;}
	public void setAdresseLiv(Adresse adresseLiv) {this.adresseLiv = adresseLiv;}
	public void setContactLiv(Contact contactLiv) {this.contactLiv = contactLiv;}
	public void setAdresseEnvoi(Adresse adresseEnvoi) {this.adresseEnvoi = adresseEnvoi;}
	public void setContactEnvoi(Contact contactEnvoi) {this.contactEnvoi = contactEnvoi;}
	public void setCommandeClientWeb(CommandeClientWeb commandeClientWeb) {this.commandeClientWeb = commandeClientWeb;}
	public void setLignesCommandeClient(HashMap<Integer, LigneCommandeClient> lignesCommandeClient) {this.lignesCommandeClient = lignesCommandeClient;}

	public String getRegimeTVAFrancais(String reg) {
		return (reg.equals("G"))?"Rgime gnral":(reg.equals("E"))?"Forcer l'exonration":(reg.equals("T"))?"Forcer l'application":"";
	}

} // fin CommandeClient
