/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/


package org.opensi.dbm.dossier;


import java.sql.*;
import java.util.ArrayList;

import org.opensi.data.dossier.Exercice;

import org.opensi.api.*;


public class DBM_Exercice implements DBM_Object {

	private Connection con;
	private String baseDossier;

	
	public DBM_Exercice(Connection con, String baseDossier) {
		
		this.baseDossier = baseDossier;
		this.con = con;		
	}
	
	
	public Exercice load(int exerciceId) throws SQLException {
	
		Exercice exercice = null;
	
		PreparedStatement psExo = con.prepareStatement("select * from "+ baseDossier +".EXERCICE where Exercice_Id=?");
		
		psExo.setInt(1, exerciceId);
		ResultSet rsE = psExo.executeQuery();
		
		if (rsE.next()) {			
			exercice = new Exercice(	exerciceId,
																rsE.getString("Nom_Base"),
																rsE.getLong("Debut_Exercice"),
																rsE.getLong("Fin_Exercice"),
																rsE.getInt("Duree_Exercice"),
																rsE.getInt("Num_Exercice"),
																rsE.getBoolean("Cloture"),
																rsE.getBoolean("Verrouille") );
		}
		
		return exercice;
	}
	
	
	public void insert(Exercice exercice) throws SQLException {
	
		PreparedStatement psNewExercice = con.prepareStatement("insert into "+ baseDossier +".EXERCICE (Num_Exercice, Debut_Exercice, Fin_Exercice, Duree_Exercice, Nom_Base) values (?,?,?,?,?)", Statement.RETURN_GENERATED_KEYS);

		psNewExercice.setInt(1, exercice.getNumExercice());
		psNewExercice.setLong(2, exercice.getDebutExercice());
		psNewExercice.setLong(3, exercice.getFinExercice());
		psNewExercice.setInt(4, exercice.getDureeExercice());
		psNewExercice.setString(5, exercice.getNomBase());

		psNewExercice.executeUpdate();

		ResultSet rsID = psNewExercice.getGeneratedKeys();
		rsID.next();
		exercice.setExerciceId(rsID.getInt(1));
		rsID.close();

		psNewExercice.close();
	}
	
	
	public ArrayList<String> getBasesExercices() throws SQLException {
		
		ArrayList<String> listeExos = new ArrayList<String>();
		
		PreparedStatement psBasesExo = con.prepareStatement("select Nom_Base from "+ baseDossier +".EXERCICE");
		
		ResultSet rsBE = psBasesExo.executeQuery();
		
		while (rsBE.next()) {
			listeExos.add(rsBE.getString("Nom_Base"));
		}
		rsBE.close();
		psBasesExo.close();
		
		return listeExos;
	}
	
	
	public void setCloture(int exerciceId) throws SQLException {

		PreparedStatement psCloture = con.prepareStatement("update "+ baseDossier +".EXERCICE set Cloture=1 where Exercice_Id=?");

		psCloture.setInt(1, exerciceId);
		psCloture.executeUpdate();
		psCloture.close();
	}
		

} // fin DBM_Exercice
