/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/


package org.opensi.dbm.dossier;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

import org.opensi.api.DBM_Object;
import org.opensi.data.dossier.HistoriqueCommandeClient;


public class DBM_HistoriqueCommandeClient implements DBM_Object {

	private Connection con;
	private String baseDossier;


	public DBM_HistoriqueCommandeClient(Connection con, String baseDossier) {
		
		this.con = con;
		this.baseDossier = baseDossier;
	}


	public void save(HistoriqueCommandeClient historiqueCommandeClient) throws SQLException {
		if (historiqueCommandeClient.isValid()) {
			PreparedStatement psInsHist = con.prepareStatement("insert into "+ baseDossier +".HISTORIQUE_COMMANDE_CLIENT (Date, Libelle,Commande_Id, Util_M , Ref_Ligne) values (?,?,?,?,?)");
			psInsHist.setLong(1, historiqueCommandeClient.getDate());
			psInsHist.setString(2, historiqueCommandeClient.getLibelle());
			psInsHist.setInt(3, historiqueCommandeClient.getCommandeId());
			psInsHist.setInt(4, historiqueCommandeClient.getUtilM());
			if (historiqueCommandeClient.getRefLigne()==0) {
				psInsHist.setNull(5, java.sql.Types.INTEGER);
			}
			else {
				psInsHist.setInt(5, historiqueCommandeClient.getRefLigne());
			}
			psInsHist.executeUpdate();
			
		}

	}
	
	public void delete(int histId) throws SQLException {
		
	}

	public HistoriqueCommandeClient load(int histId) throws SQLException {

		HistoriqueCommandeClient historiqueCommandeClient = null;
		
		return historiqueCommandeClient;
	}

} // fin DBM_HistoriqueCommandeClient
