/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/


package org.opensi.dbm.dossier;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.opensi.api.DBM_Object;
import org.opensi.data.dossier.LigneCommandeClient;


public class DBM_LigneCommandeClient implements DBM_Object {

	private Connection con;
	private String baseDossier;


	public DBM_LigneCommandeClient(Connection con, String baseDossier) {
		
		this.con = con;
		this.baseDossier = baseDossier;
	}


	public void update(LigneCommandeClient ligneCommandeClient) throws SQLException {

		if(ligneCommandeClient.isValid()) {
			PreparedStatement psUpLigne = con.prepareStatement("update "+ baseDossier +".LIGNE_COMMANDE_CLIENT set Reference=?, Designation=?," +
			"Quantite=?,Prix_Unitaire=?,Ristourne=?,Commission=?,Taux_TVA=?, Code_TVA=?, Libelle=?, Code_Stats=?, Unite=?, Nb_Pieces=?, Num_Lot=?, Date_Peremption=?, Statut=?, Prix_Achat=? where Ligne_Id=?");
			psUpLigne.setString(1, ligneCommandeClient.getReference());
			psUpLigne.setString(2, ligneCommandeClient.getDesignation());
			psUpLigne.setDouble(3, ligneCommandeClient.getQuantite());
			psUpLigne.setDouble(4, ligneCommandeClient.getPrix());
			psUpLigne.setDouble(5, ligneCommandeClient.getRistourne());
			psUpLigne.setDouble(6, ligneCommandeClient.getCommission());
			psUpLigne.setDouble(7, ligneCommandeClient.getTauxTVA());
			psUpLigne.setInt(8, ligneCommandeClient.getCodeTVA());
			psUpLigne.setString(9, ligneCommandeClient.getLibelle());
			psUpLigne.setString(10, ligneCommandeClient.getCodeStats());
			psUpLigne.setString(11, ligneCommandeClient.getUnite());
			psUpLigne.setInt(12, ligneCommandeClient.getNbPieces());
			psUpLigne.setString(13, ligneCommandeClient.getNumLot());
			psUpLigne.setDouble(14, ligneCommandeClient.getDatePeremption());
			psUpLigne.setString(15, ligneCommandeClient.getStatut());
			psUpLigne.setDouble(16, ligneCommandeClient.getPrixAchat());
			psUpLigne.setInt(17, ligneCommandeClient.getLigneId());
			psUpLigne.executeUpdate();			
		}
	}

	public int insert(int commandeId,LigneCommandeClient ligneCommandeClient) throws SQLException {
		
		int ligneId = 0;
		if(ligneCommandeClient.isValid()) {
			PreparedStatement psUpLigne = con.prepareStatement("insert into "+ baseDossier +".LIGNE_COMMANDE_CLIENT (Commande_Id, Rank, Type_Ligne, Reference, Designation, Quantite, Prix_Unitaire, Ristourne, Commission, Taux_TVA, Code_TVA, Commentaire_Avant, Commentaire_Apres, Libelle, Code_Stats, Unite, Nb_Pieces, Num_Lot, Date_Peremption, Article_Web_Id, Prix_Achat)" +
					" values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
			psUpLigne.setInt(1, commandeId);
			psUpLigne.setInt(2, ligneCommandeClient.getRank());
			psUpLigne.setString(3, ligneCommandeClient.getTypeLigne());
			psUpLigne.setString(4, ligneCommandeClient.getReference());
			psUpLigne.setString(5, ligneCommandeClient.getDesignation());
			psUpLigne.setDouble(6, ligneCommandeClient.getQuantite());
			psUpLigne.setDouble(7, ligneCommandeClient.getPrix());
			psUpLigne.setDouble(8, ligneCommandeClient.getRistourne());
			psUpLigne.setDouble(9, ligneCommandeClient.getCommission());
			psUpLigne.setDouble(10, ligneCommandeClient.getTauxTVA());
			psUpLigne.setInt(11, ligneCommandeClient.getCodeTVA());
			psUpLigne.setString(12, ligneCommandeClient.getCommentaireAvant());
			psUpLigne.setString(13, ligneCommandeClient.getCommentaireApres());
			psUpLigne.setString(14, ligneCommandeClient.getLibelle());
			psUpLigne.setString(15, ligneCommandeClient.getCodeStats());
			psUpLigne.setString(16, ligneCommandeClient.getUnite());
			psUpLigne.setInt(17, ligneCommandeClient.getNbPieces());
			psUpLigne.setString(18, ligneCommandeClient.getNumLot());
			psUpLigne.setLong(19, ligneCommandeClient.getDatePeremption());
			if (ligneCommandeClient.getArticleWebId()==0) {
				psUpLigne.setNull(20,java.sql.Types.INTEGER);
			}
			else {
				psUpLigne.setInt(20,ligneCommandeClient.getArticleWebId());
			}
			psUpLigne.setDouble(21, ligneCommandeClient.getPrixAchat());
			psUpLigne.executeUpdate();
			
			ResultSet rsID = psUpLigne.getGeneratedKeys();
			rsID.next();
			ligneId = rsID.getInt(1);
			rsID.close();
		}
		
		return ligneId;
	}

	
	public void delete(int ligneId) throws SQLException {
		PreparedStatement psDelLigne = con.prepareStatement("delete from "+ baseDossier +".LIGNE_COMMANDE_CLIENT where Ligne_Id=?");
		psDelLigne.setInt(1, ligneId);
		psDelLigne.executeUpdate();			
	}


	public LigneCommandeClient load(int ligneId) throws SQLException {

		LigneCommandeClient ligneCommandeClient = null;

		PreparedStatement psLigCom = con.prepareStatement("select * from "+ baseDossier +".LIGNE_COMMANDE_CLIENT where Ligne_Id=? order by Rank");

		psLigCom.setInt(1, ligneId);
		ResultSet rsLC = psLigCom.executeQuery();
		if (rsLC.next()) {
			ligneCommandeClient = new LigneCommandeClient(	
					rsLC.getInt("Ligne_Id"),
					rsLC.getInt("Rank"),
					rsLC.getString("Type_Ligne"),
					rsLC.getString("Reference"),
					rsLC.getString("Designation"),
					rsLC.getString("Code_Stats"),
					rsLC.getString("Num_Lot"),
					rsLC.getString("Libelle"),
					rsLC.getDouble("Quantite"),
					rsLC.getString("Unite"),
					rsLC.getInt("Nb_Pieces"),
					rsLC.getLong("Date_Peremption"),
					rsLC.getDouble("Prix_Unitaire"),
					rsLC.getDouble("Ristourne"),
					rsLC.getInt("Code_TVA"),
					rsLC.getDouble("Taux_TVA"),
					rsLC.getDouble("Commission"),
					rsLC.getDouble("Prix_Achat"),
					rsLC.getDouble("Montant_Ligne"),
					rsLC.getBoolean("Soldee"),
					rsLC.getString("Commentaire_Avant"),
					rsLC.getString("Commentaire_Apres"),
					rsLC.getString("Statut"),
					rsLC.getInt("Article_Web_Id"),
					rsLC.getDouble("Marge_Ligne")
			);
		}
		rsLC.close();

		return ligneCommandeClient;
	}

} // fin DBM_CommandeClient
