/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/


package org.opensi.dbm.exercice;


import java.sql.*;

import org.opensi.api.*;

import org.opensi.data.exercice.Operation;


public class DBM_Operation implements DBM_Object {

	private Connection con;
	private String baseExo;
	

	public DBM_Operation(Connection con, String baseExo) {
	
		this.con = con;
		this.baseExo = baseExo;
	}
		
		
	public Operation load(int opId) throws SQLException {
		
		Operation operation = null;
		
		PreparedStatement psOp = con.prepareStatement("select * from "+ baseExo +".OPERATION where Op_Id=?");

		psOp.setInt(1, opId);

		ResultSet rsO = psOp.executeQuery();

		if (rsO.next()) {

			operation = new Operation();
			
			operation.setOpId(rsO.getInt("Op_Id"));
			operation.setNumLigne(rsO.getInt("Num_Ligne"));
			operation.setNumeroCompte(rsO.getString("Numero_Compte"));
			operation.setMontantD(rsO.getDouble("Montant_D"));
			operation.setMontantC(rsO.getDouble("Montant_C"));
			operation.setLibelle(rsO.getString("Libelle"));
			operation.setNumPiece(rsO.getString("Num_Piece"));
			operation.setContrepartie(rsO.getString("Contrepartie"));
			operation.setLettre(rsO.getString("Lettre"));
			operation.setDateOp(rsO.getLong("Date_Op"));
			operation.setDateEcheance(rsO.getLong("Date_Echeance"));
			operation.setPointage(rsO.getInt("Pointage"));																	
			operation.setCommentaire(rsO.getString("Commentaire"));
			operation.setModeRegId(rsO.getInt("Mode_Reg_Id"));			
			operation.setEcritureId(rsO.getInt("Ecriture_Id"));
			operation.setDateLettrage(rsO.getLong("Date_Lettrage"));
			operation.setDateC(rsO.getLong("Date_C"));
			operation.setDateM(rsO.getLong("Date_M"));
			operation.setUtilC(rsO.getInt("Util_C"));
			operation.setUtilM(rsO.getInt("Util_M"));     
		}
		
		psOp.close();

		return operation;
	}
	
	
	public void insert(Operation operation) throws SQLException {
		
		String newOperation = "insert into "+ baseExo +".OPERATION (Ecriture_Id, Num_Ligne, Numero_Compte, Montant_D, Montant_C,"
														+ "Libelle, Num_Piece, Contrepartie, Lettre, Date_Op, Date_Echeance, Mode_Reg_Id, Date_C, Date_M, Util_C, Util_M) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,0,0)";
	
		PreparedStatement psNewOp = con.prepareStatement(newOperation, Statement.RETURN_GENERATED_KEYS);
		
		long currentTime = System.currentTimeMillis();
		
		psNewOp.setInt(1, operation.getEcritureId());
		psNewOp.setInt(2, operation.getNumLigne());
		psNewOp.setString(3, operation.getNumeroCompte());
		psNewOp.setDouble(4, operation.getMontantD());
		psNewOp.setDouble(5, operation.getMontantC());
		psNewOp.setString(6, operation.getLibelle());
		psNewOp.setString(7, operation.getNumPiece());
		psNewOp.setString(8, operation.getContrepartie());
		psNewOp.setString(9, operation.getLettre());
		psNewOp.setLong(10, operation.getDateOp());
		psNewOp.setLong(11, operation.getDateEcheance());
		if (operation.getModeRegId()==0) {
			psNewOp.setNull(12, Types.INTEGER);
		}
		else {
			psNewOp.setInt(12, operation.getModeRegId());
		}
		psNewOp.setLong(13, currentTime);
		psNewOp.setLong(14, currentTime);
    psNewOp.executeUpdate();

		ResultSet rsID = psNewOp.getGeneratedKeys();
		rsID.next();
		operation.setOpId(rsID.getInt(1));
		rsID.close();
		
		psNewOp.close();
	}
	
	
	public void update(Operation operation) throws SQLException {
	
		String majOperation = " update "+ baseExo +".OPERATION set"
												+ " Num_Ligne=?, Numero_Compte=?, Montant_D=?, Montant_C=?, Libelle=?, Num_Piece=?,"
												+ " Contrepartie=?, Lettre=?, Date_Op=?, Date_Echeance=?, Mode_Reg_Id=?, Date_M=?, Util_M=0"
												+ " where Op_Id=?";

		PreparedStatement psMajOp = con.prepareStatement(majOperation);
	
		psMajOp.setInt(1, operation.getNumLigne());
		psMajOp.setString(2, operation.getNumeroCompte());
		psMajOp.setDouble(3, operation.getMontantD());
		psMajOp.setDouble(4, operation.getMontantC());
		psMajOp.setString(5, operation.getLibelle());
		psMajOp.setString(6, operation.getNumPiece());
		psMajOp.setString(7, operation.getContrepartie());
		psMajOp.setString(8, operation.getLettre());
		psMajOp.setLong(9, operation.getDateOp());
		psMajOp.setLong(10, operation.getDateEcheance());
		if (operation.getModeRegId()==0) {
			psMajOp.setNull(11, Types.INTEGER);
		}
		else {
			psMajOp.setInt(11, operation.getModeRegId());
		}
		psMajOp.setLong(12, System.currentTimeMillis());
		psMajOp.setInt(13, operation.getOpId());
		psMajOp.executeUpdate();
		
		psMajOp.close();
	}
	
	
	public void delete(int opId) throws SQLException {
	
		PreparedStatement psSupOp = con.prepareStatement("delete from "+ baseExo +".OPERATION where Op_Id=?");
				
		psSupOp.setInt(1, opId);
		psSupOp.executeUpdate();
		psSupOp.close();
	}
	
	
	public void deleteOpsEcriture(int ecritureId) throws SQLException {
	
		PreparedStatement psSupOps = con.prepareStatement("delete from "+ baseExo +".OPERATION where Ecriture_Id=?");
				
		psSupOps.setInt(1, ecritureId);
		psSupOps.executeUpdate();
		psSupOps.close();
	}
	
	
	public void lettrer(String listeOpId, String lettre) throws SQLException {
		
		long currentTime = System.currentTimeMillis();
		
		PreparedStatement	psLet = con.prepareStatement("update "+ baseExo +".OPERATION set Lettre=?, Date_Lettrage=?, Date_M=?, Util_M=0 where Op_Id in ("+ listeOpId +")");
		psLet.setString(1, lettre);
		psLet.setLong(2, currentTime);
		psLet.setLong(3, currentTime);
		psLet.executeUpdate();
		psLet.close();
	}
	
	
	public void delettrer(String numeroCompte, String lettre) throws SQLException {
		
		PreparedStatement	psDLet = con.prepareStatement("update "+ baseExo +".OPERATION set Lettre='', Date_Lettrage=0, Date_M=?, Util_M=0 where Numero_Compte=? and Lettre=?");
		psDLet.setLong(1, System.currentTimeMillis());
		psDLet.setString(2, numeroCompte);
		psDLet.setString(3, lettre);
		psDLet.executeUpdate();
		psDLet.close();
	}
	
	
	public int changeCompteOp(String compteSrc, String compteDest, String listeOpId) throws SQLException {
		
		PreparedStatement	psChgCpte = con.prepareStatement("update "+ baseExo +".OPERATION set Numero_Compte=?, Date_M=?, Util_M=0 where Numero_Compte=?"+ (listeOpId==null?"":" and Op_Id in ("+ listeOpId +")"));
		
		psChgCpte.setString(1, compteDest);
		psChgCpte.setLong(2, System.currentTimeMillis());
		psChgCpte.setString(3, compteSrc);
		int nbUp = psChgCpte.executeUpdate();
		psChgCpte.close();
		
		return nbUp;
	}
	
	
} // fin DBM_Operation
