/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.facturation;


import java.util.Calendar;


public class CalcDateEcheance {

	
	private Calendar c;
	
	private String typeReg;
	private int delaiReg;
	private int jourReg;
	
	
	public CalcDateEcheance(String typeReg, int delaiReg, int jourReg) {
	
		this.c = Calendar.getInstance();
		
		this.typeReg = typeReg;
		this.delaiReg = delaiReg;
		this.jourReg = jourReg;
	}
	
	
	// retourne la date d'chance calcule en fonction de la date de rfrence
	public long getEcheance(long dateRef) {
	
		c.setTimeInMillis(dateRef);
		int year = c.get(Calendar.YEAR);
		int month = c.get(Calendar.MONTH);
		int day = c.get(Calendar.DAY_OF_MONTH);
		
		c.clear();
		
		if (typeReg.equalsIgnoreCase("N")) {
			
			// jours nets
			c.set(year, month, day+delaiReg);
		}
		else {
			int nbMoisSup = delaiReg/30;
			int nbjourssup = delaiReg%30;
			if (typeReg.equalsIgnoreCase("F")) {
			
				// fin de mois
				if (nbjourssup>0) {
					c.set(year, month, day+delaiReg);
					c.getTimeInMillis();// pour actualiser la date
				}
				else {
					c.set(year, month+nbMoisSup, 1);
				}
				c.set(Calendar.DAY_OF_MONTH, c.getActualMaximum(Calendar.DAY_OF_MONTH));
			}
			else if (typeReg.equalsIgnoreCase("L")) {
				
				// fin de mois le
				if (nbjourssup>0) {
					c.set(year, month+1, day+delaiReg);
					c.getTimeInMillis();// pour actualiser la date
				}
				else {
					c.set(year, month+nbMoisSup+1, 1);	
				}
				int maxJour = c.getActualMaximum(Calendar.DAY_OF_MONTH);
				c.getTimeInMillis();// pour actualiser la date		
				c.set(Calendar.DAY_OF_MONTH, (jourReg<maxJour?jourReg:maxJour));
			}		
		}
		
		return c.getTimeInMillis();
	}
	
	
	public void setTypeReg(String typeReg) { this.typeReg = typeReg; }
	public void setDelaiReg(int delaiReg) { this.delaiReg = delaiReg; }
	public void setJourReg(int jourReg) { this.jourReg = jourReg; }

}

