/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.facturation;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.experlog.openeas.api.Session;
import org.opensi.util.tools.DateTime;



public class VersionDocument {
	
	private Connection con;
	private String base;
	private Session s;
	
	private String typeDoc;
	private int documentId;
	private long dateEdition;
	private int utilE;
	private String email;
	
	
	public VersionDocument(String s_, String typeDoc, int documentId, String email) {
		try {
			
			this.s = Session.findClient(s_);
			this.con = s.getConnection(null);
			this.base = s.getCookie().get("BaseDossier");
			
			this.typeDoc = typeDoc;
			this.documentId = documentId;
			this.dateEdition = new DateTime().getTimeInMillis();
			this.utilE = Integer.parseInt(this.s.getCookie().get("User"));
			this.email = email;
			
			this.insererVersion();
			
		} catch(Exception e) {
			e.printStackTrace();
		}
	}
	
	
	public void insererVersion() throws SQLException {
		
		int numVersion = 1;
		
		String reqInfosVersionDocument = "";
		String reqNouvelleVersion = "";
		
		if (this.typeDoc.equals("Commande_Client")) {
			reqInfosVersionDocument = "select vd.Num_Version, vd.Date_Edition, cc.Date_M from "+ this.base +".VERSION_DOCUMENT vd";
			reqInfosVersionDocument += " join "+ this.base +".VERSION_COMMANDE_CLIENT v on vd.Version_Id=v.Version_Id and v.Commande_Id=?";
			reqInfosVersionDocument += " join "+ this.base +".COMMANDE_CLIENT cc on v.Commande_Id=cc.Commande_Id";
			reqInfosVersionDocument += " order by vd.Version_Id desc limit 1";
			reqNouvelleVersion = "insert into "+ this.base +".VERSION_COMMANDE_CLIENT (Version_Id, Commande_Id) values (?,?)";
		} else if (this.typeDoc.equals("Devis")) {
			reqInfosVersionDocument = "select vd.Num_Version, vd.Date_Edition, d.Date_M from "+ this.base +".VERSION_DOCUMENT vd";
			reqInfosVersionDocument += " join "+ this.base +".VERSION_DEVIS v on vd.Version_Id=v.Version_Id and v.Devis_Id=?";
			reqInfosVersionDocument += " join "+ this.base +".DEVIS d on v.Devis_Id=d.Devis_Id";
			reqInfosVersionDocument += " order by vd.Version_Id desc limit 1";
			reqNouvelleVersion = "insert into "+ this.base +".VERSION_DEVIS (Version_Id, Devis_Id) values (?,?)";
		} else if (this.typeDoc.equals("Acompte_Client")) {
			reqInfosVersionDocument = "select vd.Num_Version, vd.Date_Edition, ac.Date_M from "+ this.base +".VERSION_DOCUMENT vd";
			reqInfosVersionDocument += " join "+ this.base +".VERSION_ACOMPTE_CLIENT v on vd.Version_Id=v.Version_Id and v.Acompte_Id=?";
			reqInfosVersionDocument += " join "+ this.base +".ACOMPTE_CLIENT ac on v.Acompte_Id=ac.Acompte_Id";
			reqInfosVersionDocument += " order by vd.Version_Id desc limit 1";
			reqNouvelleVersion = "insert into "+ this.base +".VERSION_ACOMPTE_CLIENT (Version_Id, Acompte_Id) values (?,?)";
		} else if (this.typeDoc.equals("Facture")) {
			reqInfosVersionDocument = "select vd.Num_Version, vd.Date_Edition, f.Date_M from "+ this.base +".VERSION_DOCUMENT vd";
			reqInfosVersionDocument += " join "+ this.base +".VERSION_FACTURE v on vd.Version_Id=v.Version_Id and v.Facture_Id=?";
			reqInfosVersionDocument += " join "+ this.base +".FACTURE f on v.Facture_Id=f.Facture_Id";
			reqInfosVersionDocument += " order by vd.Version_Id desc limit 1";
			reqNouvelleVersion = "insert into "+ this.base +".VERSION_FACTURE (Version_Id, Facture_Id) values (?,?)";
		} else if (this.typeDoc.equals("Avoir")) {
			reqInfosVersionDocument = "select vd.Num_Version, vd.Date_Edition, a.Date_M from "+ this.base +".VERSION_DOCUMENT vd";
			reqInfosVersionDocument += " join "+ this.base +".VERSION_AVOIR v on vd.Version_Id=v.Version_Id and v.Avoir_Id=?";
			reqInfosVersionDocument += " join "+ this.base +".AVOIR a on v.Avoir_Id=a.Avoir_Id";
			reqInfosVersionDocument += " order by vd.Version_Id desc limit 1";
			reqNouvelleVersion = "insert into "+ this.base +".VERSION_AVOIR (Version_Id, Avoir_Id) values (?,?)";
		} else if (this.typeDoc.equals("Proforma")) {
			reqInfosVersionDocument = "select vd.Num_Version, vd.Date_Edition, 0 as Date_M from "+ this.base +".VERSION_DOCUMENT vd";
			reqInfosVersionDocument += " join "+ this.base +".VERSION_PROFORMA v on vd.Version_Id=v.Version_Id and v.Proforma_Id=?";
			reqInfosVersionDocument += " order by vd.Version_Id desc limit 1";
			reqNouvelleVersion = "insert into "+ this.base +".VERSION_PROFORMA (Version_Id, Proforma_Id) values (?,?)";
		} else if (this.typeDoc.equals("Commande_Fournisseur")) {
			reqInfosVersionDocument = "select vd.Num_Version, vd.Date_Edition, cf.Date_M from "+ this.base +".VERSION_DOCUMENT vd";
			reqInfosVersionDocument += " join "+ this.base +".VERSION_COMMANDE_FOURNISSEUR v on vd.Version_Id=v.Version_Id and v.Commande_Id=?";
			reqInfosVersionDocument += " join "+ this.base +".COMMANDE_FOURNISSEUR cf on v.Commande_Id=cf.Commande_Id";
			reqInfosVersionDocument += " order by vd.Version_Id desc limit 1";
			reqNouvelleVersion = "insert into "+ this.base +".VERSION_COMMANDE_FOURNISSEUR (Version_Id, Commande_Id) values (?,?)";
		} else if (this.typeDoc.equals("Facture_Fournisseur")) {
			reqInfosVersionDocument = "select vd.Num_Version, vd.Date_Edition, ff.Date_M from "+ this.base +".VERSION_DOCUMENT vd";
			reqInfosVersionDocument += " join "+ this.base +".VERSION_FACTURE_FOURNISSEUR v on vd.Version_Id=v.Version_Id and v.Facture_Id=?";
			reqInfosVersionDocument += " join "+ this.base +".FACTURE_FOURNISSEUR ff on v.Facture_Id=ff.Facture_Id";
			reqInfosVersionDocument += " order by vd.Version_Id desc limit 1";
			reqNouvelleVersion = "insert into "+ this.base +".VERSION_FACTURE_FOURNISSEUR (Version_Id, Facture_Id) values (?,?)";
		} else if (this.typeDoc.equals("Avoir_Fournisseur")) {
			reqInfosVersionDocument = "select vd.Num_Version, vd.Date_Edition, af.Date_M from "+ this.base +".VERSION_DOCUMENT vd";
			reqInfosVersionDocument += " join "+ this.base +".VERSION_AVOIR_FOURNISSEUR v on vd.Version_Id=v.Version_Id and v.Avoir_Id=?";
			reqInfosVersionDocument += " join "+ this.base +".AVOIR_FOURNISSEUR af on v.Avoir_Id=af.Avoir_Id";
			reqInfosVersionDocument += " order by vd.Version_Id desc limit 1";
			reqNouvelleVersion = "insert into "+ this.base +".VERSION_AVOIR_FOURNISSEUR (Version_Id, Avoir_Id) values (?,?)";
		} else if (this.typeDoc.equals("Bon_Livraison")) {
			reqInfosVersionDocument = "select vd.Num_Version, vd.Date_Edition, bl.Date_M from "+ this.base +".VERSION_DOCUMENT vd";
			reqInfosVersionDocument += " join "+ this.base +".VERSION_BON_LIVRAISON v on vd.Version_Id=v.Version_Id and v.Bon_Id=?";
			reqInfosVersionDocument += " join "+ this.base +".BON_LIVRAISON bl on v.Bon_Id=bl.Bon_Id";
			reqInfosVersionDocument += " order by vd.Version_Id desc limit 1";
			reqNouvelleVersion = "insert into "+ this.base +".VERSION_BON_LIVRAISON (Version_Id, Bon_Id) values (?,?)";
		} else if (this.typeDoc.equals("Bon_Retour_Client")) {
			reqInfosVersionDocument = "select vd.Num_Version, vd.Date_Edition, brc.Date_M from "+ this.base +".VERSION_DOCUMENT vd";
			reqInfosVersionDocument += " join "+ this.base +".VERSION_BON_RETOUR_CLIENT v on vd.Version_Id=v.Version_Id and v.Bon_Id=?";
			reqInfosVersionDocument += " join "+ this.base +".BON_RETOUR_CLIENT brc on v.Bon_Id=brc.Bon_Id";
			reqInfosVersionDocument += " order by vd.Version_Id desc limit 1";
			reqNouvelleVersion = "insert into "+ this.base +".VERSION_BON_RETOUR_CLIENT (Version_Id, Bon_Id) values (?,?)";
		} else if (this.typeDoc.equals("Bon_Reception")) {
			reqInfosVersionDocument = "select vd.Num_Version, vd.Date_Edition, br.Date_M from "+ this.base +".VERSION_DOCUMENT vd";
			reqInfosVersionDocument += " join "+ this.base +".VERSION_BON_RECEPTION v on vd.Version_Id=v.Version_Id and v.Bon_Id=?";
			reqInfosVersionDocument += " join "+ this.base +".BON_RECEPTION br on v.Bon_Id=br.BR_Id";
			reqInfosVersionDocument += " order by vd.Version_Id desc limit 1";
			reqNouvelleVersion = "insert into "+ this.base +".VERSION_BON_RECEPTION (Version_Id, Bon_Id) values (?,?)";
		}
		
		PreparedStatement psInfosVersionDocument = this.con.prepareStatement(reqInfosVersionDocument);
		psInfosVersionDocument.setInt(1, this.documentId);
		ResultSet rset = psInfosVersionDocument.executeQuery();
		if (rset.next()) {
			numVersion = rset.getInt("Num_Version");
			if (rset.getLong("Date_M")>rset.getLong("Date_Edition")) {
				numVersion++;
			}
		}
		rset.close();
		psInfosVersionDocument.close();
		
		int versionId = this.insererVersionDocument(numVersion);
		
		PreparedStatement psNouvelleVersion = this.con.prepareStatement(reqNouvelleVersion);
		psNouvelleVersion.setInt(1, versionId);
		psNouvelleVersion.setInt(2, this.documentId);
		psNouvelleVersion.executeUpdate();
		psNouvelleVersion.close();
	}
	
	
	public int insererVersionDocument(int numVersion) throws SQLException {
		// Insertion d'une nouvelle version du document
		String reqNouvelleVersionDocument = "insert into "+ this.base +".VERSION_DOCUMENT (Num_Version, Date_Edition, Util_E, Email) values (?, ?, ?, ?)";
		PreparedStatement psNouvelleVersionDocument = this.con.prepareStatement(reqNouvelleVersionDocument);
		psNouvelleVersionDocument.setInt(1, numVersion);
		psNouvelleVersionDocument.setLong(2, this.dateEdition);
		psNouvelleVersionDocument.setInt(3, this.utilE);
		psNouvelleVersionDocument.setString(4, this.email);
		psNouvelleVersionDocument.executeUpdate();
		psNouvelleVersionDocument.close();
		
		// Rcupration de l'identifiant de la version insre
		String reqVersionId = "select max(Version_Id) as Version_Id from "+ this.base +".VERSION_DOCUMENT";
		PreparedStatement psVersionId = this.con.prepareStatement(reqVersionId);
		ResultSet rset = psVersionId.executeQuery();
		rset.next();
		int versionId = rset.getInt("Version_Id");
		rset.close();
		psVersionId.close();
		return versionId;
	}
	
	
	protected void finalize() throws SQLException {

		this.s.closeConnection(this.con, null);
	}
	

}

