/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration de la liste des commandes
 */

package org.opensi.facturation.actions.affaires;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;


public class GenListeCommandes extends Action {

  public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception {

		String fichierCsv = r.getParameter("FichierCsv");
		String absdir = s.getAppConfiguration().get("opensi.absdir");

		String numCommande = r.getParameter("Num_Commande");
		String loginWeb = r.getParameter("Login_Web");
		String nomClient = r.getParameter("Nom_Client");
		String refArticle = r.getParameter("Ref_Article");
		String numFacture = r.getParameter("Num_Facture");
		String numAcompte = r.getParameter("Num_Acompte");
		String numBL = r.getParameter("Num_BL");
		String numRetour = r.getParameter("Num_Retour");
		String etatCommande = r.getParameter("Etat_Commande");
		String etatLogistique = r.getParameter("Etat_Logistique");
		String commandeBloquee = r.getParameter("Commande_Bloquee");
		String dateCommandeDebut = r.getParameter("Date_Commande_Debut");
		String dateCommandeFin = r.getParameter("Date_Commande_Fin");
		String dateDelaiDebut = r.getParameter("Date_Delai_Debut");
		String dateDelaiFin = r.getParameter("Date_Delai_Fin");
		String numClient = r.getParameter("Num_Client");
		String montantTTC = r.getParameter("Montant_TTC");
		String etatPaiement = r.getParameter("Etat_Paiement");
		String modeReglement = r.getParameter("Mode_Reglement");
		String provenance = r.getParameter("Provenance");
		String modeExpedition = r.getParameter("Mode_Expedition");
		String secteurActivite = r.getParameter("Secteur_Activite");
		boolean calculStock = (r.getParameter("Calcul_Stock").equals("1"));
		
		DataListeCommandes dlc = new DataListeCommandes(s, numCommande, loginWeb, nomClient, refArticle, numFacture, numAcompte, numBL, numRetour, etatCommande, etatLogistique, commandeBloquee, dateCommandeDebut, dateCommandeFin, dateDelaiDebut, dateDelaiFin, numClient, montantTTC, etatPaiement, modeReglement, provenance, modeExpedition, secteurActivite, calculStock);
		
		// Cration d'un CSV
		String buffer = absdir +"/iobuffer/";
		new CsvListeCommandes(buffer, fichierCsv, dlc);

		return true;

	} // fin service

} // fin GenListeCommandes
