/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/


package org.opensi.facturation.actions.clients;

import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.util.tools.Arrondi;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfWriter;


public class GenPdfMajTarifsSpe extends Action {

	// ATTRIBUTS DE CLASSE
	private static final Font fontGen = new Font(Font.HELVETICA , 10, Font.NORMAL);// font pour lignes d'entete
	private static final Font fontLine = new Font(Font.HELVETICA , 8, Font.NORMAL);
	private DecimalFormat numFormat = new DecimalFormat("0.00");

	Connection con;

	private int widths[] = {10,15,10,5,10,10,10,10,10,10};

	class MyPageEvent implements PdfPageEvent {

		private String dateCourante;

		private String dossierId;

		private String clientId;
		private String clientRaisonSociale;
		private String clientTel;

		private String raisonSociale;
		private String adresse1;
		private String adresse2;
		private String adresse3;
		private String codePostal;
		private String ville;



		public MyPageEvent(String dossierId, String clientId, String base) throws SQLException {

			this.dossierId = dossierId;
			this.clientId = clientId;

			SimpleDateFormat formatDate = new SimpleDateFormat("dd/MM/yyyy");
			this.dateCourante = formatDate.format(new Date(System.currentTimeMillis()));

			Statement stt = con.createStatement();

			ResultSet rset = stt.executeQuery("select * from "+ base +".SOCIETE");

			rset.next();
			this.raisonSociale = rset.getString("Denomination");
			this.adresse1 = rset.getString("Adresse_1");
			this.adresse2 = rset.getString("Adresse_2");
			this.adresse3 = rset.getString("Adresse_3");
			this.codePostal = rset.getString("Code_Postal");
			this.ville = rset.getString("Ville");
			rset.close();

			ResultSet rsRIC = stt.executeQuery("select Denomination, Tel_1 from "+ base +".FICHE_CLIENT where Client_Id='"+ clientId +"'");

			if (rsRIC.next() ){
				this.clientRaisonSociale = rsRIC.getString("Denomination");
				this.clientTel = rsRIC.getString("Tel_1");
			}
			stt.close();
		}


    		public void onStartPage(PdfWriter writer, Document document) {
    			try {
				PdfPTable bandeau = new PdfPTable(1);

				bandeau.setWidthPercentage(100);

				PdfPTable entete = new PdfPTable(3);

				PdfPCell cellEntete = new PdfPCell(entete.getDefaultCell());

				//Ligne 1
				cellEntete.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
				cellEntete.setBorderWidth(0);
				cellEntete.setMinimumHeight(10);
				cellEntete.setPhrase(new Phrase("Dossier : " + this.dossierId, fontGen));
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(raisonSociale, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);

				//Ligne 2
				cellEntete.setColspan(1);
				cellEntete.setPhrase(new Phrase("Date : " + this.dateCourante, fontGen));
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(adresse1, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);

				//Ligne 3
				cellEntete.setColspan(1);
				cellEntete.setPhrase(new Phrase("", fontGen));
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(adresse2, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);
				
				if (!adresse3.equals("")) {
					cellEntete.setColspan(1);
					cellEntete.setPhrase(new Phrase("", fontGen));
					cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
					entete.addCell(cellEntete);

					cellEntete.setPhrase(new Phrase(adresse3, fontGen));
					cellEntete.setColspan(2);
					cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
					entete.addCell(cellEntete);
				}

				//Ligne 4
				cellEntete.setColspan(1);
				cellEntete.setPhrase(new Phrase("Page : "+ document.getPageNumber(), fontGen));
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(codePostal + " " + ville, fontGen));
				cellEntete.setColspan(2);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);

				//Ligne 5
				cellEntete.setPhrase(new Phrase("Tarifs Spcifiques", new Font(Font.HELVETICA, 16, Font.BOLD)));
				cellEntete.setColspan(3);
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				entete.addCell(cellEntete);

				//Ligne 6
				cellEntete.setPhrase(new Phrase("Client N\u00B0 "+clientId, fontGen));
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
				cellEntete.setColspan(1);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase(clientRaisonSociale, fontGen));
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				entete.addCell(cellEntete);

				cellEntete.setPhrase(new Phrase("Tel : "+clientTel, fontGen));
				cellEntete.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
				entete.addCell(cellEntete);


				PdfPCell cellBandeau = new PdfPCell(entete);
				cellBandeau.setPadding(10);

				bandeau.addCell(cellBandeau);

				document.add(bandeau);
				bandeauTarif(writer,document);

				// fin Entete Gnrale

			}
			catch( DocumentException de ) {
		  	de.printStackTrace();
			}
		}


		public void bandeauTarif(PdfWriter writer, Document document) {
			try{

				// Titres de colonnes
				PdfPTable titresColonnes = new PdfPTable(10);
				titresColonnes.setWidthPercentage(100);
				titresColonnes.setWidths(widths);
				PdfPCell cellTitre = new PdfPCell(titresColonnes.getDefaultCell());

				cellTitre.setFixedHeight(6);
				cellTitre.setBorder(PdfPCell.NO_BORDER);
				cellTitre.setPhrase(new Phrase(""));
				cellTitre.setColspan(10);
				titresColonnes.addCell(cellTitre);

				//Init graph Ligne
				cellTitre.setFixedHeight(20);
				cellTitre.setBackgroundColor(Color.LIGHT_GRAY);
				cellTitre.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);

				//Ligne 2
				cellTitre.setBorder(PdfPCell.BOX - PdfPCell.RIGHT);
				cellTitre.setHorizontalAlignment(PdfPCell.ALIGN_CENTER);
				cellTitre.setColspan(1);
				cellTitre.setPhrase(new Phrase("Refrence", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setPhrase(new Phrase("Dsignation", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setPhrase(new Phrase("Prix d'Achat HT", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setPhrase(new Phrase("TVA", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setPhrase(new Phrase("Prix de Vente HT", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setPhrase(new Phrase("Prix de Vente TTC", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setPhrase(new Phrase("Coeff. (%)", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setPhrase(new Phrase("Prix Sp. HT", fontLine));
				titresColonnes.addCell(cellTitre);
				
				cellTitre.setPhrase(new Phrase("Prix Sp. TTC", fontLine));
				titresColonnes.addCell(cellTitre);

				cellTitre.setPhrase(new Phrase("Marge Sp. (%)", fontLine));
				cellTitre.setBorder(PdfPCell.BOX);
				titresColonnes.addCell(cellTitre);


				document.add(titresColonnes);

				// fin Titres de colonnes

			}
			catch( DocumentException de ) {
       	de.printStackTrace();
			}
		}

		public void onEndPage(PdfWriter writer, Document document) {}
		public void onOpenDocument(PdfWriter writer, Document document) {}
		public void onCloseDocument(PdfWriter writer, Document document) {}
		public void onParagraph(PdfWriter writer, Document document, float paragraphPosition) {}
		public void onParagraphEnd(PdfWriter writer,Document document,float paragraphPosition) {}
		public void onChapter(PdfWriter writer,Document document,float paragraphPosition, Paragraph title) {}
		public void onChapterEnd(PdfWriter writer,Document document,float paragraphPosition) {}
		public void onSection(PdfWriter writer,Document document,float paragraphPosition, int depth, Paragraph title) {}
		public void onSectionEnd(PdfWriter writer,Document document,float paragraphPosition) {}
		public void onGenericTag(PdfWriter writer, Document document, Rectangle rect, String text) {}

	}//fin classe MyPageEvent





	public boolean serverSide() { return true; }

	public boolean service(Session s, ServletRequest r, Object info) throws Exception {
		try {
			con = s.getConnection(null);

			DecimalFormatSymbols dfs = new DecimalFormatSymbols();
			dfs.setDecimalSeparator('.');
			dfs.setGroupingSeparator(' ');

			//Variable de format
			Arrondi arrondi_2 = new Arrondi(2);
			Arrondi arrondi_4 = new Arrondi(4);

			numFormat.setDecimalFormatSymbols(dfs);
			numFormat.setNegativeSuffix("");
			numFormat.setNegativePrefix("-");
			numFormat.setPositiveSuffix(" ");
			numFormat.setGroupingUsed(true);
			numFormat.setGroupingSize(3);

			//Recupration des paramtres
			String dossierId = s.getCookie().get("Dossier_Id");
			String clientId = r.getParameter("Client_Id");
			String fichierPdf = r.getParameter("FichierPDF");
			String base = s.getCookie().get("BaseDossier");
			//Fin de recupration

			PdfPTable listing = new PdfPTable(10);
			listing.setWidthPercentage(100);
			listing.setWidths(widths);

			Document document = new Document(PageSize.A4, 25, 25, 25, 25);

			String chemin = s.getAppConfiguration().get("opensi.absdir") + "/pdf/";			

			PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(chemin + fichierPdf));

			MyPageEvent event = new MyPageEvent(dossierId,clientId,base);

			writer.setPageEvent(event);

		
			//Requte qui rcupre le Code_Tarif du client
			String requeteCodeTarif = "select Code_Tarif from "+ base +".FICHE_CLIENT where Client_Id='"+ clientId +"'";
			Statement sRCT = con.createStatement();
			ResultSet rsRCT = sRCT.executeQuery(requeteCodeTarif);
			rsRCT.next();
			int codeTarif = rsRCT.getInt("Code_Tarif");
			rsRCT.close();


			//Reqete qui rcupre tout les articles possdant un tarif spcifique pour un client
			String requeteArticleClient = "select ca.Article_Id, ca.Prix, ca.Prix_TTC, ca.Coeff as CoeffSpe, ca.Marge as MargeSpe, a.Designation, a.Tarif_"+ codeTarif +" as Tarif_HT, "
																	+ "a.Tarif_"+ codeTarif +"_TTC as Tarif_TTC, a.Coeff_"+codeTarif+" as Coeff, a.Prix_Achat, t.Taux_TVA "
																	+ "from "+ base +".CLIENT_ARTICLE ca, "+ base +".FICHE_ARTICLE a, "+ base +".TAUX_TVA t "
																	+ "where ca.Client_Id='"+ clientId +"' and a.Article_Id=ca.Article_Id and t.Code_TVA=a.Code_TVA order by a.Article_Id";
			
			
			Statement sRAC = con.createStatement();
			ResultSet rsRAC = sRAC.executeQuery(requeteArticleClient);
			while ( rsRAC.next() ){
				String articleId = rsRAC.getString("Article_Id");
				double prixSpeHT = rsRAC.getDouble("Prix");
				double prixSpeTTC = rsRAC.getDouble("Prix_TTC");
				double coeffSpe = rsRAC.getDouble("CoeffSpe");
				double margeSpe = rsRAC.getDouble("MargeSpe");
				double tauxTVA = rsRAC.getDouble("Taux_TVA");
				String designation = rsRAC.getString("Designation");
				double prixHT = rsRAC.getDouble("Tarif_HT");
				double prixAchat = rsRAC.getDouble("Prix_Achat");
				double prixTTC = rsRAC.getDouble("Tarif_TTC");
				
				coeffSpe = (coeffSpe>=1?(coeffSpe - 1) * 100:(1-coeffSpe)*(-100));

				prixTTC = arrondi_4.round(prixTTC);
				prixSpeTTC = arrondi_4.round(prixSpeTTC);
				coeffSpe = arrondi_2.round(coeffSpe);

				putLigne(listing,articleId,designation,prixAchat,tauxTVA,prixHT,prixTTC,coeffSpe,prixSpeHT,prixSpeTTC,margeSpe);
			}



			if (!document.isOpen()) {
				document.open();
			}

			document.add(listing);
			s.closeConnection(con, null);

			if (document.isOpen()) {
			    	document.close();
			}

			try {
				File filePdf = new File(chemin, fichierPdf);
				filePdf.deleteOnExit();
			}
			catch(SecurityException se) {
				s.trace("Impossible d'enregistrer le fichier \u00E0 supprimer");
				se.printStackTrace();
			}

    		} catch (Exception e) {
      			e.printStackTrace();
    		}
		return true;


	} // fin service

	/** Ajoute une ligne d'operation au listing */
	private void putLigne(PdfPTable listing,
					String articleId,
					String designation,
					double prixAchat,
					double tauxTVA,
					double prixHT,
					double prixTTC,
					double coeffSpe,
					double prixSpeHT,
					double prixSpeTTC,
					double margeSpe){

		PdfPCell cellListing = new PdfPCell(listing.getDefaultCell());


		cellListing.setVerticalAlignment(PdfPCell.ALIGN_MIDDLE);
		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_LEFT);
		cellListing.setPaddingLeft(5);
		cellListing.setPhrase(new Phrase(articleId, fontLine));
		cellListing.setColspan(1);
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase(designation, fontLine));
		listing.addCell(cellListing);

		cellListing.setHorizontalAlignment(PdfPCell.ALIGN_RIGHT);
		cellListing.setPhrase(new Phrase(prixAchat==0.00?"":numFormat.format(prixAchat), fontLine));
		cellListing.setPaddingLeft(0);
		cellListing.setPaddingRight(5);
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase(tauxTVA==0.00?"":numFormat.format(tauxTVA), fontLine));
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase(prixHT==0.00?"":numFormat.format(prixHT), fontLine));
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase(prixTTC==0.00?"":numFormat.format(prixTTC), fontLine));
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase(coeffSpe==0.00?"":numFormat.format(coeffSpe), fontLine));
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase(prixSpeHT==0.00?"":numFormat.format(prixSpeHT), fontLine));
		listing.addCell(cellListing);
		
		cellListing.setPhrase(new Phrase(prixSpeTTC==0.00?"":numFormat.format(prixSpeTTC), fontLine));
		listing.addCell(cellListing);

		cellListing.setPhrase(new Phrase(margeSpe==0.00?"":numFormat.format(margeSpe), fontLine));
		listing.addCell(cellListing);
	}
}
