/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration de la liste des commandes
 */

package org.opensi.facturation.actions.commandes;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;


public class GenListeCommandesFournisseurs extends Action {

  public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception {

		String fichierCsv = r.getParameter("FichierCsv");
		String absdir = s.getAppConfiguration().get("opensi.absdir");

		String numCommande = r.getParameter("Num_Commande");
		String refArticle = r.getParameter("Ref_Article");
		String numFournisseur = r.getParameter("Num_Fournisseur");
		String nomFournisseur = r.getParameter("Nom_Fournisseur");
		String etatCommande = r.getParameter("Etat_Commande");
		String numBR = r.getParameter("Num_BR");
		String intitule = r.getParameter("Intitule");
		String dateCommandeDebut = r.getParameter("Date_Commande_Debut");
		String dateCommandeFin = r.getParameter("Date_Commande_Fin");
		
		DataListeCommandesFournisseurs dlc = new DataListeCommandesFournisseurs(s, numCommande, refArticle, numFournisseur, nomFournisseur, etatCommande, numBR, intitule, dateCommandeDebut, dateCommandeFin);
		
		// Cration d'un CSV
		String buffer = absdir +"/iobuffer/";
		new CsvListeCommandesFournisseurs(buffer, fichierCsv, dlc);

		return true;

	} // fin service

} // fin GenListeCommandesFournisseurs
