/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Informations utiles pour l'edition de l'avoir
 */

package org.opensi.facturation.actions.documents.modeles;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;

import org.experlog.openeas.api.Session;
import org.opensi.facturation.DocumentUtils;
import org.opensi.util.calcul.Calcul;
import org.opensi.util.calcul.CalculVentilTVA;
import org.opensi.util.tools.StringUtils;


public class DataAvoirFournisseur {

	private DecimalFormatSymbols dfs2 = new DecimalFormatSymbols();
	private DecimalFormat numFormat2 = new DecimalFormat("0.00");
	private DecimalFormat numFormatQte = new DecimalFormat("0.##");

	// liste des articles de l'avoir

	protected ArrayList<LigneAvoirFournisseur> lignes = new ArrayList<LigneAvoirFournisseur>(10);

	// infos socit facturante

	protected String raisonSociale;
	protected String adresse1;
	protected String adresse2;
	protected String adresse3;
	protected String codePostal;
	protected String ville;
	protected String tel;
	protected String fax;
	protected String email;
	protected String web;

	// infos socit facture

	protected String fournisseurId;
	protected String societeFact;
	protected String adresseFact1;
	protected String adresseFact2;
	protected String adresseFact3;
	protected String codePostalFact;
	protected String villeFact;
	protected String paysFact;

	// Infos avoir

	protected double capital;
	protected String typeSociete;
	protected String tvaIntra;
	protected String rcs;
	protected String siren;
	protected String numAvoir;
	protected long dateAvoir;
	protected String typeAchat;
	protected String interlocuteur;
	protected String numTvaFournisseur = "";

	protected String comFin = "";
	protected String mentions = "";
	
	protected double tRemise;
	protected double tEscompte = 0;
	protected double mRemise = 0;
	protected double mEscompte = 0;
	protected double fraisPort;
	protected double tauxTvaPort;
	protected double montantBase = 0;
	protected double totalBase = 0;
	protected double totalTVA = 0;
	protected double netAPayer = 0;
	protected double montantTTC = 0;

	protected boolean logoAdr;
	protected String urlLogo = "";
	protected int nbex;

	protected String refCommande;
	protected String refAffaire;
	protected String refBL;

	protected boolean rist = false;
	protected boolean coul = false;
	protected boolean tail = false;
	protected boolean unite = false;
	protected boolean nbPieces = false;
	protected boolean numLot = false;
	protected boolean datePeremption = false;
	
	private Calcul calc;
	protected HashMap<Integer, CalculVentilTVA> ventilTVA;


	public DataAvoirFournisseur(Session s, String Avoir_Id) {

		try {

			dfs2.setDecimalSeparator('.');

			numFormat2.setDecimalFormatSymbols(dfs2);
			numFormatQte.setDecimalFormatSymbols(dfs2);

			Connection con = s.getConnection(null);
			Statement stt = con.createStatement();
			Statement stt2 = con.createStatement();
			Statement stt3 = con.createStatement();

			String base = s.getCookie().get("BaseDossier");
			String dossier = s.getCookie().get("Dossier_Id");
			
			this.urlLogo = s.getAppConfiguration().get("opensi.absdir") +"/logos/"+ dossier +".jpg";

			ResultSet rset;


			// Elments de l'avoir

			String reqAvoir = "select a.*, c.Civ_Courte, p.Nom_FR as Pays from "+ base +".AVOIR_FOURNISSEUR a, CIVILITE c, PAYS p";
			reqAvoir += " where c.Civ_Id=a.Civ_Inter and a.Code_Pays=p.Code_Pays and a.Avoir_Id="+ Avoir_Id;
			
			rset = stt.executeQuery(reqAvoir);

			rset.next();

			this.numAvoir = rset.getString("Numero");
			this.dateAvoir = rset.getLong("Date_Avoir");
			this.fournisseurId = rset.getString("Fournisseur_Id");
			this.tEscompte = rset.getDouble("Escompte");
			this.tRemise = rset.getDouble("Remise");
			this.fraisPort = rset.getDouble("Frais_Port");
			this.tauxTvaPort = rset.getDouble("Taux_TVA_Port");

			if (!rset.getString("Commentaires_Fin").equals("")) {
				this.comFin = StringUtils.removeHtmlTags("\n"+ rset.getString("Commentaires_Fin"));
			}
			this.mentions = "\n" + rset.getString("Mentions");

			this.societeFact = rset.getString("Denomination");
			this.adresseFact1 = rset.getString("Adresse_1");
			this.adresseFact2 = rset.getString("Adresse_2");
			this.adresseFact3 = rset.getString("Adresse_3");
			this.codePostalFact = rset.getString("Code_Postal");
			this.villeFact = rset.getString("Ville");
			this.paysFact = rset.getString("Pays");
			this.typeAchat = rset.getString("type_Achat");

			if (rset.getString("Nom_Inter").equals("")) {
				this.interlocuteur = "";
			}
			else {
				this.interlocuteur = rset.getString("Civ_Courte") +" "+ rset.getString("Nom_Inter").toUpperCase() + " " + rset.getString("Prenom_Inter");
			}

			rset.close();


			// coordonnes de l'entreprise facturante

			String reqFacturante = "select s.Ville_RCS, s.Num_TVA_Intra, ts.Libelle as Type_Societe, s.Montant_Capital, s.Num_SIRET, s.Denomination,";
			reqFacturante += " s.Adresse_1, s.Adresse_2, s.Adresse_3, s.Code_Postal, s.Ville, s.Telephone, s.Fax, s.Email, s.Site_Web";
			reqFacturante += " from "+ base +".SOCIETE s join "+ base +".TYPE_SOCIETE ts on s.Type_Societe=ts.Type_Societe_Id";

			rset = stt.executeQuery(reqFacturante);

			rset.next();

			this.raisonSociale = rset.getString("Denomination");
			this.adresse1 = rset.getString("Adresse_1");
			this.adresse2 = rset.getString("Adresse_2");
			this.adresse3 = rset.getString("Adresse_3");
			this.codePostal = rset.getString("Code_Postal");
			this.ville = rset.getString("Ville");
			this.tel = rset.getString("Telephone");
			this.fax = rset.getString("Fax");
			this.email = rset.getString("Email");
			this.web = rset.getString("Site_Web");
			this.siren = DocumentUtils.formatSiren(rset.getString("Num_SIRET"));
			this.typeSociete = rset.getString("Type_Societe");
			this.capital = rset.getDouble("Montant_Capital");
			this.tvaIntra = rset.getString("Num_TVA_Intra");
			this.rcs = rset.getString("Ville_RCS");

			rset.close();

			// rfrences affaire, BL et commandes

			this.refAffaire = "";
			this.refCommande = "";
			this.refBL = "";

			// nombre d'exemplaires  sortir

		      if (fournisseurId.equals("")) {
		        this.comFin += "\n\n";
		        this.nbex = 1;
		      } else {
		
		        String reqEx = "select Nb_Ex, Num_TVA_Intra from "+ base +".FICHE_FOURNISSEUR where Fournisseur_Id='"+ fournisseurId +"'";
					  rset = stt.executeQuery(reqEx);
		
					  if (rset.next()) {
					    this.nbex = rset.getInt("Nb_Ex") + 1;
							this.numTvaFournisseur = rset.getString("Num_TVA_Intra");
		        }
						else {
		          this.comFin += "\n\n";
		          this.nbex = 1;
							this.numTvaFournisseur = "";
		        }
					  rset.close();
		      }

			// commentaires sur avoir (dossier)

      		String reqCom = "select Logo_Adr from "+ base +".PARAM_DOSSIER";

			rset = stt.executeQuery(reqCom);

			rset.next();

			logoAdr = rset.getInt("Logo_Adr")==1;

			rset.close();

			// selection des articles appartenant  l'avoir

			String reqArticles = "select * from "+ base +".LIGNE_AVOIR_FOURNISSEUR where Avoir_Id="+ Avoir_Id +" order by Rank";
			rset = stt.executeQuery(reqArticles);

			String reqInfosSup = "select coalesce(ca.Libelle,'') as Couleur, coalesce(ta.Libelle,'') as Taille from "+ base +".FICHE_ARTICLE fa";
			reqInfosSup += " left join "+ base +".COULEUR_ARTICLE ca on fa.Couleur_Id=ca.Couleur_Id left join "+ base +".TAILLE_ARTICLE ta on fa.Taille_Id=ta.Taille_Id";
			reqInfosSup += " where fa.Article_Id=?";
			PreparedStatement psInfosSup = con.prepareStatement(reqInfosSup);

			while (rset.next()) {
				
				String commentaireAvant = rset.getString("Commentaire_Avant");				
				
				if (commentaireAvant.length()>0) {
				
					String tabCom[] = commentaireAvant.split("\n");
					
					for (int i=0; i<tabCom.length; i++) {
					
						LigneAvoirFournisseur la = new LigneAvoirFournisseur();
						la.setType('C');
						la.setDesignation(tabCom[i]);
						la.setSousTotal(montantBase);
						lignes.add(la);
					}
				}
				
				LigneAvoirFournisseur la = new LigneAvoirFournisseur();

				String libelle = rset.getString("Libelle");

				if (libelle.length()>0) {
					libelle = "\n"+libelle;
				}

				la.setPrice(rset.getDouble("Prix"));
				la.setReference(rset.getString("Reference"));
				la.setRef_Fournisseur(rset.getString("Ref_Fournisseur"));
				la.setDesignation(rset.getString("Designation")+libelle);
				la.setQte(rset.getDouble("Quantite"));
				la.setRistourne(rset.getDouble("Ristourne"));
				la.setTypeLigne(rset.getString("Type_Ligne"));
				la.setTva(rset.getDouble("Taux_TVA"));
				la.setMontant(la.price*la.qte*(1-la.ristourne/100));
				la.setDetail_1("");
				la.setDetail_2("");
				la.setRefBL("");
				la.setUnite(rset.getString("Unite"));
				la.setNumLot(rset.getString("Num_Lot"));
				la.setNbPieces(rset.getInt("Nb_Pieces"));
				la.setDatePeremption(rset.getLong("Date_Peremption"));
				la.setType('A');
				
				montantBase += la.montant;
				
				la.setSousTotal(montantBase);
				
				if (la.ristourne!=0) { rist = true; }
				if (!la.unite.equals("U")) unite = true;
				if (!la.num_lot.equals("")) numLot = true;
				if (la.nb_pieces != 0) nbPieces = true;
				if (la.date_peremption != 0) datePeremption = true;
				
				lignes.add(la);

				ResultSet rset2;
				
				String commentaireApres = rset.getString("Commentaire");				
				
				if (commentaireApres.length()>0) {
				
					String tabCom[] = commentaireApres.split("\n");
					
					for (int i=0; i<tabCom.length; i++) {
					
						LigneAvoirFournisseur lc = new LigneAvoirFournisseur();
						lc.setType('C');
						lc.setDesignation(tabCom[i]);
						lc.setSousTotal(montantBase);
						lignes.add(lc);
					}
				}

				if (rset.getString("Type_Ligne").equalsIgnoreCase("S")) {

					psInfosSup.setString(1, rset.getString("Reference"));
					ResultSet rsIS = psInfosSup.executeQuery();

					if (rsIS.next()) {

						la.setCouleur(rsIS.getString("Couleur"));
						la.setTaille(rsIS.getString("Taille"));

						if (rsIS.getString("Couleur").length()>0) {
							coul = true;
						}

						if (rsIS.getString("Taille").length()>0) {
							tail = true;
						}
					}


					String req2 = "select Descrip_1, Descrip_2, " +
                                "Imp_Desc1_Facture, Imp_Desc2_Facture, Imp_Nom_Facture " +
                                "from "+ base +".FICHE_ARTICLE " +
                                "where Article_Id='"+ rset.getString("Reference") +"'";
					rset2 = stt2.executeQuery(req2);
					rset2.next();

					if (rset2.getInt("Imp_Desc1_Facture")==1) {
						la.setDetail_1(StringUtils.removeHtmlTags(rset2.getString("Descrip_1")));
					}
					if (rset2.getInt("Imp_Desc2_Facture")==1) {
						la.setDetail_2(StringUtils.removeHtmlTags(rset2.getString("Descrip_2")));
					}

					// gestion de la nomenclature

					if (rset2.getInt("Imp_Nom_Facture")==1)	{

						String req3 = "select n.ArticleComp_Id, n.Quantite, f.Designation " +
                          "from "+ base +".FICHE_ARTICLE f," +
                          base +".COMPOSANT_ARTICLE n " +
                          "where f.Article_Id=n.ArticleComp_Id " +
                          "and n.Article_Id='"+ rset.getString("Reference") +"'";
						ResultSet rset3 = stt3.executeQuery(req3);

						while (rset3.next()) {
							LigneAvoirFournisseur ln = new LigneAvoirFournisseur();

							ln.setReference(rset3.getString("ArticleComp_Id"));
							ln.setDesignation(rset3.getString("Designation"));
							ln.setQte(rset3.getDouble("Quantite"));
							ln.setType('N');
							ln.setSousTotal(montantBase);

							lignes.add(ln);
						}

						rset3.close();
					}

					rset2.close();
				}
			}
			
			calc = new Calcul(s, Integer.parseInt(Avoir_Id), "Avoir_Fournisseur");
			ventilTVA = calc.getLignesTVA();

			mRemise = calc.getRemiseM();
			totalBase = calc.getTotalHT();
			
			totalTVA = calc.getTotalTVA();
			
			montantTTC = calc.getMontantTTC();
			mEscompte = calc.getEscompteM();
			netAPayer = calc.getMontantNet();

			rset.close();
			stt.close();
			stt2.close();
			stt3.close();
			s.closeConnection(con, null);

		} catch(Exception e) { e.printStackTrace();	}

	}

	public int getNbLignes() {
		return lignes.size();
	}

	public double calcSousTotal(int derniereLigne) {		
		if (derniereLigne<0) 
			return 0;
		return lignes.get(derniereLigne).sousTotal;		
	}	

} // fin DataAvoirFournisseur
