/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes ncessaires  l'dition d'un bon de livraison standard
 */

package org.opensi.facturation.actions.documents.modeles;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;

import org.experlog.openeas.api.Session;
import org.opensi.facturation.DocumentUtils;
import org.opensi.util.calcul.Calcul;
import org.opensi.util.calcul.CalculVentilTVA;
import org.opensi.util.tools.StringUtils;


public class DataBonLivraison {


	private DecimalFormatSymbols dfs2 = new DecimalFormatSymbols();
	
	private DecimalFormat numFormatQte = new DecimalFormat("0.##");



	// les lignes de la facture
	protected ArrayList<LigneBonLivraison> lignes = new ArrayList<LigneBonLivraison>(10);
	


	// coordonnes socit mettrice

	protected String raisonSociale;
	protected String adresse1;
	protected String adresse2;
	protected String adresse3;
	protected String codePostal;
	protected String ville;
	protected String tel;
	protected String fax;
	protected String email;
	protected String web;
	
	protected double capital;
	protected String typeSociete;
	protected String tvaIntra;
	protected String rcs;
	protected String siren;
	
	// coordonnes du destinataire
	
	protected String telClient;
	protected String clientId;
	protected String raisonSocialeDest;
	protected String adresse1Dest;
	protected String adresse2Dest;
	protected String adresse3Dest;
	protected String codePostalDest;
	protected String villeDest;
	protected String paysDest;
	private String codePaysLiv;
	
	// coordonnes du logisticien;
	protected String denominationLog;
	protected String adresse1Log;
	protected String adresse2Log;
	protected String adresse3Log;
	protected String codePostalLog;
	protected String villeLog;
	protected String paysLog;
	
	// infos facture
	
	protected String raisonSocialeFact;
	protected String numeroBon;
	protected String comFin = "";
	protected String mentions = "";
	protected String codeFournisseur;
	protected String numCommande;
	protected String refCommande;
	protected String refAffaire;
	protected String refFacture;
	
	protected long dateBon;
	
	// contact de livraison
	protected String interlocuteurLiv = "";
	protected String telInterLiv;
	protected String faxInterLiv;
	protected String emailInterLiv;
	
	protected double tRemise = 0;
	protected double mRemise = 0;
	protected double montantBase = 0;
	protected double totalBase = 0;
	protected double totalTVA = 0;
	protected double montantTTC = 0;
	
	protected boolean bonChiffreClient = false;
	protected boolean editionTTC = false;
	protected boolean coul = false;
	protected boolean tail = false;
	protected boolean unite = false;
	protected boolean nbPieces = false;
	protected boolean numLot = false;
	protected boolean datePeremption = false;
	protected boolean logoAdr;
	protected String urlLogo = "";
	protected String urlAnnule = "";
	
	protected int nbex;
	
	protected int commandeId;

	protected int nbColis;
	
	protected boolean annule;
	protected double poidsTotal = 0;	

	protected boolean poids = false;
	protected String modeExpedition;
	protected int affaireId = 0;
	protected int soldee = 0;

	private Calcul calc;

	protected HashMap<Integer, CalculVentilTVA> ventilTVA;
	

	public DataBonLivraison(Session s, String bonId) {	
		try {
		
			Connection con = s.getConnection(null);
			Statement stt = con.createStatement();
			
			String dossierId = s.getCookie().get("Dossier_Id");
			String base = s.getCookie().get("BaseDossier");
			
			this.urlLogo = s.getAppConfiguration().get("opensi.absdir") +"/logos/"+ dossierId +".jpg";
			this.urlAnnule = s.getAppConfiguration().get("opensi.absdir") +"/images/annule.jpg";
			
			ResultSet rset;
			
			dfs2.setDecimalSeparator('.');
			numFormatQte.setDecimalFormatSymbols(dfs2);
			
      
			// coordonnes de l'entreprise facturante
      
			String reqFacturante = "select s.Ville_RCS, s.Num_TVA_Intra, ts.Libelle as Type_Societe, s.Montant_Capital, s.Num_SIRET, s.Denomination, s.Adresse_1, s.Adresse_2, s.Adresse_3, s.Code_Postal, s.Ville, s.Telephone, s.Fax, s.Email, s.Site_Web";
			reqFacturante += " from "+ base +".SOCIETE s join "+ base +".TYPE_SOCIETE ts on s.Type_Societe=ts.Type_Societe_Id";
			rset = stt.executeQuery(reqFacturante);
			
			rset.next();
			
			this.raisonSociale = rset.getString("Denomination");
			this.adresse1 = rset.getString("Adresse_1");
			this.adresse2 = rset.getString("Adresse_2");
			this.adresse3 = rset.getString("Adresse_3");
			this.codePostal = rset.getString("Code_Postal");
			this.ville = rset.getString("Ville");
			this.tel = rset.getString("Telephone");
			this.fax = rset.getString("Fax");
			this.email = rset.getString("Email");
			this.web = rset.getString("Site_Web");
			
			this.siren = DocumentUtils.formatSiren(rset.getString("Num_SIRET"));
			this.typeSociete = rset.getString("Type_Societe");
			this.capital = rset.getDouble("Montant_Capital");
			this.tvaIntra = rset.getString("Num_TVA_Intra");
			this.rcs = rset.getString("Ville_RCS");		
			
			rset.close();
			
			// Elments du bon de livraison
			
			String reqBon = "select coalesce(cc.Client_Id,'') as Client_Id,cc.Ref_Commande,cc.Numero as Num_Commande,cc.Soldee,cc.Remise,cc.Denomination,cc.Affaire_Id,bl.*, p.Nom_FR, trim(concat(c.Civ_Courte,' ',bl.Nom_Inter_Liv,' ',bl.Prenom_Inter_Liv)) as interlocuteurLiv,";
			reqBon += " coalesce(ff.Denomination,'') as Denomination_Log, coalesce(ff.Adresse_1,'') as Adresse_1_Log, coalesce(ff.Adresse_2,'') as Adresse_2_Log, coalesce(ff.Adresse_3,'') as Adresse_3_Log, coalesce(ff.Code_Postal,'') as Code_Postal_Log, coalesce(ff.Ville,'') as Ville_Log, coalesce(pl.Nom_FR,'') as Pays_Log";
			reqBon += " from "+ base +".BON_LIVRAISON bl join "+ base +".COMMANDE_CLIENT cc on cc.Commande_Id=bl.Commande_Id";
			reqBon += " join PAYS p on bl.Code_Pays_Liv=p.Code_Pays join CIVILITE c on c.Civ_Id=bl.Civ_Inter_Liv";
			reqBon += " left join "+ base +".FICHE_FOURNISSEUR ff on ff.Fournisseur_Id=bl.Fournisseur_Id";
			reqBon += " left join PAYS pl on ff.Code_Pays=pl.Code_Pays";
			reqBon += " where bl.Bon_Id="+ bonId;

			rset = stt.executeQuery(reqBon);

			rset.next();
			
			this.raisonSocialeFact = rset.getString("Denomination");
			this.numCommande = rset.getString("Num_Commande");
			this.refCommande = rset.getString("Ref_Commande");
			this.soldee = rset.getInt("Soldee");
			this.tRemise = rset.getDouble("Remise");
			this.clientId = rset.getString("Client_Id");

			this.numeroBon = rset.getString("Num_Entier");
			this.dateBon = rset.getLong("Date_Liv");
			this.nbColis = rset.getInt("Nb_Colis");
			this.annule = rset.getString("Etat").equals("A");
			this.affaireId = rset.getInt("Affaire_Id");
			this.commandeId = rset.getInt("Commande_Id");
			this.interlocuteurLiv = rset.getString("interlocuteurLiv");
			this.telInterLiv = rset.getString("Tel_Inter_Liv");
			this.faxInterLiv = rset.getString("Fax_Inter_Liv");
			this.emailInterLiv = rset.getString("Email_Inter_Liv");
			
			this.raisonSocialeDest = rset.getString("Denomination_Liv");
			this.adresse1Dest = rset.getString("Adresse_1_Liv");
			this.adresse2Dest = rset.getString("Adresse_2_Liv");
			this.adresse3Dest = rset.getString("Adresse_3_Liv");
			this.codePostalDest = rset.getString("Code_Postal_Liv");
			this.villeDest = rset.getString("Ville_Liv");
			this.paysDest = rset.getString("Nom_FR");
			this.codePaysLiv = rset.getString("Code_Pays_Liv");
			
			this.denominationLog = rset.getString("Denomination_Log");
			this.adresse1Log = rset.getString("Adresse_1_Log");
			this.adresse2Log = rset.getString("Adresse_2_Log");
			this.adresse3Log = rset.getString("Adresse_3_Log");
			this.codePostalLog = rset.getString("Code_Postal_Log");
			this.villeLog = rset.getString("Ville_Log");
			this.paysLog = rset.getString("Pays_Log");
			
			if (rset.getString("Commentaires_Fin").length()>0) {
			  this.comFin = "\n"+ rset.getString("Commentaires_Fin");
			}
			this.mentions = "\n" + rset.getString("Mentions");

			rset.close();
			
			// modification des coordonnes de l'entreprise facturante si code_pays reli a un site_id dans PARAM_PAYS_WEB
			if (!this.codePaysLiv.equals("")) {
				String reqParamPaysWeb = "select s.* from "+ base +".SITE s,"+ base +".PARAM_PAYS_WEB ppw where ppw.Site_Id=s.Site_Id and ppw.Code_Pays='"+ this.codePaysLiv +"'";
				
				rset = stt.executeQuery(reqParamPaysWeb);
				
				if (rset.next()) {
				
					this.raisonSociale = rset.getString("Denomination");
					this.adresse1 = rset.getString("Adresse_1");
					this.adresse2 = rset.getString("Adresse_2");
					this.adresse3 = rset.getString("Adresse_3");
					this.codePostal = rset.getString("Code_Postal");
					this.ville = rset.getString("Ville");
					this.tel = rset.getString("Tel");
					this.fax = rset.getString("Fax");
					this.email = rset.getString("Email");
				
				}
				rset.close();
				
				
			}
			
			// Numro de facture si elle existe
			
			String reqNumFacture = "select f.Num_Entier from " + base + ".BON_LIVRAISON bl, "+ base +".BON_LIVRAISON_FACTURE blf, " + base + ".FACTURE f";
			reqNumFacture += " where bl.Bon_Id=blf.Bon_Id and blf.Facture_Id=f.Facture_Id and f.Numero>0";
			reqNumFacture += " and bl.Bon_Id = " + bonId;
			rset = stt.executeQuery(reqNumFacture);

			if (rset.next()) {
				this.refFacture = rset.getString("Num_Entier");
				while (rset.next()) {
					this.refFacture += " - "+ rset.getString("Num_Entier");
				}
			}
			
			rset.close();
			

			String reqAffaire = "select Client_Id, Num_Entier from "+ base +".AFFAIRE where Affaire_Id="+ affaireId;
	
			rset = stt.executeQuery(reqAffaire);
	
			rset.next();
	
			this.refAffaire = rset.getString("Num_Entier");				
			this.telClient = "";
			this.poids = true;

			rset.close();	
	
			
			// Paramtres dossier
      
			String reqCom = "select Com_BL, Logo_Adr from "+ base +".PARAM_DOSSIER";
			
			rset = stt.executeQuery(reqCom);
			
			rset.next();
			
			logoAdr = rset.getInt("Logo_Adr")==1;
			
			if (rset.getString("Com_BL").length()>0) {
				this.comFin += "\n\n"+rset.getString("Com_BL");
			}
			
			rset.close();			
			
			
			// nombre d'exemplaires  sortir

			String reqEx = "select Nb_Bon, Code_Fournisseur, Bon_Chiffre from "+ base +".FICHE_CLIENT where Client_Id='"+ clientId +"'";
			rset = stt.executeQuery(reqEx);

			if (rset.next()) {

			  this.nbex = rset.getInt("Nb_Bon") + 1;
				this.codeFournisseur = rset.getString("Code_Fournisseur");
				this.bonChiffreClient = rset.getInt("Bon_Chiffre")==1;
	      }
				else {
	        this.nbex = 1;
					this.codeFournisseur = "";
	      }
			
			rset.close();
						
			// est ce le dernier bon de livraison de l'affaire ou de la commande web

			String reqDernierBon = "select coalesce(max(Bon_Id),0) from "+ base +".BON_LIVRAISON where Etat='V' and Commande_Id="+ commandeId;

			rset = stt.executeQuery(reqDernierBon);

			boolean dernierBon= false;
			
			if (rset.next()) {
				dernierBon = (rset.getString(1).equals( bonId ));
			}
			rset.close();

		  
			// selection des articles appartenant au BL + reliquats (non livrs ou livrs partiellement ne faisant pas partie du BL)

			String reqArticles = "";
			
			reqArticles = "select * from (select 1 as tri, b.Rank, c.Prix_Unitaire, c.Ristourne, c.Code_TVA, c.Ligne_Id, c.Libelle, c.Reference, c.Designation, b.Quantite, c.Quantite as QteCom, c.Type_Ligne, c.Commentaire_Apres, c.Commentaire_Avant, c.Unite, coalesce(b.Num_Lot,'') as Num_Lot, coalesce(b.Nb_Pieces,0) as Nb_Pieces, coalesce(b.Date_Peremption,0) as Date_Peremption "
					+ "from "+ base +".LIGNE_BON_LIVRAISON b,"+ base +".LIGNE_COMMANDE_CLIENT c "
					+ "where b.Ref_Ligne=c.Ligne_Id and b.Bon_Id="+ bonId;


			reqArticles += " union select 2 as tri, 0 as Rank, c.Prix_Unitaire, c.Ristourne, c.Code_TVA, c.Ligne_Id, c.Libelle, c.Reference, c.Designation, 0 as Quantite, c.Quantite as QteCom, c.Type_Ligne, c.Commentaire_Apres, c.Commentaire_Avant, c.Unite, coalesce(b.Num_Lot,'') as Num_Lot, coalesce(b.Nb_Pieces,0) as Nb_Pieces, coalesce(b.Date_Peremption,0) as Date_Peremption "
					+ " from "+ base +".LIGNE_COMMANDE_CLIENT c left join (select distinct b.Ref_Ligne, b.Num_Lot, b.Nb_Pieces, b.Date_Peremption from "+ base +".LIGNE_BON_LIVRAISON b, "+ base +".BON_LIVRAISON bl where bl.Bon_Id=b.Bon_Id and b.Statut='V' and (Etat = 'V' or bl.Bon_Id ="+ bonId +")) as b on b.Ref_Ligne=c.Ligne_Id "
					+ " where Commande_Id="+ commandeId +" and c.Statut='V' and (((select sum(Quantite) from "+ base +".LIGNE_BON_LIVRAISON bb, "+ base +".BON_LIVRAISON b1 where b1.Bon_Id=bb.Bon_Id and bb.Statut='V' and Etat='V' and bb.Ref_Ligne=c.Ligne_Id)<c.Quantite"
					+ " and b.Ref_Ligne NOT IN (select bbb.Ref_Ligne from "+ base +".LIGNE_BON_LIVRAISON bbb , "+ base +".BON_LIVRAISON b2 where b2.Bon_Id=bbb.Bon_Id and bbb.Statut='V' and bbb.Bon_Id="+ bonId +")) "
					+ " or isNull(b.Ref_Ligne)) order by tri, Rank) as bl";
			
			String reqInfosSup = "select coalesce(ma.Libelle,'') as Marque, coalesce(ca.Libelle,'') as Couleur, coalesce(ta.Libelle,'') as Taille, fa.Descrip_1, fa.Descrip_2, fa.Imp_Nom_Bon, fa.Imp_Desc1_Bon, fa.Imp_Desc2_Bon, if(fa.Mesure_Poids='K',fa.Poids_Brut,if(fa.Mesure_Poids='G',fa.Poids_Brut/1000,fa.Poids_Brut*1000)) as Poids_Brut";
			reqInfosSup += " from "+ base +".FICHE_ARTICLE fa left join "+ base +".MARQUE_ARTICLE ma on fa.Marque_Id=ma.Marque_Id";
			reqInfosSup += " left join "+ base +".COULEUR_ARTICLE ca on fa.Couleur_Id=ca.Couleur_Id";
			reqInfosSup += " left join "+ base +".TAILLE_ARTICLE ta on fa.Taille_Id=ta.Taille_Id where fa.Article_Id=?";
			
			PreparedStatement psInfosSup = con.prepareStatement(reqInfosSup);
			
			
			String reqNomenclature = "select n.ArticleComp_Id, n.Quantite, f.Designation "
														 + "from "+ base +".FICHE_ARTICLE f,"+ base +".COMPOSANT_ARTICLE n where f.Article_Id=n.ArticleComp_Id and n.Article_Id=?";
			
			PreparedStatement psNomenclature = con.prepareStatement(reqNomenclature);
			
			
			
			String reqReliquat = "select sum(a.Quantite) as Quantite from "+ base +".BON_LIVRAISON b, "+ base +".LIGNE_BON_LIVRAISON a ";
			
			reqReliquat += "where (b.Etat='V' or b.Bon_Id="+ bonId +") and b.Date_Liv<="+ dateBon +" and b.Bon_Id=a.Bon_Id and b.Commande_Id="+ commandeId +" and a.Ref_Ligne=? and a.Statut='V'";
			
			PreparedStatement psReliquat = con.prepareStatement(reqReliquat);
					
			rset = stt.executeQuery(reqArticles);
			
			while (rset.next()) {
				
				LigneBonLivraison lb = new LigneBonLivraison();
        
				String libelle = rset.getString("Libelle");
				
				if (libelle.length()>0) {
					libelle = "\n"+ libelle;
				}			
				
				lb.setReference(rset.getString("Reference"));
				lb.setDesignation(rset.getString("Designation") + libelle);
				lb.setQuantite(rset.getDouble("Quantite"));
				lb.setPrixUnitaire(rset.getDouble("Prix_Unitaire") * (1-rset.getDouble("Ristourne")/100));
				lb.setCommentaire(rset.getString("Commentaire_Apres"));
				lb.setCommentaireAvant(rset.getString("Commentaire_Avant"));
				lb.setType('A');
				lb.setQteCom(rset.getDouble("QteCom"));				
				lb.setMontant(lb.prixUnitaire * lb.quantite);

				lb.setUnite(rset.getString("Unite"));
				lb.setNumLot(rset.getString("Num_Lot"));
				lb.setNbPieces(rset.getInt("Nb_Pieces"));
				lb.setDatePeremption(rset.getLong("Date_Peremption"));
				
				if (!lb.unite.equals("U")) unite = true;
				if (!lb.num_lot.equals("")) numLot = true;
				if (lb.nb_pieces != 0) nbPieces = true;
				if (lb.date_peremption != 0) datePeremption = true;
				
				montantBase += lb.montant;
				
				lb.setSousTotal(montantBase);				
				
				psReliquat.setInt(1, rset.getInt("Ligne_Id"));
				ResultSet rsRel = psReliquat.executeQuery();
				rsRel.next();

				lb.setReliquat(lb.qteCom - rsRel.getDouble("Quantite"));

				rsRel.close();

				if (soldee==1 && lb.reliquat>0 && dernierBon) {
					lb.setReliquat(-1);
				}
												
				lignes.add(lb);			
				
				
				if (rset.getString("Type_Ligne").equalsIgnoreCase("S")) {					
				
					// rcupration infos supplmentaires si existent
					psInfosSup.setString(1, lb.reference);
					ResultSet rsIS = psInfosSup.executeQuery();

					if (rsIS.next()) {

						lb.setMarque(rsIS.getString("Marque"));
						lb.setCouleur(rsIS.getString("Couleur"));
						lb.setTaille(rsIS.getString("Taille"));

						if (rsIS.getString("Couleur").length()>0) {
							coul = true;
						}

						if (rsIS.getString("Taille").length()>0) {
							tail = true;
						}
						
						if (rsIS.getInt("Imp_Desc1_Bon")==1) {
							lb.setDetail_1(StringUtils.removeHtmlTags(rsIS.getString("Descrip_1")));
						}
						if (rsIS.getInt("Imp_Desc2_Bon")==1) {
							lb.setDetail_2(StringUtils.removeHtmlTags(rsIS.getString("Descrip_2")));
						}
						
						poidsTotal = poidsTotal + (rsIS.getDouble("Poids_Brut") * lb.quantite);

						// gestion de la nomenclature
						if (rsIS.getInt("Imp_Nom_Bon")==1)	{

							psNomenclature.setString(1, lb.reference);
							ResultSet rsN = psNomenclature.executeQuery();

							while (rsN.next()) {
								LigneBonLivraison ln = new LigneBonLivraison();

								ln.setReference(rsN.getString("ArticleComp_Id"));
								ln.setDesignation(rsN.getString("Designation"));
								ln.setQuantite(rsN.getDouble("Quantite"));
								ln.setType('N');
								ln.setSousTotal(montantBase);			

								lignes.add(ln);
							}

							rsN.close();
						}
						
					}
					rsIS.close();								
				}				
			}
			
			calc = new Calcul(s, Integer.parseInt(bonId), "Bon_Livraison");
			ventilTVA = calc.getLignesTVA();

			mRemise = calc.getRemiseM();
			totalBase = calc.getTotalHT();
			
			totalTVA = calc.getTotalTVA();
			
			montantTTC = calc.getMontantTTC();
			
      rset.close();
			stt.close();			
			s.closeConnection(con, null);
			
		} catch(Exception e) {
			e.printStackTrace();
		}	
	}
	
	
	
	public double calcSousTotal(int derniereLigne) {
		return (derniereLigne<0)?0:lignes.get(derniereLigne).sousTotal;		
	}	
	
	
	public int getNbLignes() {
		return lignes.size();
	}
	
	
	public int getNbEx() {
		return nbex;
	}
	
	
} // fin DataBonLivraison
