/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes ncessaires  l'dition d'un bon de picking standard
 */

package org.opensi.facturation.actions.documents.modeles;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;

import org.experlog.openeas.api.Session;
import org.opensi.facturation.DocumentUtils;
import org.opensi.util.tools.StringUtils;


public class DataBonPicking {


	// les lignes du bon de prparation
	protected ArrayList<LigneBonPicking> lignes = new ArrayList<LigneBonPicking>(10);	


	// coordonnes socit mettrice
	protected String raisonSociale;
	protected String adresse1;
	protected String adresse2;
	protected String adresse3;
	protected String codePostal;
	protected String ville;
	protected String tel;
	protected String fax;
	protected String email;
	protected String web;
	protected String urlLogo = "";
	protected boolean logoAdr;
	
	protected double capital;
	protected String typeSociete;
	protected String tvaIntra;
	protected String rcs;
	protected String siren;
	
	
	// infos bon de picking
	protected long dateEditionLot;
	protected String marque = "";
	
	protected boolean coul = false;
	protected boolean tail = false;
	protected boolean unite = false;
	protected boolean nbPieces = false;
	protected boolean numLot = false;
	protected boolean datePeremption = false;
	protected boolean referenceFabricant = false;
	protected boolean stockReel = true;
	protected boolean stockDispo = true;
	protected boolean montantTTC = false;
	
	public DataBonPicking(Session s, long dateEditionLot, int marqueId) {	
		try {
		
			Connection con = s.getConnection(null);
			Statement stt = con.createStatement();
      
			String base = s.getCookie().get("BaseDossier");
			String dossierId = s.getCookie().get("Dossier_Id");
			this.urlLogo = s.getAppConfiguration().get("opensi.absdir") +"/logos/"+ dossierId +".jpg";
			this.dateEditionLot = dateEditionLot;
			
			ResultSet rset;
			
			if (marqueId!=0) {
				String reqMarque = "select Libelle from "+ base +".MARQUE_ARTICLE where Marque_Id="+ marqueId;
				rset = stt.executeQuery(reqMarque);
				if (rset.next()) {
					this.marque = rset.getString("Libelle");
				}
				rset.close();
			}
      
			// coordonnes de l'entreprise facturante
			String reqFacturante = "select s.Ville_RCS, s.Num_TVA_Intra, ts.Libelle as Type_Societe, s.Montant_Capital, s.Num_SIRET, s.Denomination, s.Adresse_1, s.Adresse_2, s.Adresse_3, s.Code_Postal, s.Ville, s.Telephone, s.Fax, s.Email, s.Site_Web";
			reqFacturante += " from "+ base +".SOCIETE s join "+ base +".TYPE_SOCIETE ts on s.Type_Societe=ts.Type_Societe_Id";
			rset = stt.executeQuery(reqFacturante);
			rset.next();
			this.raisonSociale = rset.getString("Denomination");
			this.adresse1 = rset.getString("Adresse_1");
			this.adresse2 = rset.getString("Adresse_2");
			this.adresse3 = rset.getString("Adresse_3");
			this.codePostal = rset.getString("Code_Postal");
			this.ville = rset.getString("Ville");
			this.tel = rset.getString("Telephone");
			this.fax = rset.getString("Fax");
			this.email = rset.getString("Email");
			this.web = rset.getString("Site_Web");
			this.siren = DocumentUtils.formatSiren(rset.getString("Num_SIRET"));
			this.typeSociete = rset.getString("Type_Societe");
			this.capital = rset.getDouble("Montant_Capital");
			this.tvaIntra = rset.getString("Num_TVA_Intra");
			this.rcs = rset.getString("Ville_RCS");
			rset.close();
				
			// Paramtres dossier
			String reqCom = "select Logo_Adr from "+ base +".PARAM_DOSSIER";
			rset = stt.executeQuery(reqCom);
			rset.next();
			logoAdr = rset.getInt("Logo_Adr")==1;
			rset.close();
      
      
			// selection des articles appartenant au bon de livraison
			String reqArticles = "select lcc.Libelle, lcc.Reference, lcc.Designation, lbl.Quantite, lcc.Commentaire_Apres, lcc.Commentaire_Avant, fa.Localisation, coalesce(ma.Libelle,'') as Marque, lcc.Unite, lbl.Num_Lot, lbl.Nb_Pieces, lbl.Date_Peremption,";
			reqArticles += " avg(if(cc.Edition_TTC=1, lcc.Prix_Unitaire, lcc.Prix_Unitaire*(1+lcc.Taux_TVA/100))) as Prix_Unitaire_TTC,";
			reqArticles += " sum(if(cc.Edition_TTC=1, lcc.Prix_Unitaire, lcc.Prix_Unitaire*(1+lcc.Taux_TVA/100)) * (1-lcc.Ristourne/100) * lbl.Quantite) as Montant_TTC";
			reqArticles += " from "+ base +".BON_LIVRAISON bl, "+ base +".LIGNE_BON_LIVRAISON lbl, "+ base +".LIGNE_COMMANDE_CLIENT lcc, "+ base +".COMMANDE_CLIENT cc, "+ base +".FICHE_ARTICLE fa left join "+ base +".MARQUE_ARTICLE ma on fa.Marque_Id=ma.Marque_Id";
		    reqArticles += " where lcc.Type_Ligne='S' and lcc.Commande_Id=cc.Commande_Id and lcc.Reference=fa.Article_Id and lbl.Ref_Ligne=lcc.Ligne_Id and lbl.Bon_Id=bl.Bon_Id and bl.Date_Edition_Lot=?";
			if (marqueId!=0) { reqArticles += " and fa.Marque_Id=?"; }
			else { reqArticles += " and fa.Marque_Id is null"; }
		    reqArticles += " group by lcc.Reference order by fa.Localisation";
			PreparedStatement psArticles = con.prepareStatement(reqArticles);
			
			String reqInfosSup = "select coalesce(ma.Libelle,'') as Marque, coalesce(ca.Libelle,'') as Couleur, coalesce(ta.Libelle,'') as Taille, fa.Descrip_1, fa.Descrip_2, fa.Imp_Nom_BP, fa.Imp_Desc1_BP, fa.Imp_Desc2_BP, fa.Ref_Fabricant";
			reqInfosSup += " from "+ base +".FICHE_ARTICLE fa left join "+ base +".MARQUE_ARTICLE ma on fa.Marque_Id=ma.Marque_Id";
			reqInfosSup += " left join "+ base +".COULEUR_ARTICLE ca on fa.Couleur_Id=ca.Couleur_Id";
			reqInfosSup += " left join "+ base +".TAILLE_ARTICLE ta on fa.Taille_Id=ta.Taille_Id where fa.Article_Id=?";
			PreparedStatement psInfosSup = con.prepareStatement(reqInfosSup);
			
			String reqNomenclature = "select n.ArticleComp_Id, n.Quantite, f.Designation";
			reqNomenclature += " from "+ base +".FICHE_ARTICLE f, "+ base +".COMPOSANT_ARTICLE n where f.Article_Id=n.ArticleComp_Id and n.Article_Id=?";
			PreparedStatement psNomenclature = con.prepareStatement(reqNomenclature);
					
			String reqStock = "select Stock_Init+Entrees-Sorties as Stock_Reel, Stock_Init+Entrees-Sorties-Com_Clients as Stock_Dispo";
			reqStock += " from "+ base +".STOCKS_ARTICLE where Article_Id=?";
			PreparedStatement psStock = con.prepareStatement(reqStock);

			psArticles.setLong(1, dateEditionLot);
			if (marqueId!=0) { psArticles.setInt(2, marqueId); }
			rset = psArticles.executeQuery();
			
			while (rset.next()) {
				
				LigneBonPicking lb = new LigneBonPicking();
        
				String libelle = rset.getString("Libelle");
				if (libelle.length()>0) { libelle = "\n"+libelle; }			
				
				lb.setReference(rset.getString("Reference"));
				lb.setDesignation(rset.getString("Designation") + libelle);
				lb.setQuantite(rset.getDouble("Quantite"));
				lb.setPUTTC(rset.getDouble("Prix_Unitaire_TTC"));
				lb.setMontantTTC(rset.getDouble("Montant_TTC"));
				lb.setCommentaireAvant(rset.getString("Commentaire_Avant"));
				lb.setCommentaireApres(rset.getString("Commentaire_Apres"));
				lb.setLocalisation(rset.getString("Localisation"));
				lb.setMarque(rset.getString("Marque"));
				lb.setUnite(rset.getString("Unite"));
				lb.setNumLot(rset.getString("Num_Lot"));
				lb.setNbPieces(rset.getInt("Nb_Pieces"));
				lb.setDatePeremption(rset.getLong("Date_Peremption"));
				lb.setType('A');
				
				if (!lb.unite.equals("U")) unite = true;
				if (!lb.num_lot.equals("")) numLot = true;
				if (lb.nb_pieces != 0) nbPieces = true;
				if (lb.date_peremption != 0) datePeremption = true;

				// rcupration infos supplmentaires si existent
				psInfosSup.setString(1, lb.reference);
				ResultSet rsIS = psInfosSup.executeQuery();
				
				if (rsIS.next()) {
					
					if (rsIS.getString("Couleur").length()>0) { coul = true; }
					if (rsIS.getString("Taille").length()>0) { tail = true; }
					if (rsIS.getString("Ref_Fabricant").length()>0) { referenceFabricant = true; }

					lb.setCouleur(rsIS.getString("Couleur"));
					lb.setTaille(rsIS.getString("Taille"));
					if (rsIS.getInt("Imp_Desc1_BP")==1) { lb.setDetail_1(StringUtils.removeHtmlTags(rsIS.getString("Descrip_1"))); }
					if (rsIS.getInt("Imp_Desc2_BP")==1) { lb.setDetail_2(StringUtils.removeHtmlTags(rsIS.getString("Descrip_2"))); }
					lb.setRefFabricant(rsIS.getString("Ref_Fabricant"));
					
					psStock.setString(1, lb.reference);
					ResultSet rsSt = psStock.executeQuery();
					if (rsSt.next()) {
						lb.setStockReel(rsSt.getDouble("Stock_Reel"));
						lb.setStockDispo(rsSt.getDouble("Stock_Dispo"));
					}
					rsSt.close();

					// gestion de la nomenclature
					if (rsIS.getInt("Imp_Nom_BP")==1)	{
						psNomenclature.setString(1, lb.reference);
						ResultSet rsN = psNomenclature.executeQuery();
						while (rsN.next()) {
							LigneBonPicking ln = new LigneBonPicking();
							ln.setReference(rsN.getString("ArticleComp_Id"));
							ln.setDesignation(rsN.getString("Designation"));
							ln.setQuantite(rsN.getDouble("Quantite"));
							ln.setType('N');			
							lignes.add(ln);
						}
						rsN.close();
					}
				}
				rsIS.close();
				lignes.add(lb);
			}
			rset.close();
			
			psArticles.close();
			psInfosSup.close();
			psNomenclature.close();
			psStock.close();
			stt.close();
			s.closeConnection(con, null);
			
		} catch(Exception e) {
			e.printStackTrace();
		}	
	}
	
	
	
	public int getNbLignes() {
		return lignes.size();
	}
	
	

} // fin DataBonPicking
