/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes ncessaires  l'dition d'un bon de prparation standard
 */

package org.opensi.facturation.actions.documents.modeles;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;

import org.experlog.openeas.api.Session;
import org.opensi.facturation.DocumentUtils;
import org.opensi.util.tools.StringUtils;


public class DataBonPreparation {


	// les lignes du bon de prparation
	protected ArrayList<LigneBonPreparation> lignes = new ArrayList<LigneBonPreparation>(10);	


	// coordonnes socit mettrice

	protected String raisonSociale;
	protected String adresse1;
	protected String adresse2;
	protected String adresse3;
	protected String codePostal;
	protected String ville;
	protected String tel;
	protected String fax;
	protected String email;
	protected String web;

	protected double capital;
	protected String typeSociete;
	protected String tvaIntra;
	protected String rcs;
	protected String siren;

	// coordonnes du destinataire

	protected String clientId;
	protected String raisonSocialeDest;
	protected String adresse1Dest;
	protected String adresse2Dest;
	protected String adresse3Dest;
	protected String codePostalDest;
	protected String villeDest;
	protected String paysDest;

	protected String raisonSocialeFact;
	protected String adresseFact;
	protected String compAdresseFact;
	protected String adresseFact3;
	protected String codePostalFact;
	protected String villeFact;
	protected String paysFact;
	protected String interlocuteurFact;

	// contact de livraison
	protected String interlocuteurLiv = "";
	protected String telInterLiv;
	protected String faxInterLiv;
	protected String emailInterLiv;

	// infos bon de prparation

	protected String numeroBon;
	protected String numCommande;
	protected String refCommande;
	protected String refAffaire;
	protected String modeExpedition;
	protected String provenance;
	protected boolean existeSites;
	protected String urlLogo = "";
	protected String urlAnnule = "";	
	protected String comFin = "";
	protected String mentions = "";

	protected long dateBon;	

	protected boolean coul = false;
	protected boolean tail = false;
	protected boolean unite = false;
	protected boolean nbPieces = false;
	protected boolean numLot = false;
	protected boolean datePeremption = false;
	protected boolean annule;
	protected boolean logoAdr;
	protected int commandeId = 0;
	protected int affaireId = 0;

	protected boolean referenceFabricant = false;
	protected boolean stockReel = false;
	protected boolean stockDispo = false;

	public DataBonPreparation(Session s, String bonId) {	
		try {

			Connection con = s.getConnection(null);
			Statement stt = con.createStatement();


			String base = s.getCookie().get("BaseDossier");
			String dossierId = s.getCookie().get("Dossier_Id");

			this.urlLogo = s.getAppConfiguration().get("opensi.absdir") +"/logos/"+ dossierId +".jpg";
			this.urlAnnule = s.getAppConfiguration().get("opensi.absdir") +"/images/annule.jpg";

			ResultSet rset;


			// coordonnes de l'entreprise facturante
			String reqFacturante = "select s.Ville_RCS, s.Num_TVA_Intra, ts.Libelle as Type_Societe, s.Montant_Capital, s.Num_SIRET, s.Denomination, s.Adresse_1, s.Adresse_2, s.Adresse_3, s.Code_Postal, s.Ville, s.Telephone, s.Fax, s.Email, s.Site_Web";
			reqFacturante += " from "+ base +".SOCIETE s join "+ base +".TYPE_SOCIETE ts on s.Type_Societe=ts.Type_Societe_Id";
			rset = stt.executeQuery(reqFacturante);

			rset.next();

			this.raisonSociale = rset.getString("Denomination");
			this.adresse1 = rset.getString("Adresse_1");
			this.adresse2 = rset.getString("Adresse_2");
			this.adresse3 = rset.getString("Adresse_3");
			this.codePostal = rset.getString("Code_Postal");
			this.ville = rset.getString("Ville");
			this.tel = rset.getString("Telephone");
			this.fax = rset.getString("Fax");
			this.email = rset.getString("Email");
			this.web = rset.getString("Site_Web");

			this.siren = DocumentUtils.formatSiren(rset.getString("Num_SIRET"));
			this.typeSociete = rset.getString("Type_Societe");
			this.capital = rset.getDouble("Montant_Capital");
			this.tvaIntra = rset.getString("Num_TVA_Intra");
			this.rcs = rset.getString("Ville_RCS");

			rset.close();


			// Vrifier qu'il existe des sites web
			String reqExisteSites = "select count(*) as Nb from "+ base +".SITE_WEB where Status='a'";
			rset = stt.executeQuery(reqExisteSites);
			rset.next();
			this.existeSites = (rset.getInt("Nb")>0);
			rset.close();

			// Elments du bon de livraison

			String reqBon = "select coalesce(ml.Nom,'') as Mode_Expedition,coalesce(cc.Client_Id,'') as Client_Id,cc.Ref_Commande,cc.Numero as Num_Commande,cc.Soldee,cc.Remise,cc.Denomination,cc.Affaire_Id,bl.*, p.Nom_FR, trim(concat(c.Civ_Courte,' ',bl.Nom_Inter_Liv,' ',bl.Prenom_Inter_Liv)) as interlocuteurLiv, coalesce(sw.Nom_Site,'Hors ligne') as Provenance from "+ base +".BON_LIVRAISON bl";
			reqBon += " left join "+ base +".COMMANDE_CLIENT cc on cc.Commande_Id=bl.Commande_Id left join "+ base +".MODE_LIVRAISON ml on cc.Mode_Expedition=ml.Mode_Liv_Id left join "+ base +".COMMANDE_CLIENT_WEB ccw on cc.Commande_Id=ccw.Commande_Id left join "+ base +".SITE_WEB sw on sw.Site_Id=ccw.Site_Web_Id, PAYS p, CIVILITE c where bl.Code_Pays_Liv=p.Code_Pays and c.Civ_Id=bl.Civ_Inter_Liv and bl.Bon_Id="+ bonId;

			rset = stt.executeQuery(reqBon);

			rset.next();
			this.modeExpedition = rset.getString("Mode_Expedition");
			this.provenance = rset.getString("Provenance");
			this.raisonSocialeFact = rset.getString("Denomination");
			this.numCommande = rset.getString("Num_Commande");
			this.refCommande = rset.getString("Ref_Commande");
			this.clientId = rset.getString("Client_Id");

			this.numeroBon = rset.getString("Num_Entier");
			this.dateBon = rset.getLong("Date_Liv");
			if (this.dateBon==0) { this.dateBon = System.currentTimeMillis(); }
			this.annule = rset.getString("Etat").equals("A");
			this.affaireId = rset.getInt("Affaire_Id");
			this.commandeId = rset.getInt("Commande_Id");
			this.interlocuteurLiv = rset.getString("interlocuteurLiv");
			this.telInterLiv = rset.getString("Tel_Inter_Liv");
			this.faxInterLiv = rset.getString("Fax_Inter_Liv");
			this.emailInterLiv = rset.getString("Email_Inter_Liv");

			this.raisonSocialeDest = rset.getString("Denomination_Liv");
			this.adresse1Dest = rset.getString("Adresse_1_Liv");
			this.adresse2Dest = rset.getString("Adresse_2_Liv");
			this.adresse3Dest = rset.getString("Adresse_3_Liv");
			this.codePostalDest = rset.getString("Code_Postal_Liv");
			this.villeDest = rset.getString("Ville_Liv");
			this.paysDest = rset.getString("Nom_FR");

			if (rset.getString("Commentaires_Fin").length()>0) {
				this.comFin = "\n"+ rset.getString("Commentaires_Fin");
			}
			this.mentions = "\n" + rset.getString("Mentions");

			rset.close();

			// affaire
			String reqAffaire = "select Client_Id, Num_Entier from "+ base +".AFFAIRE where Affaire_Id="+ affaireId;

			rset = stt.executeQuery(reqAffaire);

			rset.next();

			this.refAffaire = rset.getString("Num_Entier");				

			rset.close();	


			// Paramtres dossier

			String reqCom = "select Logo_Adr from "+ base +".PARAM_DOSSIER";

			rset = stt.executeQuery(reqCom);

			rset.next();

			logoAdr = rset.getInt("Logo_Adr")==1;

			rset.close();	


			// selection des articles appartenant au bon de livraison

			String reqArticles = "";

			reqArticles = "select * from ((select d.Libelle, d.Reference, d.Designation, b.Quantite, d.Type_Ligne, d.Commentaire_Apres, d.Commentaire_Avant, f.Localisation, d.Unite, b.Num_Lot, b.Nb_Pieces, b.Date_Peremption "
				+ "from "+ base +".LIGNE_BON_LIVRAISON b,"+ base +".LIGNE_COMMANDE_CLIENT d,"+ base +".FICHE_ARTICLE f "
				+ "where d.Type_Ligne='S' and d.Reference=f.Article_Id and b.Ref_Ligne=d.Ligne_Id and b.Bon_Id="+ bonId +" order by f.Localisation, b.Rank)"

				+ " union all "

				+ "(select d.Libelle, d.Reference, d.Designation, b.Quantite, d.Type_Ligne, d.Commentaire_Apres, d.Commentaire_Avant, '-' as Localisation, d.Unite, b.Num_Lot, b.Nb_Pieces, b.Date_Peremption "
				+ "from "+ base +".LIGNE_BON_LIVRAISON b,"+ base +".LIGNE_COMMANDE_CLIENT d "
				+ "where d.Type_Ligne<>'S' and b.Ref_Ligne=d.Ligne_Id and b.Bon_Id="+ bonId +" order by b.Rank)) as articles order by Localisation";

			rset = stt.executeQuery(reqArticles);

			String reqInfosSup = "select coalesce(ca.Libelle,'') as Couleur, coalesce(ta.Libelle,'') as Taille, fa.Descrip_1, fa.Descrip_2, fa.Imp_Nom_BP, fa.Imp_Desc1_BP, fa.Imp_Desc2_BP, fa.Ref_Fabricant";
			reqInfosSup += " from "+ base +".FICHE_ARTICLE fa left join "+ base +".COULEUR_ARTICLE ca on fa.Couleur_Id=ca.Couleur_Id";
			reqInfosSup += " left join "+ base +".TAILLE_ARTICLE ta on fa.Taille_Id=ta.Taille_Id where fa.Article_Id=?";

			PreparedStatement psInfosSup = con.prepareStatement(reqInfosSup);


			String reqNomenclature = "select n.ArticleComp_Id, n.Quantite, f.Designation "
				+ "from "+ base +".FICHE_ARTICLE f,"+ base +".COMPOSANT_ARTICLE n where f.Article_Id=n.ArticleComp_Id and n.Article_Id=?";

			PreparedStatement psNomenclature = con.prepareStatement(reqNomenclature);

			String reqStock = "select Stock_Init+Entrees-Sorties as Stock_Reel,Stock_Init+Entrees-Sorties-Com_Clients as Stock_Dispo "
				+ "from "+ base +".STOCKS_ARTICLE where Article_Id=?";

			PreparedStatement psStock = con.prepareStatement(reqStock);


			while (rset.next()) {

				LigneBonPreparation lb = new LigneBonPreparation();

				String libelle = rset.getString("Libelle");

				if (libelle.length()>0) {
					libelle = "\n"+libelle;
				}			

				lb.setReference(rset.getString("Reference"));
				lb.setDesignation(rset.getString("Designation") + libelle);
				lb.setQuantite(rset.getDouble("Quantite"));
				lb.setCommentaire(rset.getString("Commentaire_Apres"));
				lb.setCommentaireAvant(rset.getString("Commentaire_Avant"));
				lb.setLocalisation(rset.getString("Localisation"));
				lb.setType('A');

				lb.setUnite(rset.getString("Unite"));
				lb.setNumLot(rset.getString("Num_Lot"));
				lb.setNbPieces(rset.getInt("Nb_Pieces"));
				lb.setDatePeremption(rset.getLong("Date_Peremption"));

				lignes.add(lb);

				if (!lb.unite.equals("U")) unite = true;
				if (!lb.num_lot.equals("")) numLot = true;
				if (lb.nb_pieces != 0) nbPieces = true;
				if (lb.date_peremption != 0) datePeremption = true;


				if (rset.getString("Type_Ligne").equalsIgnoreCase("S")) {					

					// rcupration infos supplmentaires si existent
					psInfosSup.setString(1, lb.reference);
					ResultSet rsIS = psInfosSup.executeQuery();

					if (rsIS.next()) {

						psStock.setString(1, lb.reference);
						ResultSet rsSt = psStock.executeQuery();
						if (rsSt.next()) {
							lb.setStockReel(rsSt.getDouble("Stock_Reel"));
							lb.setStockDispo(rsSt.getDouble("Stock_Dispo"));
						}

						lb.setCouleur(rsIS.getString("Couleur"));
						lb.setTaille(rsIS.getString("Taille"));

						if (rsIS.getString("Couleur").length()>0) {
							coul = true;
						}

						if (rsIS.getString("Taille").length()>0) {
							tail = true;
						}

						if (rsIS.getInt("Imp_Desc1_BP")==1) {
							lb.setDetail_1(StringUtils.removeHtmlTags(rsIS.getString("Descrip_1")));
						}
						if (rsIS.getInt("Imp_Desc2_BP")==1) {
							lb.setDetail_2(StringUtils.removeHtmlTags(rsIS.getString("Descrip_2")));
						}

						lb.setRefFabricant(rsIS.getString("Ref_Fabricant"));

						// gestion de la nomenclature
						if (rsIS.getInt("Imp_Nom_BP")==1)	{

							psNomenclature.setString(1, lb.reference);
							ResultSet rsN = psNomenclature.executeQuery();

							while (rsN.next()) {
								LigneBonPreparation ln = new LigneBonPreparation();

								ln.setReference(rsN.getString("ArticleComp_Id"));
								ln.setDesignation(rsN.getString("Designation"));
								ln.setQuantite(rsN.getDouble("Quantite"));
								ln.setType('N');			

								lignes.add(ln);
							}

							rsN.close();
						}

					}
					rsIS.close();								
				}				
			}

			rset.close();
			stt.close();			
			s.closeConnection(con, null);

		} catch(Exception e) {
			e.printStackTrace();
		}	
	}



	public int getNbLignes() {
		return lignes.size();
	}



} // fin DataBonPreparation
