/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes ncessaires  l'dition d'une liste de clients
 */

package org.opensi.facturation.actions.editions;

import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

import org.experlog.openeas.api.Session;

public class DataListeClients {

	// les lignes de la liste des clients
	protected ArrayList<LigneListeClients> lignes = new ArrayList<LigneListeClients>(10);
	
	protected String dossierId;
	protected String raisonSociale;
	protected String adresse1;
	protected String adresse2;
	protected String adresse3;
	protected String codePostal;
	protected String ville;
	protected String monnaie;
	protected String familleClient = "";
	protected String commercial;
	protected String tri1;
	protected String tri2;
	protected String tri3;
	protected String tarifsSpe;
	protected String dateCourante;
	protected String clientsDe = "";
	protected String criteres = "";
	protected boolean useCodeTarif;
	
	public DataListeClients(Session s, int familleId, String commercial, String tri1, String tri2, String tri3, String tarifsSpe, String clientId) {

		try {
			Connection con = s.getConnection(null);
			Statement stt = con.createStatement();
			
			String base = s.getCookie().get("BaseDossier");
			this.dossierId = s.getCookie().get("Dossier_Id");
			this.commercial = commercial;
			this.tri1 = tri1;
			this.tri2 = tri2;
			this.tri3 = tri3;
			this.tarifsSpe = tarifsSpe;
			
			SimpleDateFormat formatDate = new SimpleDateFormat("dd/MM/yyyy");
			this.dateCourante = formatDate.format(new Date(System.currentTimeMillis()));
			
			ResultSet rset;
			
			if (familleId != 0) {
				String reqFamille = "select Libelle from "+ base +".FAMILLE_CLIENT where Famille_Id="+ familleId;
				rset = stt.executeQuery(reqFamille);
				rset.next();
				this.familleClient = rset.getString("Libelle");
				rset.close();
			}
			
			String reqLeDossier = "select s.Denomination, s.Adresse_1, s.Adresse_2, s.Adresse_3, s.Code_Postal, s.Ville, d.Intitule as Devise, pd.Mode_Tarif from "+ base +".SOCIETE s join DEVISE d on s.Monnaie_Tenue=d.Devise_Id, "+ base +".PARAM_DOSSIER pd";
			rset = stt.executeQuery(reqLeDossier);
			rset.next();
			this.raisonSociale = rset.getString("Denomination");
			this.adresse1 = rset.getString("Adresse_1");
			this.adresse2 = rset.getString("Adresse_2");
			this.adresse3 = rset.getString("Adresse_3");
			this.codePostal = rset.getString("Code_Postal");
			this.ville = rset.getString("Ville");
			this.monnaie = rset.getString("Devise");
			this.useCodeTarif = (rset.getString("Mode_Tarif").equals("G"));
			rset.close();
			
			String reqClients = "select fc.Client_Id, fc.Denomination, fc.Adresse_1, fc.Code_Postal, fc.Ville, fc.Tel_1, fc.Fax_1, fc.Email_1, coalesce(fa.Libelle,'') as Famille, fc.Code_Tarif, fc.Taux_Remise,";
			reqClients += " coalesce(c.Civ_Courte,'') as Civ_Resp, coalesce(r.Nom,'') as Nom_Resp, coalesce(r.Prenom,'') as Prenom_Resp,";
			reqClients += " c2.Civ_Courte as Civ_Contact, cc.Nom as Nom_Contact, cc.Prenom as Prenom_Contact, coalesce(fc.Numero_Compte,'') as Numero_Compte, fc.Num_TVA_Intra, fc.Num_SIRET, fc.Code_NAF,";
			reqClients += " p.Nom_FR as Pays from "+ base +".FICHE_CLIENT fc left join "+ base +".FAMILLE_CLIENT fa on fc.Famille_Id=fa.Famille_Id";
			reqClients += " left join UTILISATEUR r on fc.Util_R=r.Utilisateur_Id left join CIVILITE c on r.Civilite=c.Civ_Id left join ";
			reqClients += " "+ base +".CONTACT_CLIENT cc on cc.Client_Id=fc.Client_Id and cc.Principal_Fact=1 left join CIVILITE c2 on cc.Civilite=c2.Civ_Id left join ";
			reqClients += " PAYS p on fc.Code_Pays=p.Code_Pays where fc.Supprime=0";
			
			if (!clientId.equals("")) {
				reqClients += " and fc.Client_Id='"+ s.sqlEncode(clientId) +"'";
			}

			if (familleId != 0) {
				reqClients += " and fc.Famille_Id="+ familleId;
				criteres += "Famille : "+ familleClient;
			}

			if (!commercial.equals("")) {
				reqClients += " and fc.Util_R="+ Integer.parseInt(commercial);
				Statement sttCom = con.createStatement();
				ResultSet rsCom = sttCom.executeQuery("select Prenom, Nom from UTILISATEUR where Utilisateur_Id="+ Integer.parseInt(commercial));
				if (rsCom.next()) {
					clientsDe = " de "+ rsCom.getString("Prenom") +" "+ rsCom.getString("Nom");
				}
				sttCom.close();
			}

			if (tarifsSpe.equals("1")) {
				reqClients += " and fc.Client_Id in (select distinct Client_Id from "+ base +".CLIENT_ARTICLE)";
				criteres += (!criteres.equals("")?" - ":"") +"Clients ayant des tarifs sp\u00E9cifiques";
			}

			reqClients += " order by fc."+ tri1;

			if (tri2.length()>0) reqClients += ", fc."+ tri2;
			if (tri3.length()>0) reqClients += ", fc."+ tri3;
			
			rset = stt.executeQuery(reqClients);

			while (rset.next()) {
				LigneListeClients llc = new LigneListeClients();

				llc.setFamille(rset.getString("Famille"));
				llc.setNumero(rset.getString("Client_Id"));
				llc.setClient(rset.getString("Denomination"));
				llc.setAdresse(rset.getString("Adresse_1"));
				llc.setCp(rset.getString("Code_Postal"));
				llc.setVille(rset.getString("Ville"));
				llc.setPays(rset.getString("Pays"));
				llc.setTel(rset.getString("Tel_1"));
				llc.setFax(rset.getString("Fax_1"));
				llc.setEmail(rset.getString("Email_1"));
				llc.setCodeTarif(rset.getInt("Code_Tarif"));
				llc.setTauxRemise(rset.getDouble("Taux_Remise"));
				llc.setResponsable(rset.getString("Civ_Resp")+ " "+ rset.getString("Nom_Resp")+ " "+ rset.getString("Prenom_Resp"));
				llc.setContactPrincipal(rset.getString("Civ_Contact")+ " "+ rset.getString("Nom_Contact")+ " "+ rset.getString("Prenom_Contact"));
				llc.setNumCompteComptable(rset.getString("Numero_Compte"));
				llc.setNumTVA(rset.getString("Num_TVA_Intra"));
				llc.setSiret(rset.getString("Num_SIRET"));
				llc.setCodeNAF(rset.getString("Code_NAF"));
				
				lignes.add(llc);
			}
			
			rset.close();
			stt.close();
			s.closeConnection(con, null);
		}
		catch(Exception e) {
			e.printStackTrace();
		}			
	}
	
	public int getNbLignes() {
		return lignes.size();
	}


} // fin DataListeClients
