/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration d'un historique des articles nomenclaturs fabriqus
 */

package org.opensi.facturation.actions.fabrication;


import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.util.pdf.GlobalDocument;
import org.opensi.util.tools.DateTime;


public class GenHistoriqueFabrication extends Action {


  public boolean serverSide() { return true; }

  public boolean service(Session s, ServletRequest r, Object info) throws Exception {
	
	  	String fichierPdf = r.getParameter("FichierPdf") != null ? r.getParameter("FichierPdf") : "";
		String fichierCsv = r.getParameter("FichierCsv") != null ? r.getParameter("FichierCsv") : "";
		String absdir = s.getAppConfiguration().get("opensi.absdir");
		
		String periode = r.getParameter("Periode");

		long debutPeriode = 0;
		long finPeriode = 0;

		if (periode.equals("DD")) {
			debutPeriode = DateTime.parseDate(r.getParameter("Date_Debut"), "yyyy:MM:dd");
			finPeriode = DateTime.parseDate(r.getParameter("Date_Fin"), "yyyy:MM:dd");
		}
		else {
			DateTime cd = new DateTime();
			int currentYear = cd.getYear();
			int currentMonth = cd.getMonth();

			DateTime dtDeb = new DateTime();
			DateTime dtFin = new DateTime();

			if (periode.equals("MC")) {
				dtDeb = new DateTime(1, currentMonth, currentYear);
				dtFin = new DateTime(cd.currentMaxDay(), currentMonth, currentYear);
			}
			else if (periode.equals("MP")) {
				dtDeb = new DateTime(1, currentMonth-1, currentYear);
				dtFin = new DateTime(cd.previousMaxDay(), currentMonth-1, currentYear);
			}

			debutPeriode = dtDeb.getDateInMillis();
			finPeriode = dtFin.getDateFullTime();
		}
		
		
		DataHistoriqueFabrication dhf = new DataHistoriqueFabrication(s, debutPeriode, finPeriode);
		
		if (!fichierPdf.equals("")) {
			// Cration d'un PDF
			String repPdf = absdir +"/pdf/";
			String repTemp = repPdf;			
		
			PdfHistoriqueFabrication pdfHistoriqueFabrication = new PdfHistoriqueFabrication(repTemp, dhf);
			GlobalDocument gd = new GlobalDocument(repPdf, fichierPdf);	
			gd.addInternal(pdfHistoriqueFabrication);	
			gd.close(GlobalDocument.ON_EXIT);
		} else if (!fichierCsv.equals("")) {
			// Cration d'un CSV
			String buffer = absdir +"/iobuffer/";
			new CsvHistoriqueFabrication(buffer, fichierCsv, dhf);
		}
		
		return true;
		
	} // fin service


} // fin GenJournalFabrication
