/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Gnration du csv des mises  jour de tarifs
 */

package org.opensi.facturation.actions.majtarifs;

import org.opensi.util.listing.ListingFile;
import org.opensi.util.listing.ListingTabFile;


public class CsvMajTarifs {

	public CsvMajTarifs(String buffer, String fichier, DataMajTarifs dmt) throws Exception {

		ListingFile lf = new ListingTabFile();

		lf.newLine();
		lf.addToLine("R\u00E9f. Article");
		lf.addToLine("Anc. Prix Achat (EUR)");
		lf.addToLine("Nv. Prix Achat (EUR)");
		lf.addToLine("Anc. Coeff 1");
		lf.addToLine("Nv. Coeff 1");
		lf.addToLine("Anc. Coeff 2");
		lf.addToLine("Nv. Coeff 2");
		lf.addToLine("Anc. Coeff 3");
		lf.addToLine("Nv. Coeff 3");
		lf.addToLine("Anc. Coeff 4");
		lf.addToLine("Nv. Coeff 4");
		lf.addToLine("Anc. Coeff 5");
		lf.addToLine("Nv. Coeff 5");
		lf.addToLine("Anc. PV HT 1 (EUR)");
		lf.addToLine("Nv. PV HT 1 (EUR)");
		lf.addToLine("Anc. PV HT 2 (EUR)");
		lf.addToLine("Nv. PV HT 2 (EUR)");
		lf.addToLine("Anc. PV HT 3 (EUR)");
		lf.addToLine("Nv. PV HT 3 (EUR)");
		lf.addToLine("Anc. PV HT 4 (EUR)");
		lf.addToLine("Nv. PV HT 4 (EUR)");
		lf.addToLine("Anc. PV HT 5 (EUR)");
		lf.addToLine("Nv. PV HT 5 (EUR)");
		lf.addToLine("Taux TVA (%)");
		lf.addToLine("Anc. PV TTC 1 (EUR)");
		lf.addToLine("Nv. PV TTC 1 (EUR)");
		lf.addToLine("Anc. PV TTC 2 (EUR)");
		lf.addToLine("Nv. PV TTC 2 (EUR)");
		lf.addToLine("Anc. PV TTC 3 (EUR)");
		lf.addToLine("Nv. PV TTC 3 (EUR)");
		lf.addToLine("Anc. PV TTC 4 (EUR)");
		lf.addToLine("Nv. PV TTC 4 (EUR)");
		lf.addToLine("Anc. PV TTC 5 (EUR)");
		lf.addToLine("Nv. PV TTC 5 (EUR)");
		lf.addToLine("Anc. Marge 1 (%)");
		lf.addToLine("Nv. Marge 1 (%)");
		lf.addToLine("Anc. Marge 2 (%)");
		lf.addToLine("Nv. Marge 2 (%)");
		lf.addToLine("Anc. Marge 3 (%)");
		lf.addToLine("Nv. Marge 3 (%)");
		lf.addToLine("Anc. Marge 4 (%)");
		lf.addToLine("Nv. Marge 4 (%)");
		lf.addToLine("Anc. Marge 5 (%)");
		lf.addToLine("Nv. Marge 5 (%)");

		int nbLignes = dmt.getNbLignes();

		for (int i=0; i<nbLignes; i++) {
			LigneArticle la = dmt.lignesTarifs.get(i);

			lf.newLine();
			lf.addToLine("\""+la.refArticle+"\"");
			lf.addToLine(("" + la.ancPrixAchat).replaceAll("\\.", ","));
			lf.addToLine(("" + la.nvPrixAchat).replaceAll("\\.", ","));
			lf.addToLine(("" + la.ancCoeff1).replaceAll("\\.", ","));
			lf.addToLine(("" + la.nvCoeff1).replaceAll("\\.", ","));
			lf.addToLine(("" + la.ancCoeff2).replaceAll("\\.", ","));
			lf.addToLine(("" + la.nvCoeff2).replaceAll("\\.", ","));
			lf.addToLine(("" + la.ancCoeff3).replaceAll("\\.", ","));
			lf.addToLine(("" + la.nvCoeff3).replaceAll("\\.", ","));
			lf.addToLine(("" + la.ancCoeff4).replaceAll("\\.", ","));
			lf.addToLine(("" + la.nvCoeff4).replaceAll("\\.", ","));
			lf.addToLine(("" + la.ancCoeff5).replaceAll("\\.", ","));
			lf.addToLine(("" + la.nvCoeff5).replaceAll("\\.", ","));
			lf.addToLine(("" + la.ancTarifHT1).replaceAll("\\.", ","));
			lf.addToLine(("" + la.nvTarifHT1).replaceAll("\\.", ","));
			lf.addToLine(("" + la.ancTarifHT2).replaceAll("\\.", ","));
			lf.addToLine(("" + la.nvTarifHT2).replaceAll("\\.", ","));
			lf.addToLine(("" + la.ancTarifHT3).replaceAll("\\.", ","));
			lf.addToLine(("" + la.nvTarifHT3).replaceAll("\\.", ","));
			lf.addToLine(("" + la.ancTarifHT4).replaceAll("\\.", ","));
			lf.addToLine(("" + la.nvTarifHT4).replaceAll("\\.", ","));
			lf.addToLine(("" + la.ancTarifHT5).replaceAll("\\.", ","));
			lf.addToLine(("" + la.nvTarifHT5).replaceAll("\\.", ","));
			lf.addToLine(("" + la.tauxTVA).replaceAll("\\.", ","));
			lf.addToLine(("" + la.ancTarifTTC1).replaceAll("\\.", ","));
			lf.addToLine(("" + la.nvTarifTTC1).replaceAll("\\.", ","));
			lf.addToLine(("" + la.ancTarifTTC2).replaceAll("\\.", ","));
			lf.addToLine(("" + la.nvTarifTTC2).replaceAll("\\.", ","));
			lf.addToLine(("" + la.ancTarifTTC3).replaceAll("\\.", ","));
			lf.addToLine(("" + la.nvTarifTTC3).replaceAll("\\.", ","));
			lf.addToLine(("" + la.ancTarifTTC4).replaceAll("\\.", ","));
			lf.addToLine(("" + la.nvTarifTTC4).replaceAll("\\.", ","));
			lf.addToLine(("" + la.ancTarifTTC5).replaceAll("\\.", ","));
			lf.addToLine(("" + la.nvTarifTTC5).replaceAll("\\.", ","));
			lf.addToLine(("" + la.ancMarge1).replaceAll("\\.", ","));
			lf.addToLine(("" + la.nvMarge1).replaceAll("\\.", ","));
			lf.addToLine(("" + la.ancMarge2).replaceAll("\\.", ","));
			lf.addToLine(("" + la.nvMarge2).replaceAll("\\.", ","));
			lf.addToLine(("" + la.ancMarge3).replaceAll("\\.", ","));
			lf.addToLine(("" + la.nvMarge3).replaceAll("\\.", ","));
			lf.addToLine(("" + la.ancMarge4).replaceAll("\\.", ","));
			lf.addToLine(("" + la.nvMarge4).replaceAll("\\.", ","));
			lf.addToLine(("" + la.ancMarge5).replaceAll("\\.", ","));
			lf.addToLine(("" + la.nvMarge5).replaceAll("\\.", ","));
		}
		
		// On dite les tarifs spcifiques, uniquement si il y en a
		int nbLignesTarifsSpec = dmt.getNbLignesTarifsSpec();
		if (nbLignesTarifsSpec>0) {
			// Saut de ligne
			lf.newLine();
			lf.newLine();
			lf.addToLine("R\u00E9f. Client");
			lf.addToLine("Raison Sociale");
			lf.addToLine("R\u00E9f. Article");
			lf.addToLine("Anc. Prix Achat (EUR)");
			lf.addToLine("Nv. Prix Achat (EUR)");
			lf.addToLine("Anc. % du PV");
			lf.addToLine("Nv. % du PV");
			lf.addToLine("Anc. Prix HT (EUR)");
			lf.addToLine("Nv. Prix HT (EUR)");
			lf.addToLine("Taux TVA (%)");
			lf.addToLine("Anc. Prix TTC (EUR)");
			lf.addToLine("Nv. Prix TTC (EUR)");
			lf.addToLine("Anc. Marge (%)");
			lf.addToLine("Nv. Marge (%)");
			
			
			for (int i=0; i<nbLignesTarifsSpec; i++) {
				LigneTarifSpecifique lts = dmt.lignesTarifsSpecifiques.get(i);
				
				double ancPourc = (lts.ancCoeff>=1?(lts.ancCoeff-1)*100:(1-lts.ancCoeff)*(-100));
				double nvPourc = (lts.nvCoeff>=1?(lts.nvCoeff-1)*100:(1-lts.nvCoeff)*(-100));
				
				lf.newLine();
				lf.addToLine("\""+lts.refClient+"\"");
				lf.addToLine("\""+lts.raisonSociale+"\"");
				lf.addToLine("\""+lts.refArticle+"\"");
				lf.addToLine(("" + lts.ancPrixAchat).replaceAll("\\.", ","));
				lf.addToLine(("" + lts.nvPrixAchat).replaceAll("\\.", ","));
				lf.addToLine(("" + ancPourc).replaceAll("\\.", ","));
				lf.addToLine(("" + nvPourc).replaceAll("\\.", ","));
				lf.addToLine(("" + lts.ancPrixHT).replaceAll("\\.", ","));
				lf.addToLine(("" + lts.nvPrixHT).replaceAll("\\.", ","));
				lf.addToLine(("" + lts.tauxTVA).replaceAll("\\.", ","));
				lf.addToLine(("" + lts.ancPrixTTC).replaceAll("\\.", ","));
				lf.addToLine(("" + lts.nvPrixTTC).replaceAll("\\.", ","));
				lf.addToLine(("" + lts.ancMarge).replaceAll("\\.", ","));
				lf.addToLine(("" + lts.nvMarge).replaceAll("\\.", ","));
			}
		}

		lf.write(buffer, fichier, true);
	}



} // fin CsvMajTarifs
