/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Donnes ncessaires  l'dition des tarifs mis  jour
 */

package org.opensi.facturation.actions.majtarifs;


import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

import org.experlog.openeas.api.Session;
import org.opensi.facturation.DocumentUtils;


public class DataMajTarifs {


	// les lignes de la mise  jour des tarifs
	protected ArrayList<LigneArticle> lignesTarifs = new ArrayList<LigneArticle>(10);
	protected ArrayList<LigneTarifSpecifique> lignesTarifsSpecifiques = new ArrayList<LigneTarifSpecifique>(10);
	
	protected String dateCourante;

	protected String dossierId = "";
	protected String raisonSociale = "";
	protected String adresse1 = "";
	protected String adresse2 = "";
	protected String adresse3 = "";
	protected String codePostal = "";
	protected String ville = "";
	
	protected double capital;
	protected String typeSociete;
	protected String tvaIntra;
	protected String rcs;
	protected String siren;

	protected int element;
	protected boolean repercution;
	
	public DataMajTarifs(Session s, MajTarifs mt) {
		try {
			
			dossierId = s.getCookie().get("Dossier_Id");
			String base = s.getCookie().get("BaseDossier");
			
			this.lignesTarifs = mt.lignesTarifs;
			this.lignesTarifsSpecifiques = mt.lignesTarifsSpecifiques;
			this.element = mt.element;
			this.repercution = mt.repercution;
			
			SimpleDateFormat formatDate = new SimpleDateFormat("dd/MM/yyyy");
			this.dateCourante = formatDate.format(new Date(System.currentTimeMillis()));
		
			Connection con = s.getConnection(null);
			Statement stt = con.createStatement();

			String reqLeDossier = "select s.Denomination, s.Adresse_1, s.Adresse_2, s.Adresse_3, s.Code_Postal, s.Ville, s.Num_SIRET, s.Montant_Capital, s.Num_TVA_Intra, s.Ville_RCS, ts.Libelle as Type_Societe";
			reqLeDossier += " from "+ base +".SOCIETE s join "+ base +".TYPE_SOCIETE ts on s.Type_Societe=ts.Type_Societe_Id";
			ResultSet rset = stt.executeQuery(reqLeDossier);
			if (rset.next()) {
				this.raisonSociale = rset.getString("Denomination");
				this.adresse1 = rset.getString("Adresse_1");
				this.adresse2 = rset.getString("Adresse_2");
				this.adresse3 = rset.getString("Adresse_3");
				this.codePostal = rset.getString("Code_Postal");
				this.ville = rset.getString("Ville");
				this.siren = DocumentUtils.formatSiren(rset.getString("Num_SIRET"));
				this.typeSociete = rset.getString("Type_Societe");
				this.capital = rset.getDouble("Montant_Capital");
				this.tvaIntra = rset.getString("Num_TVA_Intra");
				this.rcs = rset.getString("Ville_RCS");
			}
			rset.close();
			
			stt.close();			
			s.closeConnection(con, null);
			
		} catch(Exception e) {
			e.printStackTrace();
		}	
	}
	
	
	public int getNbLignes() {
		return lignesTarifs.size();
	}
	
	public int getNbLignesTarifsSpec() {
		return lignesTarifsSpecifiques.size();
	}
	
	
} // fin DataMajTarifs
