/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 * Edition des mises  jour de tarifs
 */

package org.opensi.facturation.actions.majtarifs;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.util.pdf.GlobalDocument;

public class GenMajTarifs extends Action {

	public boolean serverSide() { return true; }
	
	public boolean service(Session s, ServletRequest r, Object info) throws Exception {
		
		String fichierPdf = r.getParameter("FichierPdf") != null ? r.getParameter("FichierPdf") : "";
		String fichierCsv = r.getParameter("FichierCsv") != null ? r.getParameter("FichierCsv") : "";
		String absdir = s.getAppConfiguration().get("opensi.absdir");

		int element = Integer.parseInt(r.getParameter("Element"));
		
		// Prix de Vente, Coeff, Marge
		String pourcPVT1 = r.getParameter("Pourc_PV_T1");
		String pourcPVT2 = r.getParameter("Pourc_PV_T2");
		String pourcPVT3 = r.getParameter("Pourc_PV_T3");
		String pourcPVT4 = r.getParameter("Pourc_PV_T4");
		String pourcPVT5 = r.getParameter("Pourc_PV_T5");
		String pourcPVTS = r.getParameter("Pourc_PV_TS");
		String eurPVT1 = r.getParameter("Eur_PV_T1");
		String eurPVT2 = r.getParameter("Eur_PV_T2");
		String eurPVT3 = r.getParameter("Eur_PV_T3");
		String eurPVT4 = r.getParameter("Eur_PV_T4");
		String eurPVT5 = r.getParameter("Eur_PV_T5");
		String coeffT1 = r.getParameter("Coeff_T1");
		String coeffT2 = r.getParameter("Coeff_T2");
		String coeffT3 = r.getParameter("Coeff_T3");
		String coeffT4 = r.getParameter("Coeff_T4");
		String coeffT5 = r.getParameter("Coeff_T5");
		String margeT1 = r.getParameter("Marge_T1");
		String margeT2 = r.getParameter("Marge_T2");
		String margeT3 = r.getParameter("Marge_T3");
		String margeT4 = r.getParameter("Marge_T4");
		String margeT5 = r.getParameter("Marge_T5");
		
		// Prix d'Achat
		boolean repercution = (r.getParameter("Repercution").equals("true"));
		int typeRepercution = Integer.parseInt(r.getParameter("Type_Repercution"));
		boolean chkTarifsSpec = (r.getParameter("Tarif_Spec").equals("true"));
		int typeRepercutionSpec = Integer.parseInt(r.getParameter("Type_Repercution_Spec"));
		int modeCalcul = Integer.parseInt(r.getParameter("Mode_Calcul"));
		String valeur = r.getParameter("Valeur");
		
		// Filtre
		int critere = Integer.parseInt(r.getParameter("Critere"));
		String refArticle = r.getParameter("Ref_Article");
		int famille1 = Integer.parseInt(r.getParameter("Famille_1"));
		int famille2 = Integer.parseInt(r.getParameter("Famille_2"));
		int famille3 = Integer.parseInt(r.getParameter("Famille_3"));
		int marque = Integer.parseInt(r.getParameter("Marque"));
		String fournisseur = r.getParameter("Fournisseur");
		
		MajTarifs mt = new MajTarifs(s, element, pourcPVT1, pourcPVT2, pourcPVT3, pourcPVT4, pourcPVT5, pourcPVTS,
									eurPVT1, eurPVT2, eurPVT3, eurPVT4, eurPVT5, coeffT1, coeffT2, coeffT3, coeffT4, coeffT5,
									margeT1, margeT2, margeT3, margeT4, margeT5, repercution, typeRepercution, chkTarifsSpec, typeRepercutionSpec, modeCalcul, valeur,
									critere, refArticle, famille1, famille2, famille3, marque, fournisseur, false, true, -1);
		DataMajTarifs dmt = new DataMajTarifs(s, mt);
		
		if (!fichierPdf.equals("")) {
			// Cration d'un PDF
			String repPdf = absdir +"/pdf/";
			String repTemp = repPdf;
			
			GlobalDocument gd = new GlobalDocument(repPdf, fichierPdf);
			
			PdfMajTarifs pdfMajTarifs = new PdfMajTarifs(repTemp, dmt);
			gd.addInternal(pdfMajTarifs);
			
			if (dmt.getNbLignesTarifsSpec()>0) {
				PdfMajTarifsSpec pdfMajTarifsSpec = new PdfMajTarifsSpec(repTemp, dmt);
				gd.addInternal(pdfMajTarifsSpec);
			}
			
			gd.close(GlobalDocument.ON_EXIT);
		} else if (!fichierCsv.equals("")) {
			// Cration d'un CSV
			String buffer = absdir +"/iobuffer/";
			new CsvMajTarifs(buffer, fichierCsv, dmt);
		}
		
		return true;
	}

} // fin GenMajTarifs
