/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.facturation.actions.transcompta;

import java.sql.*;

import org.opensi.data.exercice.Ecriture;
import org.opensi.data.exercice.Operation;
import org.opensi.api.SessionOSI;

import org.opensi.util.sql.SqlUtils;


public class TransfertReglementsClient extends TransfertCompta {

	private String codeJournal;
	private String listeId;
	private String compteClientsDivers;
	private int lastRemiseId = 0;

	private PreparedStatement psCpteClient;
	private PreparedStatement psCpteJournal;
	private PreparedStatement psMarqueRegl;


	public TransfertReglementsClient(SessionOSI sosi, String codeJournal, String listeId) throws Exception {

		super(sosi);
		this.codeJournal = codeJournal;
		this.listeId = (listeId.length()==0?"-1":SqlUtils.normalizeCSList(listeId));
	}


	public void transfert() throws Exception {

		Statement stt = con.createStatement();

		ResultSet rset = stt.executeQuery("select Numero_Compte_Clients, Ecr_Glob_Rem from "+ baseDossier +".PARAM_DOSSIER");
		rset.next();

		compteClientsDivers = rset.getString("Numero_Compte_Clients");
		boolean ecrGroupe = rset.getBoolean("Ecr_Glob_Rem");

		psCpteClient = con.prepareStatement("select c.Numero_Compte from "+ baseDossier +".FICHE_CLIENT e,"+ baseDossier +".COMPTE c where e.Client_Id=? and e.Numero_Compte=c.Numero_Compte");
		psCpteJournal = con.prepareStatement("select Contrepartie from "+ baseDossier +".JOURNAL where Code_Journal=?");
		psMarqueRegl = con.prepareStatement("update "+ baseDossier +".REMISE_BANQUE set Comptabilise=1 where Remise_Id=?");


		rset = stt.executeQuery("select rc.*, rb.Remise_Id, rb.Date_Remise, coalesce(m.Code_Journal,'') as Journal_Enc, b.Code_Journal as Journal_Rem from "+ baseDossier +".REGLEMENT_CLIENT rc"
														+" join "+ baseDossier +".REMISE_REGLEMENT_CLIENT rrc on rc.Reglement_Id=rrc.Reglement_Id"
														+" join "+ baseDossier +".REMISE_BANQUE rb on rb.Remise_Id=rrc.Remise_Id"
														+" join "+ baseDossier +".MODE_REGLEMENT m on rc.Mode_Reg_Id=m.Mode_Reg_Id"
														+" join "+ baseDossier +".BANQUE b on rb.Banque_Remise=b.Banque_Id"
														+" where rb.Montant>0 and rb.Comptabilise=0 and rb.Remise_Id in ("+ listeId +") order by rc.Date_Reg");

		while (rset.next()) {

			long dateRemise = rset.getLong("Date_Remise");
			int remiseId = rset.getInt("Remise_Id");
			String clientId = rset.getString("Client_Id");
			String numPiece = rset.getString("Num_Piece");
			double montant = rset.getDouble("Montant");
			boolean comptaEnc = rset.getInt("Compta_Enc")==1;
			String journalEnc = rset.getString("Journal_Enc");
			String journalRem = codeJournal.isEmpty()?rset.getString("Journal_Rem"):codeJournal;
			int modeRegId = rset.getInt("Mode_Reg_Id");
			
			Ecriture ecriture = new Ecriture();
			ecriture.setCodeJournal(journalRem);
			ecriture.setDateEcriture(dateRemise);

			Operation op = new Operation();

			if (comptaEnc) {

				String compteEnc = getContrepartieJournal(journalEnc);			

				op.setNumeroCompte(compteEnc);
				op.setLibelle(getIntitule(compteEnc));
			}
			else {
				String compteClient = getCompteClient(clientId);					

				op.setModeRegId(modeRegId);
				op.setNumeroCompte(compteClient);
				op.setLibelle(getIntitule(compteClient));					
			}

			op.setDateOp(dateRemise);
			op.setNumPiece(numPiece);
			op.setMontantC(montant);
			ecriture.addOperation(op);

			String compteBanque = getContrepartieJournal(journalRem);

			op = new Operation();
			op.setDateOp(dateRemise);
			op.setNumPiece(numPiece);
			op.setNumeroCompte(compteBanque);
			op.setLibelle(getIntitule(compteBanque));
			op.setMontantD(montant);

			ecriture.addOperation(op);

			validerEcriture(ecriture, remiseId, dateRemise);
		}
	}


	protected void marquerDocument(int remiseId) throws SQLException {

		if (lastRemiseId != remiseId) {
			psMarqueRegl.setInt(1, remiseId);
			psMarqueRegl.executeUpdate();
			
			lastRemiseId = remiseId;
		}
	}


	private String getCompteClient(String clientId) throws SQLException {

		if (clientId==null || clientId.equals("")) {
			return compteClientsDivers;
		}
		else {
			psCpteClient.setString(1, clientId);
			ResultSet rset = psCpteClient.executeQuery();

			if (rset.next()) {
				return rset.getString("Numero_Compte");
			}
			else {
				return compteClientsDivers;
			}
		}
	}

	private String getContrepartieJournal(String codeJournal) throws SQLException {
		if (codeJournal.equals("")) {
			return "";
		}
		else {
			psCpteJournal.setString(1, codeJournal);
			ResultSet rset = psCpteJournal.executeQuery();
			if (rset.next()) {
				return rset.getString("Contrepartie");
			}
			else {
				return "";
			}
		}
	}


} // fin TransfertReglementsClient
