/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/


package org.opensi.util.calcul;


public class CalculVentilTVACommissionV2 extends CalculVentilTVACommission {


	public void add(double montantBase,double pRemise, boolean ttc) {
		baseMontantC +=montantBase;
		
		if (ttc) {
			this.baseTTCbC  = r2.round(baseMontantC);
			this.mRemisebC = r2.round(baseTTCbC * (pRemise/100));
			this.baseTTCNC= r2.round(baseTTCbC - mRemisebC);
			this.montantTVAC = r2.round(baseTTCbC * ((tauxTVA/100) / (tauxTVA/100+1)));
			this.baseHTnC = r2.round(baseTTCNC - montantTVAC);
		}
		else {
			this.baseHTbC  = r2.round(baseMontantC);
			this.mRemisebC = r2.round(baseHTbC * (pRemise/100));
			this.baseHTnC = r2.round(baseHTbC - mRemisebC);
			this.montantTVAC = r2.round(baseHTnC * (tauxTVA/100));
			this.baseTTCNC = r2.round(baseHTnC + montantTVAC);
			
		} 
	}		
} // fin VentilTVA



