/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

package org.opensi.util.tools;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;


public class Arrondi {


	private DecimalFormat numFormat;


	public Arrondi(int nbDecimales) {

		String pattern = "0";

		if (nbDecimales>0) {
			pattern += ".0";
			for (int i=1; i<nbDecimales; i++)
				pattern += "0";
		}

		numFormat = new DecimalFormat(pattern);
		numFormat.setRoundingMode(RoundingMode.HALF_UP);

		DecimalFormatSymbols dfs = new DecimalFormatSymbols();
		dfs.setDecimalSeparator('.');
		numFormat.setDecimalFormatSymbols(dfs);
	}

	public double round(double val) {

		return Double.valueOf(numFormat.format(val)).doubleValue();
	}

	public void setRoundingMode(RoundingMode roundingMode) {
	
		numFormat.setRoundingMode(roundingMode);
	}

} // fin Arrondi
