/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 *  Rcupration des articles existants sur un site web
 */

package org.opensi.webmanager.init_vente;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Vector;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.webmanager.utils.AppelServices;

/**
 * Lance la rcupration des commandes immdiatement.
 */
public class ActionUploadArticles extends Action {
	boolean recupReussie = true;


	Vector<Object> lesIds;

	Connection con;

	String base;

	public boolean serverSide() {
		return true;
	}

	/**
	 * 
	 * @param s
	 * @param r
	 * @param info
	 * @throws java.lang.Exception
	 */
	public boolean service(Session s, ServletRequest r, Object info) throws Exception {
		base = r.getParameter("base");
		String site_id = r.getParameter("site_id");
		String dossierRoot = s.getAppConfiguration().get("opensi.absdir");
		String dossier = s.getCookie().get("Dossier_Id");

		con = s.getConnection(null);
		Statement state = con.createStatement();

		String requeteParamServeur = "SELECT URL_Service ";
		requeteParamServeur += " FROM " + base + ".SITE_WEB WHERE Site_Id='" + site_id + "'";

		ResultSet resultSet = state.executeQuery(requeteParamServeur);

		String url_serveur = "";
		lesIds = new Vector<Object>();

		boolean recupReussie = true;
		if (resultSet.next()) {
			url_serveur = resultSet.getString("URL_Service");

			preparerSite(url_serveur);

			UploadArticles upload = new UploadArticles(dossierRoot, dossier);
			recupReussie = upload.lancerUpload(con, base, url_serveur, site_id);

		}

		s.closeConnection(con, null);

		if (recupReussie) {
			r.addParameter("reussite", "OUI");
		}
		else {
			r.addParameter("reussite", "NON");
		}

		return true;

	}

	private void preparerSite(String url_serveur) {

		Object result = AppelServices.preparerSite(url_serveur);

		try {

			Object[] rep = (Object[]) result;

			Object[] rapport = (Object[]) rep[0];

			for (int i = 0; i < rapport.length; i++) {

				Object[] contenu = (Object[]) rapport[i];

				if (Integer.parseInt("" + contenu[0]) > 100) {
					recupReussie = false;
				}

			}

		}
		catch (Exception e) {
			recupReussie = false;
			System.out.println("[ActionUploadArticles] ERREUR " + e);
		}

	}

}
