/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 *  Requetes multiples d'insertion ou de suppression d'articles web.
 */

package org.opensi.webmanager.init_vente;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;

/**
 * Modifie le prix d'achat des articles temp
 */
public class ModifPATempGroupe extends Action {

	/**
	 * 
	 * @return
	 */
	public boolean serverSide() {
		return true;
	}

	/**
	 * 
	 * @param s
	 * @param r
	 * @param info
	 * @throws java.lang.Exception
	 * @return
	 */
	public boolean service(Session s, ServletRequest r, Object info) throws Exception {

		String famille1 = r.getParameter("famille1");
		String famille2 = r.getParameter("famille2");
		String marque = r.getParameter("marque");
		String reference = r.getParameter("reference");
		String designation = r.getParameter("designation");
		String valeur = r.getParameter("valeur");

		String base = r.getParameter("base");
		String site_id = r.getParameter("site_id");

		Connection con = s.getConnection(null);
		// Constitution de la liste des articles auquels il faut affecter un
		// prix
		// Selon le mode de calcul, on n'as pas besoin des memes infos

		String condWhere = "";


		// On regarde les filtres  appliquer  la requete
		if (!marque.equals("0")) {
			condWhere += " AND Marque_Id=" + marque;
		}

		if (!famille2.equals("0")) {
			condWhere += " AND Famille_2=" + famille2;
		}

		if (!famille1.equals("0")) {
			condWhere += " AND Famille_1=" + famille1;
		}

		if (!reference.equals("")) {
			condWhere += " AND Article_Id LIKE '%" + reference + "%'";
		}

		if (!designation.equals("[toutes]")) {
			condWhere += " AND Designation LIKE '%" + designation + "%'";
		}

		String requeteListe = "SELECT Article_Id, Prix_Vente";
		requeteListe += " FROM " + base + ".FICHE_ARTICLE_TEMP ";
		requeteListe += " WHERE Site_Id=" + site_id;
		requeteListe += condWhere;

		// Preparation de la requete multiple
		String reqMultiple = "UPDATE " + base + ".FICHE_ARTICLE_TEMP SET Prix_Achat=?";
		reqMultiple += " WHERE Article_Id=? AND Site_Id=" + site_id;

		Statement state = con.createStatement();
		PreparedStatement ps = con.prepareStatement(reqMultiple);

		ResultSet resultSet = state.executeQuery(requeteListe);

		while (resultSet.next()) {
			double PV = resultSet.getDouble("Prix_Vente");

			double prixAchat = calculPrix(PV, Double.parseDouble(valeur));

			ps.setDouble(1, prixAchat);
			ps.setString(2, resultSet.getString("Article_Id"));
			ps.addBatch();

		}
		ps.executeBatch();

		s.closeConnection(con, null);

		return true;

	}

	/**
	 * Calcule le prix d'achat en fonction du prix de vente et de la valeur donne
	 * 
	 * @param PV
	 *          prix de vente
	 * @param valeurIndicateur
	 *          valeur de l'indicateur
	 * @return le prix d'achat
	 */
	public double calculPrix(double PV, double valeurIndicateur) {
		return PV / valeurIndicateur;
	}

}
