/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 *  Test de la connexion au web service
 */

package org.opensi.webmanager.init_vente;

import org.opensi.webmanager.utils.AppelServices;
import org.opensi.webmanager.utils.TraitementRapport;

/**
 * Lance la procdure de test initiale.
 */
public class TestConnexion {

	TraitementRapport traitement;

	String erreur = "";

	boolean yaEuErreur;

	/**
	 * Prpare le lancement du test.
	 * 
	 * @param url_site
	 *          url du web service.
	 */
	public TestConnexion(String url_site) {

		// Paramtres de la connexion au web service

		yaEuErreur = false;
		Object result = new String("rien");

		if (url_site == null) {
			erreur += "Un param est null";
		}
		else {

			result = AppelServices.testInitiaux(url_site);
				System.out.println("resultat : "+result);

			try {
				System.out.println("ERREURaffich : "+result);
				Object[] rep = (Object[]) result; // valeur
				System.out.println("ERREURaffich2 : "+rep);
				Object[] rapport = (Object[]) rep[0];// rapport
				System.out.println("ERREURaffich3 : "+rapport);

				traitement = new TraitementRapport(rapport);

			}
			catch (Exception e) {
				erreur += " Erreur inconnue 3" + e;
				System.out.println("ERREUR"+erreur+" " + e);
				yaEuErreur = true;
			}

		}

	}

	// return true si echec, false, sinon
	/**
	 * Permet de savoir si tout s'est bien pass ou non.
	 * 
	 * @return vrai si il y a eu des echecs, faut sinon.
	 */
	public boolean getEchecConnexion() {
	System.out.println("verifERREUR "+yaEuErreur);
		return yaEuErreur;
	}

	/**
	 * Permet de savoir si la ligne de rapport rapporte une russite ou un echec.
	 * 
	 * @param i
	 *          index de la ligne du rapport
	 * @return vrai si la ligne rapport une russite, faux si la ligne rapporte un
	 *         echec.
	 */
	public boolean getReussite(int i) {
		return traitement.aReussi(i);
	}

	/**
	 * Donne le message "humainement comprhensible".
	 * 
	 * @param i
	 *          ligne de rapport concerne
	 * @return Le message a destination de l'utilisateur
	 */
	public String getMessage(int i) {
		return traitement.getMessageUtilisateur(i);
	}

	/**
	 * Donne la taille en nombre de ligne du rapport.
	 * 
	 * @return le nombre de lignes du rapport.
	 */
	public int getTailleRapport() {
		return traitement.getTaille();

	}

	/**
	 * Donne une erreur ventuelle survenur lors de la procdure de test.
	 * 
	 * @return Les erreurs ventuelles.
	 */
	public String getErreur() {
		return erreur;
	}

}
