package org.opensi.webmanager.utils;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

/**
 * Recalcule les caractrisques des articles web donc la fiche article a chang
 * depuis le dernier calcul.
 */
public class CalculCaracsWeb {

	/*
	 * Recalcule les prix des articles qui ont t modifis depuis la date
	 * enregistr dans la FICHE_ARTICLE_WEB. Les prix sont recalculs en utilisant
	 * Calcul_Prix et Valeur_Prix et les valeurs de FICHE_ARTICLE
	 * 
	 */
	/**
	 * Recalcule les prix web des articles dont le prix de la fiche article a t
	 * modifi depuis la dernire mise  jour.
	 * 
	 * @param c
	 *          Connexion a la BD
	 * @param base
	 *          nom de la base (FACT_qquechose)
	 * @param id_site
	 *          identifiant du site
	 * @throws java.sql.SQLException
	 *           une erreur eventuelle
	 */
	public static void calculPrix(Connection c, String base, String id_site) throws SQLException {
		System.out.println("[CalculCaracsWeb] calculprix, base:" + base + ", id_site:" + id_site);

		// Ceux dont PVweb est fixe: rien a faire sauf changer la date de ref
		String reqMultiple = "UPDATE " + base + ".FICHE_ARTICLE_WEB w," + base + ".FICHE_ARTICLE a SET w.Date_Prix_Ref=a.Date_M";
		reqMultiple += " WHERE w.Article_Id=a.Article_Id AND Site_Id=" + id_site + " AND w.Calcul_Prix='F' AND a.Date_M>w.Date_Prix_Ref";
		Statement state = c.createStatement();

		state.executeUpdate(reqMultiple);

		// Ceux calculs a partir de la marge
		String calculMarge = "a.Prix_Achat+w.Valeur_Prix";
		reqMultiple = "UPDATE " + base + ".FICHE_ARTICLE_WEB w," + base + ".FICHE_ARTICLE a SET w.Date_Prix_Ref=a.Date_M";
		reqMultiple += ", w.Prix_Web=" + calculMarge + ", w.Prix_Modifie=1 ";
		reqMultiple += " WHERE w.Article_Id=a.Article_Id AND Site_Id=" + id_site + " AND w.Calcul_Prix='M'  AND a.Date_M>w.Date_Prix_Ref";

		state.executeUpdate(reqMultiple);

		// Ceux calculs a partir de la marge%
		String calculMargeP = "a.Prix_Achat*(100/(100-w.Valeur_Prix))";
		reqMultiple = "UPDATE " + base + ".FICHE_ARTICLE_WEB w," + base + ".FICHE_ARTICLE a SET w.Date_Prix_Ref=a.Date_M";
		reqMultiple += ", w.Prix_Web=" + calculMargeP + ", w.Prix_Modifie=1 ";
		reqMultiple += " WHERE w.Article_Id=a.Article_Id AND Site_Id=" + id_site + " AND w.Calcul_Prix='MP'  AND a.Date_M>w.Date_Prix_Ref";

		state.executeUpdate(reqMultiple);

		// Ceux calculs a partir du PV
		String calculPV = "a.Tarif_1*w.Valeur_Prix";
		reqMultiple = "UPDATE " + base + ".FICHE_ARTICLE_WEB w," + base + ".FICHE_ARTICLE a SET w.Date_Prix_Ref=a.Date_M";
		reqMultiple += ", w.Prix_Web=" + calculPV + ", w.Prix_Modifie=1 ";
		reqMultiple += " WHERE w.Article_Id=a.Article_Id AND Site_Id=" + id_site + " AND w.Calcul_Prix='PV'  AND a.Date_M>w.Date_Prix_Ref";

		state.executeUpdate(reqMultiple);

		// Ceux calculs a partir du PA
		String calculPA = "a.Prix_Achat*w.Valeur_Prix";
		reqMultiple = "UPDATE " + base + ".FICHE_ARTICLE_WEB w," + base + ".FICHE_ARTICLE a SET w.Date_Prix_Ref=a.Date_M";
		reqMultiple += ", w.Prix_Web=" + calculPA + ", w.Prix_Modifie=1 ";
		reqMultiple += " WHERE w.Article_Id=a.Article_Id AND Site_Id=" + id_site + " AND w.Calcul_Prix='PA'  AND a.Date_M>w.Date_Prix_Ref";

		state.executeUpdate(reqMultiple);

		System.out.println("[CalculCaracsWeb] -fin-");

	}

	/**
	 * Recalcule les stock des articles qui ont t modifis depuis la date
	 * enregistr dans la FICHE_ARTICLE_WEB. Les prix sont recalculs en utilisant
	 * Calcul_Stock et Valeur_Stock et les valeurs de STOCK_ARTICLE
	 * 
	 * 
	 * @param c
	 *          Connexion a la BD
	 * @param base
	 *          nom de la base (FACT_qquechose)
	 * @param id_site
	 *          identifiant du site
	 * @throws java.sql.SQLException
	 *           une erreur eventuelle
	 */
	public static void calculStock(Connection c, String base, String id_site) throws SQLException {
		System.out.println("[CalculCaracsWeb] calcul stock, base:" + base + ", id_site:" + id_site);

		String calculTampon = "(Stock_Init+Entrees-Sorties)+Valeur_Stock";
		String calculPourcent = "((Stock_Init+Entrees-Sorties)*Valeur_Stock)/100";

		// Preparation de la requete multiple
		String reqMultiple = "UPDATE " + base + ".FICHE_ARTICLE_WEB w, ";
		reqMultiple += " " + base + ".STOCKS_ARTICLE s, " + base + ".FICHE_ARTICLE a ";
		reqMultiple += " SET w.Stock_Web=" + calculTampon;
		reqMultiple += " ,w.Date_Stock_Ref=";
		reqMultiple += " (";
		reqMultiple += " 	SELECT MAX(Date_Mvt)";
		reqMultiple += " 	FROM " + base + ".STOCKS_ARTICLE s1 LEFT JOIN " + base + ".MVT_STOCK m ON m.Article_Id=s1.Article_Id ";
		reqMultiple += " 	WHERE s1.Article_Id=a.Article_Id";
		reqMultiple += " 	GROUP BY (s1.Article_Id)";
		reqMultiple += " )";
		reqMultiple += ",w.Stock_Modifie=1";
		reqMultiple += " WHERE w.Calcul_Stock='T' AND s.Article_Id=w.Article_Id AND w.Article_Id=a.Article_Id AND w.Site_Id=" + id_site;
		reqMultiple += " AND Date_Stock_Ref<";
		reqMultiple += " (";
		reqMultiple += " 	SELECT MAX(Date_Mvt)";
		reqMultiple += " 	FROM " + base + ".STOCKS_ARTICLE s2 LEFT JOIN " + base + ".MVT_STOCK m2 ON m2.Article_Id=s2.Article_Id ";
		reqMultiple += " 	WHERE s2.Article_Id=a.Article_Id";
		reqMultiple += " 	GROUP BY (s2.Article_Id)";
		reqMultiple += " )";

		Statement state = c.createStatement();
		state.executeUpdate(reqMultiple);

		// Preparation de la requete multiple
		reqMultiple = "UPDATE " + base + ".FICHE_ARTICLE_WEB w, ";
		reqMultiple += " " + base + ".STOCKS_ARTICLE s, " + base + ".FICHE_ARTICLE a ";
		reqMultiple += " SET w.Stock_Web=" + calculPourcent;
		reqMultiple += " ,w.Date_Stock_Ref=";
		reqMultiple += " (";
		reqMultiple += " 	SELECT MAX(Date_Mvt)";
		reqMultiple += " 	FROM " + base + ".STOCKS_ARTICLE s1 LEFT JOIN " + base + ".MVT_STOCK m ON m.Article_Id=s1.Article_Id ";
		reqMultiple += " 	WHERE s1.Article_Id=a.Article_Id";
		reqMultiple += " 	GROUP BY (s1.Article_Id)";
		reqMultiple += " )";
		reqMultiple += ",w.Stock_Modifie=1";
		reqMultiple += " WHERE w.Calcul_Stock='P' AND s.Article_Id=w.Article_Id AND w.Article_Id=a.Article_Id AND w.Site_Id=" + id_site;
		reqMultiple += " AND Date_Stock_Ref<";
		reqMultiple += " (";
		reqMultiple += " 	SELECT MAX(Date_Mvt)";
		reqMultiple += " 	FROM " + base + ".STOCKS_ARTICLE s2 LEFT JOIN " + base + ".MVT_STOCK m2 ON m2.Article_Id=s2.Article_Id ";
		reqMultiple += " 	WHERE s2.Article_Id=a.Article_Id";
		reqMultiple += " 	GROUP BY (s2.Article_Id)";
		reqMultiple += " )";

		state.executeUpdate(reqMultiple);

		String requeteReparation = "UPDATE " + base + ".FICHE_ARTICLE_WEB SET Date_Stock_Ref=0 WHERE Date_Stock_Ref IS NULL";

		state.executeUpdate(requeteReparation);

	}

}
