/******************************************************************************/
/* OpenSi : Outils libres de gestion d'entreprise                             */
/* Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   */
/* Contact: contact@opensi.org                                                */
/*                                                                            */
/* This program is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU General Public License                */
/* as published by the Free Software Foundation; either version 2             */
/* of the License, or (at your option) any later version.                     */
/*                                                                            */
/* This program is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               */
/* GNU General Public License for more details.                               */
/*                                                                            */
/* You should have received a copy of the GNU General Public License          */
/* along with this program; if not, write to the Free Software                */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/******************************************************************************/

/**
 *  Traitement des fichiers des photos de produits
 */

package org.opensi.webmanager.utils;

import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

import org.experlog.openeas.api.Action;
import org.experlog.openeas.api.ServletRequest;
import org.experlog.openeas.api.Session;
import org.opensi.util.tools.FileManager;

/**
 * Gre les photos
 */
public class ManagePhotos extends Action {

	/**
	 * 
	 * @return
	 */
	public boolean serverSide() {
		return true;
	}

	/**
	 * 
	 * @param s
	 * @param r
	 * @param info
	 * @throws java.lang.Exception
	 * @return
	 */
	public boolean service(Session s, ServletRequest r, Object info) throws Exception {

		String chemin = s.getAppConfiguration().get("opensi.absdir");
		
		Connection con = s.getConnection(null);
		Statement stt = con.createStatement();

		String fichierImage = r.getParameter("Fichier");
		String dossier = s.getCookie().get("Dossier_Id");
		String famille1 = r.getParameter("famille1");
		String famille2 = r.getParameter("famille2");
		String marque = r.getParameter("marque");

		if (marque.equals("")) {
			if (famille2.equals("")) {
				FileManager.createDirectory(chemin + "/photos_familles/");
				FileManager.createDirectory(chemin + "/photos_familles/" + dossier + "/");

				File source = new File(chemin + "/iobuffer/" + fichierImage);
				File destination = new File(chemin + "/photos_familles/" + dossier + "/" + fichierImage);

				FileManager.copyFile(source, destination);

			}
			else {
				String reqFamille1 = "select Libelle from FACT_"+ dossier +".FAMILLE_ARTICLE where Famille_Id="+famille1;
				ResultSet rset = stt.executeQuery(reqFamille1);
				if (rset.next()) {
					String labFamille1 = rset.getString("Libelle");
					FileManager.createDirectory(chemin + "/photos_familles/");
					FileManager.createDirectory(chemin + "/photos_familles/" + dossier + "/");
					FileManager.createDirectory(chemin + "/photos_familles/" + dossier + "/" + labFamille1 + "/");
	
					File source = new File(chemin + "/iobuffer/" + fichierImage);
					File destination = new File(chemin + "/photos_familles/" + dossier + "/" + labFamille1 + "/" + fichierImage);
	
					FileManager.copyFile(source, destination);
				}
				rset.close();
			}
		}
		else {
			FileManager.createDirectory(chemin + "/photos_marques/");
			FileManager.createDirectory(chemin + "/photos_marques/" + dossier + "/");

			File source = new File(chemin + "/iobuffer/" + fichierImage);
			File destination = new File(chemin + "/photos_marques/" + dossier + "/" + fichierImage);

			FileManager.copyFile(source, destination);

		}
		
		stt.close();
		s.closeConnection(con, null);

		return true;

	}

} // fin ManagePhotos

