package org.opensi.webmanager.utils;

/**
 * 
 * <B>Struct</B>
 */
public class Struct {

	private Object[] liste;

	/**
	 * Construit un nouvel article
	 * 
	 * @param reference
	 *          reference de l'article
	 */
	
	public Struct(int nb_champs) {
		this.liste = new Object[nb_champs];
	}
	/**
	 * Construit une Struct à partir d'un article sous forme d'Object[]
	 * recupere.
	 * 
	 * @param articleBrut
	 *          Article recupere par SOAP
	 */
	public Struct(Object[] listeBrut) {
		this.liste = listeBrut;
	}
	
	
	public void setStruct(int type,Object[] valeur) {
		if (valeur != null) {
			this.liste[type] = valeur;
		}
	}
	
	public void setStruct(Object[] valeur) {
		if (valeur != null) {
			this.liste = valeur;
		}
	}
	
	public void setString(int type,String valeur) {
		if (valeur != null) {
			this.liste[type] = new String(valeur);
		}
	}
	
	public void setDouble(int type,Double valeur) {
		if (valeur != null) {
			this.liste[type] = new Double(valeur);
		}
	}
	
	public void setLong(int type,long valeur) {
		this.liste[type] = new Long(valeur);
	}
	
	public void setInteger(int type,int valeur) {
		this.liste[type] = new Integer(valeur);
	}

	
	public void setBoolean(int type,Boolean valeur) {
		if (valeur != null) {
			this.liste[type] = new Boolean(valeur);
		}
	}
	
	
	public Object[] getStruct(int type) {
		return (Object[]) this.liste[type];
	}
	
	public String getSqlString(int type) {
		return ToolsMAJ.sqlEncode(""+this.liste[type]);
	}	
	
	public String getSqlString(int type, int max) {
		return max>this.liste[type].toString().length()?ToolsMAJ.sqlEncode(this.liste[type].toString()):ToolsMAJ.sqlEncode(this.liste[type].toString().substring(0, max));
	}	
	
	public String getString(int type) {
		return "" + this.liste[type];
	}	
	
	public String getString(int type, int max) {
		return max>this.liste[type].toString().length()?this.liste[type].toString():this.liste[type].toString().substring(0, max);
	}	

	public double getDouble(int type) {		
		return Double.parseDouble(""+this.liste[type]);
	}	
	
	public int getInteger(int type) {		
		return Integer.parseInt(""+this.liste[type]);
	}		
	
	public boolean getBoolean(int type) {		
		return Boolean.parseBoolean(""+this.liste[type]);
	}	
	/**
	 * Retourne l'article sous forme de tableau d'Object pour etre transmis via
	 * SOAP
	 * 
	 * @return la liste sous forme de tableau
	 */
	public Object[] getStruct() {
		return this.liste;
	}

	/**
	 * Representation textuelle de la liste
	 * 
	 * @return la representation textuelle de la liste
	 */
	public String toString() {
		String rep = "[ ";
		for (int i=0;i<=this.liste.length-1;i++) {
			rep += i+" : " + this.getSqlString(i)+" \n";
		}
		rep += " ]";
		return rep;
	}
}
