-- -----------------------------------------------------------------------------
-- OpenSi : Outils libres de gestion d'entreprise                             --
-- Copyright (C) 2003 Speedinfo.fr S.A.R.L.                                   --
-- Contact: contact@opensi.org                                                --
--                                                                            --
-- This program is free software; you can redistribute it and/or              --
-- modify it under the terms of the GNU General Public License                --
-- as published by the Free Software Foundation; either version 2             --
-- of the License, or (at your option) any later version.                     --
--                                                                            --
-- This program is distributed in the hope that it will be useful,            --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of             --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the               --
-- GNU General Public License for more details.                               --
--                                                                            --
-- You should have received a copy of the GNU General Public License          --
-- along with this program; if not, write to the Free Software                --
-- Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. --
-- -----------------------------------------------------------------------------

-- SCHEMA BASE DE DONNES OPENSI COMPTA << EXERCICE >>


create table SOLDE_COMPTE (
  Numero_Compte    char(8) not null,                       -- Numro de compte
  Lettre           varchar(3) default '',                  -- Dernire lettre utilise pour le lettrage
  Solde            decimal(16,2) default 0,                -- Solde du compte
  Total_Credit     decimal(16,2) default 0,                -- Solde total au crdit
  Total_Debit      decimal(16,2) default 0,                -- Solde total au dbit
  primary key(Numero_Compte)
) engine=InnoDB;


create table NB_OP_JOURNAUX (
  Code_Journal     char(3) not null,                       -- Code d'identification du journal
  Periode          bigint unsigned not null default 0,     -- Mois de l'criture (date au 1er jour du mois)
  Nb_Op            int unsigned default 0,                 -- Nombre d'oprations du journal dans la priode
  primary key(Code_Journal, Periode)
) engine=InnoDB;


create table PERIODE_EXERCICE (
  Periode_Id       int unsigned not null auto_increment,   -- Identifiant de la priode
  Periode          bigint unsigned default 0,              -- Priode
  Cloture          tinyint unsigned default 0,             -- Cloture (oui/non)
  Date_Cloture     bigint unsigned default 0,              -- Date de clture
  primary key(Periode_Id)
) engine=InnoDB;


create table ECRITURE (
  Ecriture_Id      int unsigned not null auto_increment,   -- Identifiant unique de l'criture comptable
  Code_Journal     char(3) not null,                       -- Code du journal rattach  l'criture
  Date_Ecriture    bigint unsigned default 0,              -- Mois de l'criture (date au 1er jour du mois)
  Numero           int unsigned default 0,                 -- Numro de l'criture en liaison avec le code journal
  Etat             char(1) default 'B',                    -- Etat de l'criture (B=Brouillard, V=Valide, T=Temporairement bloque)
  primary key(Ecriture_Id),
  index idx_code_journal (Code_Journal)
) engine=InnoDB;


create table OPERATION (
  Op_Id            int unsigned not null auto_increment,   -- Identifiant unique de l'opration
  Num_Ligne        int unsigned not null,                  -- Numro d'ordre au sein de l'criture
  Ecriture_Id      int unsigned not null,                  -- Identifiant de l'criture comptable
  Numero_Compte    char(8) not null,                       -- Numro de compte
  Montant_D        decimal(14,2) unsigned default 0,       -- Montant de l'opration si dbit sinon 0
  Montant_C        decimal(14,2) unsigned default 0,       -- Montant de l'opration si crdit sinon 0
  Libelle          varchar(100) default '',                -- Libell de l'opration
  Num_Piece        varchar(20) default '',                 -- Numro de pice
  Contrepartie     char(8) default null,                   -- Numro de compte de contrepartie
  Lettre           varchar(3) default '',                  -- Lettre pour lettrage
  Date_Op          bigint unsigned default 0,              -- Date de l'opration
  Date_Echeance    bigint unsigned default 0,              -- Date d'chance
  Mode_Reg_Id      int unsigned default null,              -- Mode de rglement
  Pointage         tinyint unsigned default 0,             -- Pointage de l'opration (oui/non)
  Commentaire      varchar(20) default '',                 -- Commentaire libre sur l'opration
  Date_Lettrage    bigint unsigned default 0,              -- Date de lettrage
  Date_C           bigint unsigned default 0,              -- Date de cration
  Date_M           bigint unsigned default 0,              -- Date de dernire modification
  Util_C           int unsigned not null,                  -- Utilisateur crateur de l'opration
  Util_M           int unsigned not null,                  -- Utilisateur ayant fait la dernire modification
  primary key(Op_Id),
  index idx_numero_compte (Numero_Compte),
  index idx_ecriture_id (Ecriture_Id),
  index idx_mode_reg_id (Mode_Reg_Id),
  constraint cfk_operation_numero_compte foreign key (Numero_Compte) references SOLDE_COMPTE (Numero_Compte),
  constraint cfk_operation_ecriture_id foreign key (Ecriture_Id) references ECRITURE (Ecriture_Id)
) engine=InnoDB;


-- create table ECHEANCE_OPERATION (
--   Echeance_Id      int unsigned not null auto_increment,   -- Identifiant de l'chance
--   Date_Echeance    bigint unsigned default 0,              -- Date d'chance
--   Mode_Reg_Id      int unsigned default null,              -- Identifiant du mode de rglement
--   Montant          decimal(14,2) unsigned default 0,       -- Montant de l'chance
--   primary key(Echeance_Id)
-- ) engine=InnoDB;


